/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.modules;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import mods.railcraft.common.blocks.BlockFactory;
import mods.railcraft.common.modules.IModule;
import mods.railcraft.common.modules.ModuleManager;

public abstract class AbstractModule
implements IModule {
    public final List<BlockFactory> blockFactories = new ArrayList<BlockFactory>();

    public final void addBlockFactory(BlockFactory factory) {
        if (ModuleManager.getStage() != ModuleManager.Stage.PRE_INIT) {
            throw new RuntimeException("You can only define Block Factories in Init!");
        }
        this.blockFactories.add(factory);
    }

    @Override
    public final void initBlocks() {
        for (BlockFactory factory : this.blockFactories) {
            factory.initBlock();
        }
    }

    @Override
    public final void initRecipes(ModuleManager.Module module) {
        for (BlockFactory factory : this.blockFactories) {
            factory.initRecipes(module);
        }
    }

    @Override
    public final void finalizeBlocks(ModuleManager.Module module) {
        for (BlockFactory factory : this.blockFactories) {
            factory.finalizeBlocks(module);
        }
    }

    @Override
    public Set<ModuleManager.Module> getDependancies() {
        return EnumSet.noneOf(ModuleManager.Module.class);
    }

    @Override
    public void preInit() {
    }

    @Override
    public void initFirst() {
    }

    @Override
    public void initSecond() {
    }

    @Override
    public void postInit() {
    }

    @Override
    public void postInitNotLoaded() {
    }

    @Override
    public boolean canModuleLoad() {
        return true;
    }

    @Override
    public void printLoadError() {
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

