/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.items;

import java.util.List;
import java.util.Locale;
import mods.railcraft.common.core.RailcraftLanguage;
import mods.railcraft.common.items.ItemIngot;
import mods.railcraft.common.items.ItemRailcraft;
import mods.railcraft.common.plugins.forestry.ForestryPlugin;
import mods.railcraft.common.plugins.forge.CraftingPlugin;
import mods.railcraft.common.plugins.forge.ItemRegistry;
import mods.railcraft.common.plugins.forge.OreDictPlugin;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.oredict.OreDictionary;

public class ItemNugget
extends ItemRailcraft {
    private static Item item;

    public static ItemStack getNugget(EnumNugget nugget) {
        return ItemNugget.getNugget(nugget, 1);
    }

    public static ItemStack getNugget(EnumNugget nugget, int qty) {
        if (item != null) {
            return new ItemStack(item, qty, nugget.ordinal());
        }
        String tag = "railcraft.nugget";
        item = new ItemNugget();
        ItemRegistry.registerItem(item);
        for (EnumNugget n : EnumNugget.VALUES) {
            ItemStack stack = new ItemStack(item, 1, n.ordinal());
            RailcraftLanguage.instance().registerItemName(stack, item.func_77667_c(stack));
            ItemRegistry.registerItemStack(item.func_77667_c(stack), stack);
            ForestryPlugin.addBackpackItem("miner", stack);
        }
        OreDictionary.registerOre((String)"nuggetIron", (ItemStack)new ItemStack(item, 1, EnumNugget.IRON.ordinal()));
        OreDictionary.registerOre((String)"nuggetSteel", (ItemStack)new ItemStack(item, 1, EnumNugget.STEEL.ordinal()));
        CraftingPlugin.addShapelessRecipe(new ItemStack(item, 9, EnumNugget.IRON.ordinal()), new ItemStack(Items.field_151042_j));
        CraftingPlugin.addShapelessOreRecipe(new ItemStack(item, 9, EnumNugget.STEEL.ordinal()), "ingotSteel");
        CraftingPlugin.addShapedOreRecipe(new ItemStack(Items.field_151042_j), "NNN", "NNN", "NNN", Character.valueOf('N'), "nuggetIron");
        ItemStack ingotSteel = ItemIngot.getIngot(ItemIngot.EnumIngot.STEEL);
        if (ingotSteel == null || ingotSteel.func_77973_b() == Items.field_151042_j) {
            ingotSteel = OreDictPlugin.getOre("ingotSteel", 1);
        }
        if (ingotSteel != null) {
            CraftingPlugin.addShapedOreRecipe(ingotSteel, "NNN", "NNN", "NNN", Character.valueOf('N'), "nuggetSteel");
        }
        return new ItemStack(item, qty, nugget.ordinal());
    }

    public ItemNugget() {
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.func_77655_b("railcraft.nugget");
    }

    @Override
    public void func_94581_a(IIconRegister iconRegister) {
        for (EnumNugget nugget : EnumNugget.VALUES) {
            nugget.icon = iconRegister.func_94245_a("railcraft:nugget." + nugget.name().toLowerCase(Locale.ENGLISH));
        }
    }

    public void func_150895_a(Item id, CreativeTabs tab, List list) {
        for (EnumNugget dust : EnumNugget.VALUES) {
            list.add(new ItemStack((Item)this, 1, dust.ordinal()));
        }
    }

    public IIcon func_77617_a(int damage) {
        if (damage >= EnumNugget.values().length) {
            return EnumNugget.IRON.icon;
        }
        return EnumNugget.VALUES[damage].icon;
    }

    public String func_77667_c(ItemStack stack) {
        int damage = stack.func_77960_j();
        if (damage < 0 || damage >= EnumNugget.VALUES.length) {
            return "";
        }
        switch (EnumNugget.VALUES[damage]) {
            case IRON: {
                return "railcraft.nugget.iron";
            }
            case STEEL: {
                return "railcraft.nugget.steel";
            }
        }
        return "";
    }

    public static enum EnumNugget {
        IRON,
        STEEL;

        private IIcon icon;
        public static EnumNugget[] VALUES;

        static {
            VALUES = EnumNugget.values();
        }
    }
}

