/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.items;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.EnumSet;
import java.util.List;
import mods.railcraft.api.carts.CartTools;
import mods.railcraft.common.blocks.RailcraftTileEntity;
import mods.railcraft.common.blocks.machine.TileMultiBlock;
import mods.railcraft.common.core.Railcraft;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.core.RailcraftLanguage;
import mods.railcraft.common.items.IActivationBlockingItem;
import mods.railcraft.common.items.ItemRailcraft;
import mods.railcraft.common.plugins.forge.ChatPlugin;
import mods.railcraft.common.plugins.forge.CraftingPlugin;
import mods.railcraft.common.plugins.forge.CreativePlugin;
import mods.railcraft.common.plugins.forge.ItemRegistry;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.EntityInteractEvent;

public class ItemMagnifyingGlass
extends ItemRailcraft
implements IActivationBlockingItem {
    private static Item item;

    public static void register() {
        String tag;
        if (item == null && RailcraftConfig.isItemEnabled(tag = "tool.magnifying.glass")) {
            item = new ItemMagnifyingGlass();
            RailcraftLanguage.instance().registerItemName(item, tag);
            ItemRegistry.registerItem(item);
            CraftingPlugin.addShapedRecipe(new ItemStack(item), " G", "S ", Character.valueOf('S'), new ItemStack(Items.field_151055_y), Character.valueOf('G'), new ItemStack(Blocks.field_150410_aZ));
            ItemRegistry.registerItemStack(tag, new ItemStack(item));
        }
    }

    public static ItemStack getItem() {
        if (item == null) {
            return null;
        }
        return new ItemStack(item);
    }

    public ItemMagnifyingGlass() {
        this.func_77656_e(0);
        this.func_77625_d(1);
        this.func_77655_b("railcraft.tool.mag.glass");
        this.func_77664_n();
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.func_77637_a(CreativePlugin.RAILCRAFT_TAB);
    }

    @SubscribeEvent
    public void onEntityInteract(EntityInteractEvent event) {
        EntityPlayer thePlayer = event.entityPlayer;
        Entity entity = event.target;
        ItemStack stack = thePlayer.func_71045_bC();
        if (stack != null && stack.func_77973_b() instanceof ItemMagnifyingGlass) {
            thePlayer.func_71038_i();
        }
        if (Game.isNotHost(thePlayer.field_70170_p)) {
            return;
        }
        if (stack != null && stack.func_77973_b() instanceof ItemMagnifyingGlass && entity instanceof EntityMinecart) {
            EntityMinecart cart = (EntityMinecart)entity;
            ChatPlugin.sendLocalizedChat(thePlayer, "gui.mag.glass.placedby", Railcraft.getProxy().getItemDisplayName(cart.getCartItem()), CartTools.getCartOwner(cart));
            event.setCanceled(true);
        }
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        RailcraftTileEntity tile;
        if (Game.isNotHost(world)) {
            return false;
        }
        TileEntity t = world.func_147438_o(x, y, z);
        boolean returnValue = false;
        if (t instanceof RailcraftTileEntity) {
            tile = (RailcraftTileEntity)t;
            ChatPlugin.sendLocalizedChat(player, "gui.mag.glass.placedby", tile.getName(), tile.getOwner());
            returnValue = true;
        }
        if (t instanceof TileMultiBlock) {
            tile = (TileMultiBlock)t;
            if (((TileMultiBlock)tile).isStructureValid()) {
                ChatPlugin.sendLocalizedChat(player, "multiblock.valid", new Object[0]);
            } else {
                for (TileMultiBlock.MultiBlockStateReturn returnState : EnumSet.complementOf(EnumSet.of(TileMultiBlock.MultiBlockStateReturn.VALID))) {
                    List pats = ((TileMultiBlock)tile).patternStates.get((Object)returnState);
                    if (pats.isEmpty()) continue;
                    ChatPlugin.sendLocalizedChat(player, returnState.message, pats.toString());
                }
            }
            returnValue = true;
        }
        return returnValue;
    }
}

