/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.items;

import java.util.List;
import java.util.Locale;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.core.RailcraftLanguage;
import mods.railcraft.common.items.ItemRailcraft;
import mods.railcraft.common.plugins.forestry.ForestryPlugin;
import mods.railcraft.common.plugins.forge.ItemRegistry;
import mods.railcraft.common.plugins.forge.LootPlugin;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.oredict.OreDictionary;

public class ItemIngot
extends ItemRailcraft {
    private static ItemIngot item;

    public static ItemStack getIngot(EnumIngot ingot) {
        return ItemIngot.getIngot(ingot, 1);
    }

    public static ItemStack getIngot(EnumIngot ingot, int qty) {
        if (item != null) {
            return new ItemStack((Item)item, qty, ingot.ordinal());
        }
        String tag = "railcraft.ingot";
        if (!RailcraftConfig.isItemEnabled(tag)) {
            return new ItemStack(Items.field_151042_j, qty);
        }
        item = new ItemIngot();
        ItemRegistry.registerItem(item);
        for (EnumIngot i : EnumIngot.VALUES) {
            ItemStack stack = new ItemStack((Item)item, 1, i.ordinal());
            RailcraftLanguage.instance().registerItemName(stack, item.func_77667_c(stack));
            ForestryPlugin.addBackpackItem("miner", stack);
            ItemRegistry.registerItemStack(tag + "." + i.name().toLowerCase(Locale.ENGLISH), stack);
        }
        OreDictionary.registerOre((String)"ingotSteel", (ItemStack)new ItemStack((Item)item));
        LootPlugin.addLootTool(new ItemStack((Item)item), 5, 9, "steel.ingot");
        return new ItemStack((Item)item, qty, ingot.ordinal());
    }

    public ItemIngot() {
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.func_77655_b("railcraft.ingot");
        this.setSmeltingExperiance(1.0f);
    }

    @Override
    public void func_94581_a(IIconRegister iconRegister) {
        for (EnumIngot ingot : EnumIngot.VALUES) {
            ingot.icon = iconRegister.func_94245_a("railcraft:ingot." + ingot.name().toLowerCase(Locale.ENGLISH));
        }
    }

    public void func_150895_a(Item id, CreativeTabs tab, List list) {
        for (EnumIngot ingot : EnumIngot.VALUES) {
            list.add(new ItemStack((Item)this, 1, ingot.ordinal()));
        }
    }

    public IIcon func_77617_a(int damage) {
        if (damage >= EnumIngot.VALUES.length) {
            return EnumIngot.STEEL.icon;
        }
        return EnumIngot.VALUES[damage].icon;
    }

    public String func_77667_c(ItemStack stack) {
        int damage = stack.func_77960_j();
        if (damage < 0 || damage >= EnumIngot.VALUES.length) {
            return "railcraft.ingot";
        }
        switch (EnumIngot.VALUES[damage]) {
            case STEEL: {
                return "railcraft.ingot.steel";
            }
        }
        return "railcraft.ingot";
    }

    public static enum EnumIngot {
        STEEL;

        public static final EnumIngot[] VALUES;
        private IIcon icon;

        static {
            VALUES = EnumIngot.values();
        }
    }
}

