/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.gui.widgets;

import mods.railcraft.common.gui.widgets.IndicatorController;

public class EnergyIndicator
extends IndicatorController {
    private double energy;
    private final double maxEnergy;

    public EnergyIndicator(double maxEnergy) {
        this.maxEnergy = maxEnergy;
    }

    @Override
    protected void refreshToolTip() {
        this.tip.text = String.format("%.0f MJ", this.energy);
    }

    @Override
    public int getScaledLevel(int size) {
        double e = Math.min(this.energy, this.maxEnergy);
        return (int)(e * (double)size / this.maxEnergy);
    }

    public void setEnergy(double energy) {
        this.energy = energy;
    }

    public void updateEnergy(double energy) {
        this.energy = (this.energy * 9.0 + energy) / 10.0;
    }
}

