/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.fluids;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.core.RailcraftLanguage;
import mods.railcraft.common.fluids.BlockRailcraftFluid;
import mods.railcraft.common.fluids.BlockRailcraftFluidFinite;
import mods.railcraft.common.fluids.FluidContainers;
import mods.railcraft.common.fluids.Fluids;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialLiquid;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class RailcraftFluids {
    public static final RailcraftFluids INSTANCE = new RailcraftFluids();
    private static Fluid railcraftCreosote;
    private static Fluid railcraftSteam;
    private static Block blockCreosote;
    private static Block blockSteam;

    private RailcraftFluids() {
    }

    public static void preInit() {
        RailcraftFluids.initCreosote();
        RailcraftFluids.initSteam();
    }

    public static void postInit() {
        RailcraftFluids.initCreosoteBlock();
        RailcraftFluids.initSteamBlock();
        if (Fluids.CREOSOTE.get() == null) {
            throw new MissingFluidException("Fluid 'creosote' was not found. Please check your configs.");
        }
        if (Fluids.STEAM.get() == null) {
            throw new MissingFluidException("Fluid 'steam' was not found. Please check your configs.");
        }
    }

    public static void initCreosote() {
        if (railcraftCreosote == null && RailcraftConfig.isFluidEnabled("creosote")) {
            railcraftCreosote = new Fluid("creosote").setDensity(800).setViscosity(1500);
            FluidRegistry.registerFluid((Fluid)railcraftCreosote);
            Fluid fluidCreosote = Fluids.CREOSOTE.get();
            if (fluidCreosote == railcraftCreosote) {
                RailcraftLanguage.instance().pushTagToMinecraft("fluid.creosote");
            }
            RailcraftFluids.initCreosoteBlock();
        }
    }

    public static void initCreosoteBlock() {
        if (blockCreosote != null) {
            return;
        }
        Fluid fluidCreosote = Fluids.CREOSOTE.get();
        if (fluidCreosote == null) {
            return;
        }
        if (fluidCreosote.getBlock() == null) {
            if (RailcraftConfig.isBlockEnabled("fluid.creosote")) {
                blockCreosote = new BlockRailcraftFluid(fluidCreosote, Material.field_151586_h).setFlammable(true).setFlammability(10);
                blockCreosote.func_149663_c("railcraft.block.fluid.creosote");
                GameRegistry.registerBlock((Block)blockCreosote, (String)blockCreosote.func_149739_a());
                RailcraftLanguage.instance().registerItemName(new ItemStack(blockCreosote), "block.fluid.creosote");
                fluidCreosote.setBlock(blockCreosote);
            }
        } else {
            blockCreosote = fluidCreosote.getBlock();
        }
        FluidContainers.getCreosoteOilBucket();
    }

    private static void initSteam() {
        if (railcraftSteam == null && RailcraftConfig.isFluidEnabled("steam")) {
            railcraftSteam = new Fluid("steam").setDensity(-1000).setViscosity(500);
            FluidRegistry.registerFluid((Fluid)railcraftSteam);
            Fluid fluidSteam = Fluids.STEAM.get();
            if (fluidSteam == railcraftSteam) {
                RailcraftLanguage.instance().pushTagToMinecraft("fluid.steam");
            }
            RailcraftFluids.initSteamBlock();
        }
    }

    private static void initSteamBlock() {
        if (blockSteam != null) {
            return;
        }
        Fluid fluidSteam = Fluids.STEAM.get();
        if (fluidSteam == null) {
            return;
        }
        if (fluidSteam.getBlock() == null) {
            if (RailcraftConfig.isBlockEnabled("fluid.steam")) {
                blockSteam = new BlockRailcraftFluidFinite(fluidSteam, (Material)new MaterialLiquid(MapColor.field_151660_b)).setNoFlow();
                blockSteam.func_149663_c("railcraft.block.fluid.steam");
                GameRegistry.registerBlock((Block)blockSteam, (String)blockSteam.func_149739_a());
                RailcraftLanguage.instance().registerItemName(new ItemStack(blockSteam), "block.fluid.steam");
                fluidSteam.setBlock(blockSteam);
            }
        } else {
            blockSteam = fluidSteam.getBlock();
        }
        FluidContainers.getSteamBottle();
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void textureHook(TextureStitchEvent.Post event) {
        if (event.map.func_130086_a() == 0) {
            railcraftCreosote.setIcons(blockCreosote.func_149733_h(1), blockCreosote.func_149733_h(2));
            railcraftSteam.setIcons(blockSteam.func_149733_h(1), blockSteam.func_149733_h(2));
        }
    }

    public static class MissingFluidException
    extends RuntimeException {
        public MissingFluidException(String msg) {
            super(msg);
        }
    }
}

