/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.fluids;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import mods.railcraft.common.fluids.Fluids;
import mods.railcraft.common.fluids.ForestryFluidRegistrar;
import mods.railcraft.common.fluids.ForgeFluidRegistrar;
import mods.railcraft.common.fluids.IFluidRegistrar;
import mods.railcraft.common.fluids.TankManager;
import mods.railcraft.common.fluids.tanks.StandardTank;
import mods.railcraft.common.items.ModItems;
import mods.railcraft.common.plugins.forge.WorldPlugin;
import mods.railcraft.common.util.inventory.InvTools;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;

public final class FluidHelper {
    public static final int BUCKET_FILL_TIME = 8;
    public static final int NETWORK_UPDATE_INTERVAL = 128;
    public static final int BUCKET_VOLUME = 1000;
    private static final List<IFluidRegistrar> adapters = new ArrayList<IFluidRegistrar>();

    private FluidHelper() {
    }

    public static boolean handleRightClick(IFluidHandler tank, ForgeDirection side, EntityPlayer player, boolean fill, boolean drain) {
        if (player == null) {
            return false;
        }
        ItemStack current = player.field_71071_by.func_70448_g();
        if (current != null) {
            ItemStack filled;
            FluidStack available;
            FluidStack liquid = FluidHelper.getFluidStackInContainer(current);
            if (fill && liquid != null) {
                int used = tank.fill(side, liquid, true);
                if (used > 0) {
                    if (!player.field_71075_bZ.field_75098_d) {
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, InvTools.depleteItem(current));
                        player.field_71071_by.func_70296_d();
                    }
                    return true;
                }
            } else if (drain && (available = tank.drain(side, Integer.MAX_VALUE, false)) != null && (liquid = FluidHelper.getFluidStackInContainer(filled = FluidHelper.fillContainer(available, current))) != null) {
                if (current.field_77994_a > 1) {
                    if (!player.field_71071_by.func_70441_a(filled)) {
                        return false;
                    }
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, InvTools.depleteItem(current));
                    player.field_71071_by.func_70296_d();
                } else {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, InvTools.depleteItem(current));
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, filled);
                    player.field_71071_by.func_70296_d();
                }
                tank.drain(side, liquid.amount, true);
                return true;
            }
        }
        return false;
    }

    public static void processContainers(StandardTank tank, IInventory inv, int inputSlot, int outputSlot) {
        FluidHelper.processContainers(tank, inv, inputSlot, outputSlot, tank.getFluidType(), true, true);
    }

    public static void processContainers(StandardTank tank, IInventory inv, int inputSlot, int outputSlot, Fluid fluidToFill, boolean processFilled, boolean processEmpty) {
        TankManager tankManger = new TankManager();
        tankManger.add(tank);
        FluidHelper.processContainers(tankManger, inv, inputSlot, outputSlot, fluidToFill, processFilled, processEmpty);
    }

    public static void processContainers(TankManager tank, IInventory inv, int inputSlot, int outputSlot, Fluid fluidToFill) {
        FluidHelper.processContainers(tank, inv, inputSlot, outputSlot, fluidToFill, true, true);
    }

    public static void processContainers(IFluidHandler fluidHandler, IInventory inv, int inputSlot, int outputSlot, Fluid fluidToFill, boolean processFilled, boolean processEmpty) {
        ItemStack input = inv.func_70301_a(inputSlot);
        if (input == null) {
            return;
        }
        if (processFilled && FluidHelper.drainContainers(fluidHandler, inv, inputSlot, outputSlot)) {
            return;
        }
        if (processEmpty && fluidToFill != null) {
            FluidHelper.fillContainers(fluidHandler, inv, inputSlot, outputSlot, fluidToFill);
        }
    }

    public static boolean fillContainers(IFluidHandler fluidHandler, IInventory inv, int inputSlot, int outputSlot, Fluid fluidToFill) {
        FluidStack fluidInContainer;
        FluidStack drain;
        ItemStack input = inv.func_70301_a(inputSlot);
        ItemStack output = inv.func_70301_a(outputSlot);
        ItemStack filled = FluidHelper.getFilledContainer(fluidToFill, input);
        if (filled != null && (output == null || output.field_77994_a < output.func_77976_d() && InvTools.isItemEqual(filled, output)) && (drain = fluidHandler.drain(ForgeDirection.UNKNOWN, fluidInContainer = FluidHelper.getFluidStackInContainer(filled), false)) != null && drain.amount == fluidInContainer.amount) {
            fluidHandler.drain(ForgeDirection.UNKNOWN, fluidInContainer, true);
            if (output == null) {
                inv.func_70299_a(outputSlot, filled);
            } else {
                ++output.field_77994_a;
            }
            inv.func_70298_a(inputSlot, 1);
            return true;
        }
        return false;
    }

    public static boolean drainContainers(IFluidHandler fluidHandler, IInventory inv, int inputSlot, int outputSlot) {
        ItemStack input = inv.func_70301_a(inputSlot);
        ItemStack output = inv.func_70301_a(outputSlot);
        if (input != null) {
            int used;
            FluidStack fluidInContainer = FluidHelper.getFluidStackInContainer(input);
            ItemStack emptyItem = input.func_77973_b().getContainerItem(input);
            if (fluidInContainer != null && (emptyItem == null || output == null || output.field_77994_a < output.func_77976_d() && InvTools.isItemEqual(output, emptyItem)) && (used = fluidHandler.fill(ForgeDirection.UNKNOWN, fluidInContainer, false)) >= fluidInContainer.amount) {
                fluidHandler.fill(ForgeDirection.UNKNOWN, fluidInContainer, true);
                if (emptyItem != null) {
                    if (output == null) {
                        inv.func_70299_a(outputSlot, emptyItem);
                    } else {
                        ++output.field_77994_a;
                    }
                }
                inv.func_70298_a(inputSlot, 1);
                return true;
            }
        }
        return false;
    }

    public static boolean isBucket(ItemStack stack) {
        return FluidContainerRegistry.isBucket((ItemStack)stack);
    }

    public static boolean isContainer(ItemStack stack) {
        if (stack != null && stack.func_77973_b() instanceof IFluidContainerItem) {
            return true;
        }
        return FluidContainerRegistry.isContainer((ItemStack)stack);
    }

    public static boolean isFilledContainer(ItemStack stack) {
        return FluidContainerRegistry.isFilledContainer((ItemStack)stack);
    }

    public static boolean isEmptyContainer(ItemStack stack) {
        return FluidContainerRegistry.isEmptyContainer((ItemStack)stack);
    }

    public static ItemStack getFilledContainer(Fluid fluid, ItemStack empty) {
        if (fluid == null || empty == null) {
            return null;
        }
        return FluidContainerRegistry.fillFluidContainer((FluidStack)new FluidStack(fluid, Integer.MAX_VALUE), (ItemStack)empty);
    }

    public static ItemStack getFilledContainer(FluidStack fluid, ItemStack empty) {
        if (fluid == null || empty == null) {
            return null;
        }
        fluid = fluid.copy();
        fluid.amount = Integer.MAX_VALUE;
        return FluidContainerRegistry.fillFluidContainer((FluidStack)fluid, (ItemStack)empty);
    }

    public static ItemStack fillContainer(FluidStack liquid, ItemStack empty) {
        if (liquid == null || empty == null) {
            return null;
        }
        return FluidContainerRegistry.fillFluidContainer((FluidStack)liquid, (ItemStack)empty);
    }

    public static FluidStack getFluidStackInContainer(ItemStack stack) {
        return FluidContainerRegistry.getFluidForFilledItem((ItemStack)stack);
    }

    public static Fluid getFluidInContianer(ItemStack stack) {
        FluidStack fluidStack = FluidContainerRegistry.getFluidForFilledItem((ItemStack)stack);
        return fluidStack != null ? fluidStack.getFluid() : null;
    }

    public static boolean containsFluidStack(ItemStack stack, FluidStack fluidStack) {
        return FluidContainerRegistry.containsFluid((ItemStack)stack, (FluidStack)fluidStack);
    }

    public static boolean containsFluid(ItemStack stack, Fluid fluid) {
        return FluidContainerRegistry.containsFluid((ItemStack)stack, (FluidStack)new FluidStack(fluid, 1));
    }

    public static boolean isFluidEqual(FluidStack L1, FluidStack L2) {
        if (L1 == null || L2 == null) {
            return false;
        }
        return L1.isFluidEqual(L2);
    }

    public static boolean registerBucket(FluidStack liquid, ItemStack filled) {
        ItemStack empty = new ItemStack(Items.field_151133_ar);
        return FluidHelper.registerContainer(liquid, filled, empty);
    }

    public static boolean registerBottle(FluidStack liquid, ItemStack filled) {
        ItemStack empty = new ItemStack(Items.field_151069_bo);
        return FluidHelper.registerContainer(liquid, filled, empty);
    }

    public static boolean registerWax(FluidStack liquid, ItemStack filled) {
        ItemStack empty = ModItems.waxCapsule.get();
        return FluidHelper.registerContainer(liquid, filled, empty);
    }

    public static boolean registerRefactory(FluidStack liquid, ItemStack filled) {
        ItemStack empty = ModItems.refractoryEmpty.get();
        return FluidHelper.registerContainer(liquid, filled, empty);
    }

    public static boolean registerCan(FluidStack liquid, ItemStack filled) {
        ItemStack empty = ModItems.canEmpty.get();
        return FluidHelper.registerContainer(liquid, filled, empty);
    }

    public static boolean registerCell(FluidStack liquid, ItemStack filled) {
        ItemStack empty = ModItems.cellEmpty.get();
        return FluidHelper.registerContainer(liquid, filled, empty);
    }

    private static boolean registerContainer(FluidStack fluidStack, ItemStack filled, ItemStack empty) {
        if (empty != null) {
            FluidContainerRegistry.FluidContainerData container = new FluidContainerRegistry.FluidContainerData(fluidStack, filled, empty);
            FluidHelper.registerContainer(container);
            return true;
        }
        return false;
    }

    public static void registerContainer(FluidContainerRegistry.FluidContainerData container) {
        for (IFluidRegistrar adapter : adapters) {
            adapter.registerContainer(container);
        }
    }

    public static Collection<ItemStack> getContainersFilledWith(FluidStack fluidStack) {
        ArrayList<ItemStack> containers = new ArrayList<ItemStack>();
        for (FluidContainerRegistry.FluidContainerData data : FluidContainerRegistry.getRegisteredFluidContainerData()) {
            FluidStack inContainer = FluidHelper.getFluidStackInContainer(data.filledContainer);
            if (inContainer == null || !inContainer.containsFluid(fluidStack)) continue;
            containers.add(data.filledContainer.func_77946_l());
        }
        return containers;
    }

    public static void nerfWaterBottle() {
        for (FluidContainerRegistry.FluidContainerData data : FluidContainerRegistry.getRegisteredFluidContainerData()) {
            if (data.filledContainer.func_77973_b() != Items.field_151068_bn || data.emptyContainer.func_77973_b() != Items.field_151069_bo || !Fluids.WATER.is(data.fluid)) continue;
            data.fluid.amount = 333;
            return;
        }
    }

    public static FluidStack drainBlock(World world, int x, int y, int z, boolean doDrain) {
        return FluidHelper.drainBlock(world.func_147439_a(x, y, z), world, x, y, z, doDrain);
    }

    public static FluidStack drainBlock(Block block, World world, int x, int y, int z, boolean doDrain) {
        if (block instanceof IFluidBlock) {
            IFluidBlock fluidBlock = (IFluidBlock)block;
            if (fluidBlock.canDrain(world, x, y, z)) {
                return fluidBlock.drain(world, x, y, z, doDrain);
            }
        } else {
            if (block == Blocks.field_150355_j || block == Blocks.field_150358_i) {
                int meta = world.func_72805_g(x, y, z);
                if (meta != 0) {
                    return null;
                }
                if (doDrain) {
                    world.func_147468_f(x, y, z);
                }
                return new FluidStack(FluidRegistry.WATER, 1000);
            }
            if (block == Blocks.field_150353_l || block == Blocks.field_150356_k) {
                int meta = world.func_72805_g(x, y, z);
                if (meta != 0) {
                    return null;
                }
                if (doDrain) {
                    world.func_147468_f(x, y, z);
                }
                return new FluidStack(FluidRegistry.LAVA, 1000);
            }
        }
        return null;
    }

    public static boolean isFullFluidBlock(World world, int x, int y, int z) {
        return FluidHelper.isFullFluidBlock(WorldPlugin.getBlock((IBlockAccess)world, x, y, z), world, x, y, z);
    }

    public static boolean isFullFluidBlock(Block block, World world, int x, int y, int z) {
        if (block instanceof BlockLiquid || block instanceof IFluidBlock) {
            return world.func_72805_g(x, y, z) == 0;
        }
        return false;
    }

    public static Fluid getFluid(Block block) {
        if (block instanceof IFluidBlock) {
            return ((IFluidBlock)block).getFluid();
        }
        if (block == Blocks.field_150355_j || block == Blocks.field_150358_i) {
            return FluidRegistry.WATER;
        }
        if (block == Blocks.field_150353_l || block == Blocks.field_150356_k) {
            return FluidRegistry.LAVA;
        }
        return null;
    }

    static {
        adapters.add(ForestryFluidRegistrar.INSTANCE);
        adapters.add(ForgeFluidRegistrar.INSTANCE);
    }
}

