/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.emblems;

import mods.railcraft.common.carts.ItemLocomotive;
import mods.railcraft.common.emblems.ItemEmblem;
import mods.railcraft.common.util.inventory.InvTools;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;

public class LocomotiveEmblemRecipe
implements IRecipe {
    private final ItemStack locomotive;

    public LocomotiveEmblemRecipe(ItemStack locomotive) {
        this.locomotive = locomotive;
    }

    private boolean isEmblem(ItemStack stack) {
        return ItemEmblem.item != null && stack.func_77973_b() == ItemEmblem.item;
    }

    private boolean isLocomotive(ItemStack loco) {
        return InvTools.isItemEqualIgnoreNBT(this.locomotive, loco);
    }

    public boolean func_77569_a(InventoryCrafting craftingGrid, World var2) {
        int numLocomotive = 0;
        int numEmblem = 0;
        for (int slot = 0; slot < craftingGrid.func_70302_i_(); ++slot) {
            ItemStack stack = craftingGrid.func_70301_a(slot);
            if (stack == null) continue;
            if (this.isLocomotive(stack)) {
                ++numLocomotive;
                continue;
            }
            if (this.isEmblem(stack)) {
                ++numEmblem;
                continue;
            }
            return false;
        }
        return numLocomotive == 1 && numEmblem == 1;
    }

    public ItemStack func_77572_b(InventoryCrafting craftingGrid) {
        ItemStack loco = null;
        ItemStack emblem = null;
        for (int slot = 0; slot < craftingGrid.func_70302_i_(); ++slot) {
            ItemStack stack = craftingGrid.func_70301_a(slot);
            if (stack == null) continue;
            if (this.isLocomotive(stack)) {
                loco = stack;
                continue;
            }
            if (this.isEmblem(stack)) {
                emblem = stack;
                continue;
            }
            return null;
        }
        if (loco == null) {
            return null;
        }
        ItemStack result = loco.func_77946_l();
        ItemLocomotive.setEmblem(result, ItemEmblem.getEmblemIdentifier(emblem));
        return result;
    }

    public int func_77570_a() {
        return 2;
    }

    public ItemStack func_77571_b() {
        return this.locomotive;
    }
}

