/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.emblems;

import mods.railcraft.common.blocks.aesthetics.post.EnumPost;
import mods.railcraft.common.util.crafting.DyeHelper;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.misc.EnumColor;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;

public class EmblemPostColorRecipe
implements IRecipe {
    private ItemStack postTemplate;

    public ItemStack getPost() {
        if (this.postTemplate == null) {
            this.postTemplate = EnumPost.EMBLEM.getItem();
        }
        return this.postTemplate;
    }

    private boolean isPost(ItemStack stack) {
        return InvTools.isItemEqual(stack, this.getPost(), true, false);
    }

    private boolean isDye(ItemStack stack) {
        return this.getDyeColor(stack) != null;
    }

    private EnumColor getDyeColor(ItemStack stack) {
        for (EnumColor color : EnumColor.VALUES) {
            if (!InvTools.isItemEqual(stack, DyeHelper.getDyes().get((Object)color))) continue;
            return color;
        }
        return null;
    }

    public boolean func_77569_a(InventoryCrafting craftingGrid, World var2) {
        int numPost = 0;
        int numDye = 0;
        for (int slot = 0; slot < craftingGrid.func_70302_i_(); ++slot) {
            ItemStack stack = craftingGrid.func_70301_a(slot);
            if (stack == null) continue;
            if (this.isDye(stack)) {
                ++numDye;
                continue;
            }
            if (this.isPost(stack)) {
                ++numPost;
                continue;
            }
            return false;
        }
        return numPost == 1 && numDye == 1;
    }

    public ItemStack func_77572_b(InventoryCrafting craftingGrid) {
        ItemStack post = null;
        ItemStack dye = null;
        for (int slot = 0; slot < craftingGrid.func_70302_i_(); ++slot) {
            ItemStack stack = craftingGrid.func_70301_a(slot);
            if (stack == null) continue;
            if (this.isPost(stack)) {
                post = stack;
                continue;
            }
            if (this.isDye(stack)) {
                dye = stack;
                continue;
            }
            return null;
        }
        if (post == null) {
            return null;
        }
        ItemStack result = post.func_77946_l();
        result = InvTools.setItemColor(result, this.getDyeColor(dye));
        return result;
    }

    public int func_77570_a() {
        return 2;
    }

    public ItemStack func_77571_b() {
        return this.getPost();
    }
}

