/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.core;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Ints;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStoppingEvent;
import java.io.File;
import mods.railcraft.api.fuel.FuelManager;
import mods.railcraft.common.blocks.aesthetics.cube.EnumCube;
import mods.railcraft.common.blocks.aesthetics.post.EnumPost;
import mods.railcraft.common.blocks.machine.alpha.EnumMachineAlpha;
import mods.railcraft.common.blocks.machine.beta.EnumMachineBeta;
import mods.railcraft.common.blocks.machine.gamma.EnumMachineGamma;
import mods.railcraft.common.blocks.signals.EnumSignal;
import mods.railcraft.common.carts.LinkageManager;
import mods.railcraft.common.core.CommonProxy;
import mods.railcraft.common.core.StartupChecks;
import mods.railcraft.common.modules.ModuleManager;
import mods.railcraft.common.plugins.craftguide.CraftGuidePlugin;
import mods.railcraft.common.plugins.forge.ItemRegistry;
import mods.railcraft.common.util.inventory.filters.StackFilter;
import mods.railcraft.common.util.misc.BallastRegistry;
import mods.railcraft.common.util.misc.BlinkTick;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.network.PacketHandler;
import net.minecraft.block.Block;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import org.apache.logging.log4j.Level;

@Mod(modid="Railcraft", name="Railcraft", version="@VERSION@", certificateFingerprint="a0c255ac501b2749537d5824bb0f0588bf0320fa", acceptedMinecraftVersions="[1.7,1.8)", dependencies="required-after:Forge@[10.12.1.1060,);after:BuildCraft|Core[4.2,);after:BuildCraft|Energy;after:BuildCraft|Builders;after:BuildCraft|Factory;after:BuildCraftAPI|gates[2.0,);after:BuildCraftAPI|power[1.1,);after:Forestry;after:Thaumcraft;after:IC2@[2.0.140,)")
public final class Railcraft {
    public static final String MOD_ID = "Railcraft";
    public static final String VERSION = "@VERSION@";
    @Mod.Instance(value="Railcraft")
    public static Railcraft instance;
    private File configFolder;
    @SidedProxy(clientSide="mods.railcraft.client.core.ClientProxy", serverSide="mods.railcraft.common.core.CommonProxy")
    public static CommonProxy proxy;
    public static boolean thisIsFalse;

    public static CommonProxy getProxy() {
        return proxy;
    }

    public static Railcraft getMod() {
        return instance;
    }

    public static String getModId() {
        return MOD_ID;
    }

    public static String getVersion() {
        return VERSION;
    }

    public File getConfigFolder() {
        return this.configFolder;
    }

    @Mod.EventHandler
    public void processIMCRequests(FMLInterModComms.IMCEvent event) {
        Splitter splitter = Splitter.on((String)"@").trimResults();
        for (FMLInterModComms.IMCMessage mess : event.getMessages()) {
            String[] tokens;
            if (mess.key.equals("ballast")) {
                tokens = (String[])Iterables.toArray((Iterable)splitter.split((CharSequence)mess.getStringValue()), String.class);
                if (tokens.length != 2) {
                    Game.log(Level.WARN, String.format("Mod %s attempted to register a ballast, but failed: %s", mess.getSender(), mess.getStringValue()), new Object[0]);
                    continue;
                }
                String blockName = tokens[0];
                Integer metadata = Ints.tryParse((String)tokens[1]);
                if (blockName == null || metadata == null) {
                    Game.log(Level.WARN, String.format("Mod %s attempted to register a ballast, but failed: %s", mess.getSender(), mess.getStringValue()), new Object[0]);
                    continue;
                }
                BallastRegistry.registerBallast(Block.func_149684_b((String)blockName), metadata);
                Game.log(Level.INFO, String.format("Mod %s registered %s as a valid ballast", mess.getSender(), mess.getStringValue()), new Object[0]);
                continue;
            }
            if (mess.key.equals("boiler-fuel-liquid")) {
                tokens = (String[])Iterables.toArray((Iterable)splitter.split((CharSequence)mess.getStringValue()), String.class);
                if (tokens.length != 2) {
                    Game.log(Level.WARN, String.format("Mod %s attempted to register a liquid Boiler fuel, but failed: %s", mess.getSender(), mess.getStringValue()), new Object[0]);
                    continue;
                }
                Fluid fluid = FluidRegistry.getFluid((String)tokens[0]);
                Integer fuel = Ints.tryParse((String)tokens[1]);
                if (fluid == null || fuel == null) {
                    Game.log(Level.WARN, String.format("Mod %s attempted to register a liquid Boiler fuel, but failed: %s", mess.getSender(), mess.getStringValue()), new Object[0]);
                    continue;
                }
                FuelManager.addBoilerFuel(fluid, fuel);
                Game.log(Level.INFO, String.format("Mod %s registered %s as a valid liquid Boiler fuel", mess.getSender(), mess.getStringValue()), new Object[0]);
                continue;
            }
            if (!mess.key.equals("securityViolation")) continue;
        }
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        PacketHandler.init();
        this.configFolder = new File(event.getModConfigurationDirectory(), "railcraft");
        StartupChecks.checkForNewVersion();
        StackFilter.initialize();
        ModuleManager.preInit();
        proxy.preInitClient();
        FMLInterModComms.sendMessage((String)"OpenBlocks", (String)"donateUrl", (String)"http://www.railcraft.info/donate/");
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        ModuleManager.init();
        FMLCommonHandler.instance().bus().register((Object)new BlinkTick());
        for (EnumMachineAlpha enumMachineAlpha : EnumMachineAlpha.values()) {
            if (!enumMachineAlpha.isAvaliable()) continue;
            ItemRegistry.registerItemStack(enumMachineAlpha.getTag(), enumMachineAlpha.getItem());
        }
        for (Enum enum_ : EnumMachineBeta.values()) {
            if (!((EnumMachineBeta)enum_).isAvaliable()) continue;
            ItemRegistry.registerItemStack(((EnumMachineBeta)enum_).getTag(), ((EnumMachineBeta)enum_).getItem());
        }
        for (Enum enum_ : EnumMachineGamma.values()) {
            if (!((EnumMachineGamma)enum_).isAvaliable()) continue;
            ItemRegistry.registerItemStack(((EnumMachineGamma)enum_).getTag(), ((EnumMachineGamma)enum_).getItem());
        }
        for (Enum enum_ : EnumSignal.values()) {
            if (!((EnumSignal)enum_).isEnabled()) continue;
            ItemRegistry.registerItemStack(((EnumSignal)enum_).getTag(), ((EnumSignal)enum_).getItem());
        }
        for (Enum enum_ : EnumCube.values()) {
            if (!((EnumCube)enum_).isEnabled()) continue;
            ItemRegistry.registerItemStack(((EnumCube)enum_).getTag(), ((EnumCube)enum_).getItem());
        }
        for (Enum enum_ : EnumPost.values()) {
            if (!((EnumPost)enum_).isEnabled()) continue;
            ItemRegistry.registerItemStack(((EnumPost)enum_).getTag(), ((EnumPost)enum_).getItem());
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        ModuleManager.postInit();
        proxy.initClient();
        CraftGuidePlugin.init();
    }

    @Mod.EventHandler
    public void serverCleanUp(FMLServerStoppingEvent event) {
        LinkageManager.reset();
    }

    static {
        thisIsFalse = false;
    }
}

