/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.carts;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mods.railcraft.api.carts.locomotive.LocomotiveModelRenderer;
import mods.railcraft.api.carts.locomotive.LocomotiveRenderType;
import mods.railcraft.client.emblems.EmblemPackageManager;
import mods.railcraft.client.render.RenderTools;
import mods.railcraft.common.carts.EnumCart;
import mods.railcraft.common.carts.ItemCart;
import mods.railcraft.common.core.RailcraftLanguage;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.misc.EnumColor;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;

public class ItemLocomotive
extends ItemCart {
    private final LocomotiveRenderType renderType;

    public ItemLocomotive(EnumCart cart, LocomotiveRenderType renderType) {
        super(cart);
        this.renderType = renderType;
        this.func_77625_d(1);
    }

    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        list.add(new ItemStack((Item)this));
    }

    @Override
    public void func_94581_a(IIconRegister iconRegister) {
        this.renderType.registerIcons(iconRegister);
    }

    public boolean func_77623_v() {
        return true;
    }

    public int getRenderPasses(int metadata) {
        return 3;
    }

    public int func_82790_a(ItemStack stack, int pass) {
        switch (pass) {
            case 0: {
                return ItemLocomotive.getPrimaryColor(stack).getHexColor();
            }
            case 1: {
                return ItemLocomotive.getSecondaryColor(stack).getHexColor();
            }
        }
        return super.func_82790_a(stack, pass);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int pass) {
        String rendererTag = ItemLocomotive.getModel(stack);
        LocomotiveModelRenderer renderer = this.renderType.getRenderer(rendererTag);
        if (renderer == null) {
            return RenderTools.getMissingIcon();
        }
        return renderer.getItemIcons()[pass];
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List info, boolean adv) {
        String model;
        LocomotiveModelRenderer renderer;
        String owner = ItemLocomotive.getOwner(stack);
        if (!owner.equals("")) {
            String format = RailcraftLanguage.translate("gui.locomotive.tip.item.owner");
            info.add(String.format(format, owner));
        }
        String modelName = (renderer = this.renderType.getRenderer(model = ItemLocomotive.getModel(stack))) != null ? renderer.getDisplayName() : RailcraftLanguage.translate("gui.locomotive.tip.item.model.default");
        String format = RailcraftLanguage.translate("gui.locomotive.tip.item.model");
        info.add(String.format(format, modelName));
        EnumColor primary = ItemLocomotive.getPrimaryColor(stack);
        format = RailcraftLanguage.translate("gui.locomotive.tip.item.primary");
        info.add(String.format(format, primary.getTranslatedName()));
        EnumColor secondary = ItemLocomotive.getSecondaryColor(stack);
        format = RailcraftLanguage.translate("gui.locomotive.tip.item.secondary");
        info.add(String.format(format, secondary.getTranslatedName()));
        float whistle = ItemLocomotive.getWhistlePitch(stack);
        format = RailcraftLanguage.translate("gui.locomotive.tip.item.whistle");
        info.add(String.format(format, whistle < 0.0f ? "???" : String.format("%.2f", Float.valueOf(whistle))));
        String emblemIdent = ItemLocomotive.getEmblem(stack);
        if (emblemIdent != null && !emblemIdent.equals("")) {
            EmblemPackageManager.Emblem emblem = EmblemPackageManager.getEmblem(emblemIdent);
            format = RailcraftLanguage.translate("gui.locomotive.tip.item.emblem");
            info.add(String.format(format, emblem.displayName));
        }
    }

    public static void setItemColorData(ItemStack stack, int primaryColor, int secondaryColor) {
        if (primaryColor < 0 || secondaryColor < 0) {
            return;
        }
        NBTTagCompound nbt = InvTools.getItemData(stack);
        nbt.func_74774_a("primaryColor", (byte)primaryColor);
        nbt.func_74774_a("secondaryColor", (byte)secondaryColor);
    }

    public static void setItemWhistleData(ItemStack stack, float whistlePitch) {
        NBTTagCompound nbt = InvTools.getItemData(stack);
        nbt.func_74776_a("whistlePitch", whistlePitch);
    }

    public static float getWhistlePitch(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null || !nbt.func_74764_b("whistlePitch")) {
            return -1.0f;
        }
        return nbt.func_74760_g("whistlePitch");
    }

    public static void setOwnerData(ItemStack stack, String owner) {
        NBTTagCompound nbt = InvTools.getItemData(stack);
        nbt.func_74778_a("owner", owner);
    }

    public static String getOwner(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null || !nbt.func_74764_b("owner")) {
            return "";
        }
        return nbt.func_74779_i("owner");
    }

    public static void setEmblem(ItemStack stack, String emblemIdentifier) {
        NBTTagCompound nbt = InvTools.getItemData(stack);
        nbt.func_74778_a("emblem", emblemIdentifier);
    }

    public static String getEmblem(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null || !nbt.func_74764_b("emblem")) {
            return "";
        }
        return nbt.func_74779_i("emblem");
    }

    public static void setModel(ItemStack stack, String modelTag) {
        NBTTagCompound nbt = InvTools.getItemData(stack);
        nbt.func_74778_a("model", modelTag);
    }

    public static String getModel(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null || !nbt.func_74764_b("model")) {
            return "default";
        }
        return nbt.func_74779_i("model");
    }

    public static EnumColor getPrimaryColor(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null || !nbt.func_74764_b("primaryColor")) {
            return EnumColor.LIGHT_GRAY;
        }
        return EnumColor.fromId(nbt.func_74771_c("primaryColor"));
    }

    public static EnumColor getSecondaryColor(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null || !nbt.func_74764_b("secondaryColor")) {
            return EnumColor.GRAY;
        }
        return EnumColor.fromId(nbt.func_74771_c("secondaryColor"));
    }
}

