/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.carts;

import cpw.mods.fml.common.ObfuscationReflectionHelper;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import mods.railcraft.api.carts.CartTools;
import mods.railcraft.api.carts.ILinkableCart;
import mods.railcraft.api.carts.IMinecart;
import mods.railcraft.api.carts.IPaintedCart;
import mods.railcraft.api.carts.IRefuelableCart;
import mods.railcraft.api.carts.IRoutableCart;
import mods.railcraft.api.carts.locomotive.LocomotiveRenderType;
import mods.railcraft.common.blocks.signals.ISecure;
import mods.railcraft.common.carts.CartContainerBase;
import mods.railcraft.common.carts.CartUtils;
import mods.railcraft.common.carts.DamageSourceTrain;
import mods.railcraft.common.carts.EnumCart;
import mods.railcraft.common.carts.IDirectionalCart;
import mods.railcraft.common.carts.ItemCart;
import mods.railcraft.common.carts.ItemLocomotive;
import mods.railcraft.common.carts.LinkageManager;
import mods.railcraft.common.carts.Train;
import mods.railcraft.common.core.Railcraft;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.core.RailcraftLanguage;
import mods.railcraft.common.gui.buttons.IMultiButtonState;
import mods.railcraft.common.gui.buttons.LockButtonState;
import mods.railcraft.common.gui.buttons.MultiButtonController;
import mods.railcraft.common.items.ItemOveralls;
import mods.railcraft.common.items.ItemTicket;
import mods.railcraft.common.items.ItemWhistleTuner;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.misc.EnumColor;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.MiscTools;
import mods.railcraft.common.util.network.IGuiReturnHandler;
import mods.railcraft.common.util.sounds.SoundHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public abstract class EntityLocomotive
extends CartContainerBase
implements IDirectionalCart,
IGuiReturnHandler,
ILinkableCart,
IMinecart,
ISecure,
IPaintedCart,
IRoutableCart,
IRefuelableCart,
IEntityAdditionalSpawnData {
    private static final byte HAS_FUEL_DATA_ID = 16;
    private static final byte PRIMARY_COLOR_DATA_ID = 25;
    private static final byte SECONDARY_COLOR_DATA_ID = 26;
    private static final byte LOCOMOTIVE_MODE_DATA_ID = 27;
    private static final byte LOCOMOTIVE_SPEED_DATA_ID = 28;
    private static final byte EMBLEM_DATA_ID = 29;
    private static final double DRAG_FACTOR = 0.9;
    private static final float HS_FORCE_BONUS = 3.5f;
    private static final byte FUEL_USE_INTERVAL = 8;
    private static final byte KNOCKBACK = 1;
    private static final int WHISTLE_INTERVAL = 256;
    private static final int WHISTLE_DELAY = 160;
    private static final int WHISTLE_CHANCE = 4;
    private String model = "";
    private int fuel;
    private int update = MiscTools.getRand().nextInt();
    private int whistleDelay;
    private int tempIdle;
    private float whistlePitch = this.getNewWhistlePitch();
    protected float renderYaw;
    public LocoMode clientMode = LocoMode.SHUTDOWN;
    public LocoSpeed clientSpeed = LocoSpeed.MAX;
    public boolean clientCanLock;
    private final MultiButtonController<LockButtonState> lockController = new MultiButtonController(0, (IMultiButtonState[])LockButtonState.VALUES);

    public EntityLocomotive(World world) {
        super(world);
        this.setPrimaryColor(EnumColor.LIGHT_GRAY.ordinal());
        this.setSecondaryColor(EnumColor.GRAY.ordinal());
    }

    public EntityLocomotive(World world, double x, double y, double z) {
        this(world);
        this.func_70107_b(x, y + (double)this.field_70129_M, z);
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)0);
        this.field_70180_af.func_75682_a(25, (Object)0);
        this.field_70180_af.func_75682_a(26, (Object)0);
        this.field_70180_af.func_75682_a(27, (Object)0);
        this.field_70180_af.func_75682_a(28, (Object)0);
        this.field_70180_af.func_75682_a(29, (Object)"");
    }

    @Override
    public void initEntityFromItem(ItemStack item) {
        NBTTagCompound nbt = item.func_77978_p();
        if (nbt == null) {
            return;
        }
        if (nbt.func_74764_b("primaryColor")) {
            this.setPrimaryColor(nbt.func_74771_c("primaryColor"));
        }
        if (nbt.func_74764_b("secondaryColor")) {
            this.setSecondaryColor(nbt.func_74771_c("secondaryColor"));
        }
        if (nbt.func_74764_b("whistlePitch")) {
            this.whistlePitch = nbt.func_74760_g("whistlePitch");
        }
        if (nbt.func_74764_b("owner")) {
            CartTools.setCartOwner((EntityMinecart)this, nbt.func_74779_i("owner"));
            this.setSecure(true);
        }
        if (nbt.func_74764_b("emblem")) {
            this.setEmblem(nbt.func_74779_i("emblem"));
        }
        if (nbt.func_74764_b("model")) {
            this.model = nbt.func_74779_i("model");
        }
    }

    public abstract EnumCart getCartType();

    @Override
    public boolean doesCartMatchFilter(ItemStack stack, EntityMinecart cart) {
        return ItemCart.getCartType(stack) == this.getCartType();
    }

    @Override
    public String getName() {
        return RailcraftLanguage.translate(this.getCartType().getTag());
    }

    @Override
    public MultiButtonController<LockButtonState> getLockController() {
        return this.lockController;
    }

    @Override
    public String getOwner() {
        return CartTools.getCartOwner((EntityMinecart)this);
    }

    private float getNewWhistlePitch() {
        return 1.0f + (float)this.field_70146_Z.nextGaussian() * 0.2f;
    }

    @Override
    public List<ItemStack> getItemsDropped() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        items.add(this.getCartItem());
        return items;
    }

    @Override
    public ItemStack getCartItem() {
        ItemStack item = this.getCartItemBase();
        if (this.isSecure() && CartTools.doesCartHaveOwner((EntityMinecart)this)) {
            ItemLocomotive.setOwnerData(item, CartTools.getCartOwner((EntityMinecart)this));
        }
        ItemLocomotive.setItemColorData(item, this.getPrimaryColor(), this.getSecondaryColor());
        ItemLocomotive.setItemWhistleData(item, this.whistlePitch);
        return item;
    }

    protected abstract ItemStack getCartItemBase();

    @Override
    public boolean isSecure() {
        return this.lockController.getButtonState() == LockButtonState.LOCKED;
    }

    public void setSecure(boolean secure) {
        this.lockController.setCurrentState(secure ? LockButtonState.LOCKED : LockButtonState.UNLOCKED);
    }

    public String getEmblem() {
        return this.field_70180_af.func_75681_e(29);
    }

    public void setEmblem(String emblem) {
        if (!this.getEmblem().equals(emblem)) {
            this.field_70180_af.func_75692_b(29, (Object)emblem);
        }
    }

    public LocoMode getMode() {
        return LocoMode.VALUES[this.field_70180_af.func_75683_a(27)];
    }

    public void setMode(LocoMode mode) {
        if (this.getMode() != mode) {
            this.field_70180_af.func_75692_b(27, (Object)((byte)mode.ordinal()));
        }
    }

    public LocoSpeed getSpeed() {
        return LocoSpeed.VALUES[this.field_70180_af.func_75683_a(28)];
    }

    public void setSpeed(LocoSpeed speed) {
        if (this.getSpeed() != speed) {
            this.field_70180_af.func_75692_b(28, (Object)((byte)speed.ordinal()));
        }
    }

    public void increaseSpeed() {
        LocoSpeed speed = this.getSpeed();
        if (speed != LocoSpeed.MAX) {
            this.field_70180_af.func_75692_b(28, (Object)((byte)(speed.ordinal() - 1)));
        }
    }

    public void decreaseSpeed() {
        LocoSpeed speed = this.getSpeed();
        if (speed != LocoSpeed.REVERSE) {
            this.field_70180_af.func_75692_b(28, (Object)((byte)(speed.ordinal() + 1)));
        }
    }

    public boolean hasFuel() {
        return this.field_70180_af.func_75683_a(16) != 0;
    }

    public void setHasFuel(boolean powered) {
        this.field_70180_af.func_75692_b(16, (Object)((byte)(powered ? 1 : 0)));
    }

    public boolean isRunning() {
        return this.fuel > 0 && this.getMode() == LocoMode.RUNNING && !this.isIdle() && !this.isShutdown();
    }

    public boolean isIdle() {
        if (this.isShutdown()) {
            return false;
        }
        return this.tempIdle > 0 || this.getMode() == LocoMode.IDLE || Train.getTrain((EntityMinecart)this).isIdle();
    }

    public boolean isShutdown() {
        return this.getMode() == LocoMode.SHUTDOWN || Train.getTrain((EntityMinecart)this).isStopped();
    }

    public void forceIdle(int ticks) {
        this.tempIdle = Math.max(this.tempIdle, ticks);
    }

    @Override
    public void reverse() {
        this.field_70177_z += 180.0f;
        this.field_70159_w = -this.field_70159_w;
        this.field_70179_y = -this.field_70179_y;
    }

    @Override
    public void setRenderYaw(float yaw) {
        this.renderYaw = yaw;
    }

    public abstract String getWhistle();

    public final void whistle() {
        if (this.whistleDelay <= 0) {
            SoundHelper.playSoundAtEntity((Entity)this, this.getWhistle(), 1.0f, this.whistlePitch);
            this.whistleDelay = 160;
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        ++this.update;
        if (Game.isNotHost(this.field_70170_p)) {
            return;
        }
        this.processTicket();
        this.updateFuel();
        if (this.whistleDelay > 0) {
            --this.whistleDelay;
        }
        if (this.tempIdle > 0) {
            --this.tempIdle;
        }
        if (this.update % 256 == 0 && this.isRunning() && this.field_70146_Z.nextInt(4) == 0) {
            this.whistle();
        }
        if (this.isShutdown()) {
            double yaw = (double)this.field_70177_z * Math.PI / 180.0;
            double cos = Math.cos(yaw);
            double sin = Math.sin(yaw);
            float limit = 0.05f;
            if (this.field_70159_w > (double)limit && cos < 0.0) {
                this.field_70177_z += 180.0f;
            } else if (this.field_70159_w < (double)(-limit) && cos > 0.0) {
                this.field_70177_z += 180.0f;
            } else if (this.field_70179_y > (double)limit && sin < 0.0) {
                this.field_70177_z += 180.0f;
            } else if (this.field_70179_y < (double)(-limit) && sin > 0.0) {
                this.field_70177_z += 180.0f;
            }
        }
    }

    @Override
    public String getDestination() {
        ItemStack stack = this.getTicketInventory().func_70301_a(1);
        return ItemTicket.getDestination(stack);
    }

    @Override
    public boolean setDestination(ItemStack ticket) {
        if (ticket != null && ticket.func_77973_b() instanceof ItemTicket) {
            if (this.isSecure() && !ItemTicket.matchesOwnerOrOp(ticket, CartTools.getCartOwner((EntityMinecart)this))) {
                return false;
            }
            String dest = ItemTicket.getDestination(ticket);
            if (!dest.equals(this.getDestination())) {
                this.getTicketInventory().func_70299_a(1, ItemTicket.copyTicket(ticket));
                return true;
            }
        }
        return false;
    }

    protected abstract IInventory getTicketInventory();

    private void processTicket() {
        IInventory invTicket = this.getTicketInventory();
        ItemStack stack = invTicket.func_70301_a(0);
        if (stack != null) {
            if (stack.func_77973_b() instanceof ItemTicket) {
                if (this.setDestination(stack)) {
                    invTicket.func_70299_a(0, InvTools.depleteItem(stack));
                }
            } else {
                invTicket.func_70299_a(0, null);
            }
        }
    }

    protected void func_94101_h() {
        this.field_70159_w *= this.getDrag();
        this.field_70181_x *= 0.0;
        this.field_70179_y *= this.getDrag();
        LocoSpeed speed = this.getSpeed();
        if (this.isRunning()) {
            float force = (float)RailcraftConfig.locomotiveHorsepower() * 0.006f;
            switch (speed) {
                case REVERSE: {
                    force = -force;
                    break;
                }
                case MAX: {
                    boolean highSpeed = this.getEntityData().func_74767_n("HighSpeed");
                    if (!highSpeed) break;
                    force *= 3.5f;
                }
            }
            double yaw = (double)this.field_70177_z * Math.PI / 180.0;
            this.field_70159_w += Math.cos(yaw) * (double)force;
            this.field_70179_y += Math.sin(yaw) * (double)force;
        }
        if (speed != LocoSpeed.MAX) {
            float limit = 0.4f;
            switch (speed) {
                case REVERSE: 
                case SLOWEST: {
                    limit = 0.1f;
                    break;
                }
                case SLOWER: {
                    limit = 0.2f;
                    break;
                }
                case SLOW: {
                    limit = 0.3f;
                }
            }
            this.field_70159_w = Math.copySign(Math.min(Math.abs(this.field_70159_w), (double)limit), this.field_70159_w);
            this.field_70179_y = Math.copySign(Math.min(Math.abs(this.field_70179_y), (double)limit), this.field_70179_y);
        }
    }

    private int getFuelUse() {
        if (this.isRunning()) {
            LocoSpeed speed = this.getSpeed();
            switch (speed) {
                case REVERSE: 
                case SLOWEST: {
                    return 2;
                }
                case SLOWER: {
                    return 4;
                }
                case SLOW: {
                    return 6;
                }
            }
            return 8;
        }
        if (this.isIdle()) {
            return 1;
        }
        return 0;
    }

    protected void updateFuel() {
        int newFuel;
        if (this.update % 8 == 0 && this.fuel > 0) {
            this.fuel -= this.getFuelUse();
            if (this.fuel < 0) {
                this.fuel = 0;
            }
        }
        while (this.fuel <= 8 && !this.isShutdown() && (newFuel = this.getMoreGoJuice()) > 0) {
            this.fuel += newFuel;
        }
        this.setHasFuel(this.fuel > 0);
    }

    private boolean cartVelocityIsGreaterThan(float vel) {
        return Math.abs(this.field_70159_w) > (double)vel || Math.abs(this.field_70179_y) > (double)vel;
    }

    private boolean isKillabledEntity(Entity entity) {
        if (entity.field_70154_o instanceof EntityMinecart) {
            return false;
        }
        if (!(entity instanceof EntityLivingBase)) {
            return false;
        }
        return ((EntityLivingBase)entity).func_110138_aP() < 100.0f;
    }

    public int getDamageToRoadKill(EntityLivingBase entity) {
        if (entity instanceof EntityPlayer && ItemOveralls.isPlayerWearing((EntityPlayer)entity)) {
            ItemStack pants = ((EntityPlayer)entity).func_82169_q(MiscTools.ArmorSlots.LEGS.ordinal());
            InvTools.damageItem(pants, 5);
            return 4;
        }
        return 25;
    }

    public void func_70108_f(Entity entity) {
        if (Game.isHost(this.field_70170_p)) {
            EntityLocomotive otherLoco;
            LinkageManager lm;
            if (entity.field_70128_L) {
                return;
            }
            if (entity != this.field_70153_n && this.cartVelocityIsGreaterThan(0.2f) && this.isKillabledEntity(entity)) {
                EntityLivingBase living = (EntityLivingBase)entity;
                if (RailcraftConfig.locomotiveDamageMobs()) {
                    living.func_70097_a((DamageSource)DamageSourceTrain.INSTANCE, (float)this.getDamageToRoadKill(living));
                }
                if (living.func_110143_aJ() > 0.0f) {
                    float yaw = (this.field_70177_z - 90.0f) * (float)Math.PI / 180.0f;
                    living.func_70024_g((double)(-MathHelper.func_76126_a((float)yaw) * 1.0f * 0.5f), 0.2, (double)(MathHelper.func_76134_b((float)yaw) * 1.0f * 0.5f));
                }
                return;
            }
            if (entity instanceof EntityLocomotive && !(lm = LinkageManager.instance()).areInSameTrain((EntityMinecart)this, (EntityMinecart)(otherLoco = (EntityLocomotive)entity)) && this.cartVelocityIsGreaterThan(0.2f) && otherLoco.cartVelocityIsGreaterThan(0.2f) && (Math.abs(this.field_70159_w - entity.field_70159_w) > (double)0.3f || Math.abs(this.field_70179_y - entity.field_70179_y) > (double)0.3f)) {
                this.explode();
                if (!otherLoco.field_70128_L) {
                    otherLoco.explode();
                }
                return;
            }
        }
        super.func_70108_f(entity);
    }

    @Override
    public void func_94095_a(DamageSource par1DamageSource) {
        this.getTicketInventory().func_70299_a(1, null);
        super.func_94095_a(par1DamageSource);
    }

    @Override
    public void func_70106_y() {
        this.getTicketInventory().func_70299_a(1, null);
        super.func_70106_y();
    }

    protected void explode() {
        CartUtils.explodeCart((EntityMinecart)this);
        this.func_70106_y();
    }

    public abstract int getMoreGoJuice();

    @Override
    public double getDrag() {
        return 0.9;
    }

    @Override
    public boolean doInteract(EntityPlayer player) {
        ItemStack current = player.func_71045_bC();
        if (current != null && current.func_77973_b() instanceof ItemWhistleTuner) {
            if (this.whistleDelay <= 0) {
                this.whistlePitch = this.getNewWhistlePitch();
                this.whistle();
                current.func_77972_a(1, (EntityLivingBase)player);
            }
            return true;
        }
        return false;
    }

    public void func_70014_b(NBTTagCompound data) {
        super.func_70014_b(data);
        Boolean isInReverse = (Boolean)ObfuscationReflectionHelper.getPrivateValue(EntityMinecart.class, (Object)this, (int)0);
        data.func_74757_a("isInReverse", isInReverse.booleanValue());
        data.func_74778_a("model", this.model);
        data.func_74778_a("emblem", this.getEmblem());
        data.func_74774_a("locomode", (byte)this.getMode().ordinal());
        data.func_74774_a("locospeed", (byte)this.getSpeed().ordinal());
        data.func_74774_a("primaryColor", this.getPrimaryColor());
        data.func_74774_a("secondaryColor", this.getSecondaryColor());
        data.func_74776_a("whistlePitch", this.whistlePitch);
        data.func_74768_a("fuel", this.fuel);
        this.lockController.writeToNBT(data, "lock");
    }

    public void func_70037_a(NBTTagCompound data) {
        super.func_70037_a(data);
        ObfuscationReflectionHelper.setPrivateValue(EntityMinecart.class, (Object)this, (Object)data.func_74767_n("isInReverse"), (int)0);
        this.model = data.func_74779_i("model");
        this.setEmblem(data.func_74779_i("emblem"));
        this.setMode(LocoMode.values()[data.func_74771_c("locomode")]);
        this.setSpeed(LocoSpeed.values()[data.func_74771_c("locospeed")]);
        this.setPrimaryColor(data.func_74771_c("primaryColor"));
        this.setSecondaryColor(data.func_74771_c("secondaryColor"));
        this.whistlePitch = data.func_74760_g("whistlePitch");
        this.fuel = data.func_74762_e("fuel");
        this.lockController.readFromNBT(data, "lock");
    }

    @Override
    public void writeGuiData(DataOutputStream data) throws IOException {
        data.writeByte(this.clientMode.ordinal());
        data.writeByte(this.clientSpeed.ordinal());
        data.writeByte(this.lockController.getCurrentState());
    }

    @Override
    public void readGuiData(DataInputStream data, EntityPlayer sender) throws IOException {
        this.setMode(LocoMode.VALUES[data.readByte()]);
        this.setSpeed(LocoSpeed.VALUES[data.readByte()]);
        byte lock = data.readByte();
        if (MiscTools.isOwnerOrOp(this.getOwner(), Railcraft.proxy.getPlayerUsername(sender))) {
            this.lockController.setCurrentState(lock);
        }
    }

    public void writeSpawnData(ByteBuf data) {
        try {
            DataOutputStream byteStream = new DataOutputStream((OutputStream)new ByteBufOutputStream(data));
            byteStream.writeUTF(this.func_95999_t() != null ? this.func_95999_t() : "");
            byteStream.writeUTF(this.model);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void readSpawnData(ByteBuf data) {
        try {
            DataInputStream byteSteam = new DataInputStream((InputStream)new ByteBufInputStream(data));
            String name = byteSteam.readUTF();
            if (!name.equals("")) {
                this.func_96094_a(name);
            }
            this.model = byteSteam.readUTF();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean canBeRidden() {
        return false;
    }

    public int func_70302_i_() {
        return 0;
    }

    public boolean isPoweredCart() {
        return true;
    }

    @Override
    public boolean isLinkable() {
        return true;
    }

    @Override
    public boolean canLinkWithCart(EntityMinecart cart) {
        if (cart instanceof EntityLocomotive) {
            return true;
        }
        LinkageManager lm = LinkageManager.instance();
        boolean links = false;
        EntityMinecart linkA = lm.getLinkedCartA((EntityMinecart)this);
        if (linkA != null && !(linkA instanceof EntityLocomotive)) {
            return false;
        }
        EntityMinecart linkB = lm.getLinkedCartB((EntityMinecart)this);
        return linkB == null || linkB instanceof EntityLocomotive;
    }

    @Override
    public boolean hasTwoLinks() {
        return true;
    }

    @Override
    public float getLinkageDistance(EntityMinecart cart) {
        return 1.25f;
    }

    @Override
    public float getOptimalDistance(EntityMinecart cart) {
        return 0.9f;
    }

    @Override
    public boolean canBeAdjusted(EntityMinecart cart) {
        return true;
    }

    @Override
    public void onLinkCreated(EntityMinecart cart) {
    }

    @Override
    public void onLinkBroken(EntityMinecart cart) {
    }

    public abstract LocomotiveRenderType getRenderType();

    @Override
    public final byte getPrimaryColor() {
        return this.field_70180_af.func_75683_a(25);
    }

    @Override
    public final byte getSecondaryColor() {
        return this.field_70180_af.func_75683_a(26);
    }

    public final void setPrimaryColor(int color) {
        this.field_70180_af.func_75692_b(25, (Object)((byte)color));
    }

    public final void setSecondaryColor(int color) {
        this.field_70180_af.func_75692_b(26, (Object)((byte)color));
    }

    public final String getModel() {
        return this.model;
    }

    public final void setModel(String model) {
        this.model = model;
    }

    public static enum LocoSpeed {
        MAX,
        SLOW,
        SLOWER,
        SLOWEST,
        REVERSE;

        public static final LocoSpeed[] VALUES;

        static {
            VALUES = LocoSpeed.values();
        }
    }

    public static enum LocoMode {
        RUNNING,
        IDLE,
        SHUTDOWN;

        public static final LocoMode[] VALUES;

        static {
            VALUES = LocoMode.values();
        }
    }
}

