/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.carts;

import java.util.ArrayList;
import mods.railcraft.api.carts.CartTools;
import mods.railcraft.api.core.items.ITrackItem;
import mods.railcraft.api.tracks.RailTools;
import mods.railcraft.common.blocks.tracks.TrackTools;
import mods.railcraft.common.carts.CartMaintanceBase;
import mods.railcraft.common.carts.EnumCart;
import mods.railcraft.common.core.RailcraftLanguage;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRailBase;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class EntityCartTrackRelayer
extends CartMaintanceBase {
    private static final int SLOT_STOCK = 0;
    private static final int SLOT_EXIST = 0;
    private static final int SLOT_REPLACE = 1;

    public EntityCartTrackRelayer(World world) {
        super(world);
    }

    public EntityCartTrackRelayer(World world, double d, double d1, double d2) {
        this(world);
        this.func_70107_b(d, d1 + (double)this.field_70129_M, d2);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.field_70169_q = d;
        this.field_70167_r = d1;
        this.field_70166_s = d2;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (Game.isNotHost(this.field_70170_p)) {
            return;
        }
        this.stockItems(1, 0);
        this.replace();
    }

    private void replace() {
        Block block;
        int k;
        int j;
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        if (TrackTools.isRailBlockAt(this.field_70170_p, i, (j = MathHelper.func_76128_c((double)this.field_70163_u)) - 1, k = MathHelper.func_76128_c((double)this.field_70161_v))) {
            --j;
        }
        if (TrackTools.isRailBlock(block = this.field_70170_p.func_147439_a(i, j, k))) {
            ItemStack trackExist = this.patternInv.func_70301_a(0);
            ItemStack trackStock = this.func_70301_a(0);
            if (trackExist != null && trackStock != null) {
                int meta;
                if (trackExist.func_77973_b() instanceof ITrackItem) {
                    int meta2;
                    TileEntity tile;
                    ITrackItem trackItem = (ITrackItem)trackExist.func_77973_b();
                    if (trackItem.getPlacedBlock() == block && trackItem.isPlacedTileEntity(trackExist, tile = this.field_70170_p.func_147438_o(i, j, k)) && (meta2 = this.removeOldTrack(i, j, k, block)) != -1) {
                        this.placeNewTrack(i, j, k, 0, meta2);
                    }
                } else if (InvTools.isStackEqualToBlock(trackExist, block) && (meta = this.removeOldTrack(i, j, k, block)) != -1) {
                    this.placeNewTrack(i, j, k, 0, meta);
                }
            }
        }
    }

    private int removeOldTrack(int x, int y, int z, Block block) {
        ArrayList drops = block.getDrops(this.field_70170_p, x, y, z, 0, 0);
        for (ItemStack stack : drops) {
            CartTools.offerOrDropItem((EntityMinecart)this, stack);
        }
        int meta = this.field_70170_p.func_72805_g(x, y, z);
        if (((BlockRailBase)block).func_150050_e()) {
            meta &= 7;
        }
        this.field_70170_p.func_147468_f(x, y, z);
        return meta;
    }

    private void placeNewTrack(int x, int y, int z, int slotStock, int meta) {
        ItemStack trackStock = this.func_70301_a(slotStock);
        if (trackStock != null && RailTools.placeRailAt(trackStock, this.field_70170_p, x, y, z)) {
            this.field_70170_p.func_72921_c(x, y, z, meta, 2);
            Block block = this.field_70170_p.func_147439_a(x, y, z);
            block.func_149695_a(this.field_70170_p, x, y, z, block);
            this.field_70170_p.func_147471_g(x, y, z);
            this.func_70298_a(slotStock, 1);
            this.blink();
        }
    }

    @Override
    public boolean doInteract(EntityPlayer player) {
        if (Game.isHost(this.field_70170_p)) {
            GuiHandler.openGui(EnumGui.CART_TRACK_RELAYER, player, this.field_70170_p, (Entity)this);
        }
        return true;
    }

    public String func_145825_b() {
        return RailcraftLanguage.translate(EnumCart.TRACK_RELAYER.getTag());
    }

    @Override
    public int addItem(ItemStack stack, boolean doAdd, ForgeDirection from) {
        ItemStack trackReplace = this.patternInv.func_70301_a(1);
        ItemStack trackStock = this.func_70301_a(0);
        if (InvTools.isItemEqual(stack, trackReplace)) {
            if (trackStock == null) {
                if (doAdd) {
                    this.func_70299_a(0, stack.func_77946_l());
                }
                return stack.field_77994_a;
            }
            if (trackStock.field_77994_a + stack.field_77994_a <= trackStock.func_77976_d()) {
                if (doAdd) {
                    trackStock.field_77994_a += stack.field_77994_a;
                }
                return stack.field_77994_a;
            }
            int used = trackStock.func_77976_d() - trackStock.field_77994_a;
            if (doAdd) {
                trackStock.field_77994_a = trackStock.func_77976_d();
            }
            return used;
        }
        return 0;
    }
}

