/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.tracks;

import cpw.mods.fml.common.eventhandler.Event;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.UUID;
import mods.railcraft.api.core.items.IToolCrowbar;
import mods.railcraft.api.events.CartLockdownEvent;
import mods.railcraft.api.tracks.ITrackLockdown;
import mods.railcraft.api.tracks.ITrackPowered;
import mods.railcraft.common.blocks.tracks.EnumTrack;
import mods.railcraft.common.blocks.tracks.TrackBaseRailcraft;
import mods.railcraft.common.blocks.tracks.locking.BoardingLockingProfile;
import mods.railcraft.common.blocks.tracks.locking.HoldingLockingProfile;
import mods.railcraft.common.blocks.tracks.locking.LockdownLockingProfile;
import mods.railcraft.common.blocks.tracks.locking.LockingProfile;
import mods.railcraft.common.carts.LinkageManager;
import mods.railcraft.common.carts.Train;
import mods.railcraft.common.core.RailcraftLanguage;
import mods.railcraft.common.plugins.forge.ChatPlugin;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.block.Block;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.MinecraftForge;

public class TrackNextGenLocking
extends TrackBaseRailcraft
implements ITrackLockdown,
ITrackPowered {
    public static double START_BOOST = 0.04;
    public static double BOOST_FACTOR = 0.06;
    protected boolean powered = false;
    protected int prevDelay = 0;
    protected int delay = 0;
    protected byte reset = 0;
    private LockingProfileType profile = LockingProfileType.LOCKDOWN;
    private LockingProfile profileInstance = this.profile.create(this);
    private EntityMinecart lockedCart;
    private Train currentTrain;
    private boolean justLoaded = true;
    private UUID uuid;

    @Override
    public EnumTrack getTrackType() {
        return EnumTrack.LOCKING;
    }

    @Override
    public IIcon getIcon() {
        if (this.isPowered() || this.delay > 0) {
            return this.getIcon(this.profile.ordinal() * 2);
        }
        return this.getIcon(this.profile.ordinal() * 2 + 1);
    }

    public LockingProfileType getProfileType() {
        return this.profile;
    }

    public void setProfile(LockingProfileType type) {
        this.profile = type;
        this.profileInstance = this.profile.create(this);
        if (this.tileEntity != null && Game.isHost(this.getWorld())) {
            this.sendUpdateToClient();
        }
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    @Override
    public void updateEntity() {
        if (Game.isHost(this.getWorld())) {
            if (this.getCurrentCart() != null && this.getCurrentCart().field_70128_L) {
                this.setCurrentCartAndTrain(null);
            }
            if (this.isPowered()) {
                this.delay = this.getDelayTime();
            } else if (this.delay > 0) {
                --this.delay;
                if (this.delay == 0) {
                    this.setCurrentCartAndTrain(null);
                }
            }
            if (this.reset > 0) {
                this.reset = (byte)(this.reset - 1);
            }
            if (this.prevDelay == 0 ^ this.delay == 0) {
                this.sendUpdateToClient();
            }
            this.prevDelay = this.delay;
        }
    }

    @Override
    public void onNeighborBlockChange(Block blockChanged) {
        super.onNeighborBlockChange(blockChanged);
        if (this.isPowered()) {
            this.delay = this.getDelayTime();
        }
    }

    public EntityMinecart getCurrentCart() {
        return this.lockedCart;
    }

    @Override
    public boolean blockActivated(EntityPlayer player) {
        ItemStack current = player.func_71045_bC();
        if (current != null && current.func_77973_b() instanceof IToolCrowbar) {
            this.setProfile(this.profile.next());
            if (Game.isNotHost(this.getWorld())) {
                ChatPlugin.sendLocalizedChat(player, "gui.track.locking.change", RailcraftLanguage.translate("gui.track.locking.mode." + this.profile.tag));
            }
            return true;
        }
        return false;
    }

    @Override
    public void onBlockRemoved() {
        super.onBlockRemoved();
        this.setCurrentCartAndTrain(null);
    }

    private UUID getUUID() {
        if (this.uuid == null) {
            this.uuid = UUID.randomUUID();
        }
        return this.uuid;
    }

    protected void setCurrentCartAndTrain(EntityMinecart cart) {
        if (this.lockedCart != cart && this.lockedCart != null) {
            Train train = LinkageManager.instance().getTrain(this.lockedCart);
            train.removeLockingTrack(this.getUUID());
        }
        this.lockedCart = cart;
        this.currentTrain = cart == null ? null : LinkageManager.instance().getTrain(cart);
    }

    protected void lockCart(EntityMinecart cart) {
        if (cart != null) {
            Train train = LinkageManager.instance().getTrain(cart);
            train.addLockingTrack(this.getUUID());
            MinecraftForge.EVENT_BUS.post((Event)new CartLockdownEvent.Lock(cart, this.getX(), this.getY(), this.getZ()));
            this.profileInstance.onLock(cart);
        }
    }

    protected void releaseCart(EntityMinecart cart) {
        if (cart != null) {
            Train train = LinkageManager.instance().getTrain(cart);
            train.removeLockingTrack(this.getUUID());
            MinecraftForge.EVENT_BUS.post((Event)new CartLockdownEvent.Release(cart, this.getX(), this.getY(), this.getZ()));
            this.profileInstance.onRelease(cart);
        }
    }

    @Override
    public void onMinecartPass(EntityMinecart cart) {
        this.checkIfShouldChangeCart(cart);
        if (this.isPowered() || this.delay > 0) {
            this.releaseCart(cart);
        } else {
            if (this.getCurrentCart() == null) {
                this.setCurrentCartAndTrain(cart);
            }
            if (this.getCurrentCart() == cart) {
                this.lockCart(cart);
                cart.field_70159_w = 0.0;
                cart.field_70179_y = 0.0;
                int meta = this.tileEntity.func_145832_p();
                if (meta == 0 || meta == 4 || meta == 5) {
                    cart.field_70161_v = (double)this.tileEntity.field_145849_e + 0.5;
                } else {
                    cart.field_70165_t = (double)this.tileEntity.field_145851_c + 0.5;
                }
            }
        }
    }

    protected void checkIfShouldChangeCart(EntityMinecart cart) {
        byte r = this.reset;
        this.reset = (byte)20;
        if (this.delay <= 0) {
            this.justLoaded = false;
            return;
        }
        if (this.justLoaded) {
            this.setCurrentCartAndTrain(cart);
            this.delay = this.getDelayTime();
            return;
        }
        Train train = LinkageManager.instance().getTrain(cart);
        if (r <= 0 || this.profile.lockType == LockType.CART && this.lockedCart != cart || this.profile.lockType == LockType.TRAIN && this.currentTrain != train) {
            this.delay = 0;
            this.setCurrentCartAndTrain(cart);
            return;
        }
        if (this.profile.lockType == LockType.TRAIN) {
            this.delay = this.getDelayTime();
        }
    }

    protected int getDelayTime() {
        if (this.profile.lockType == LockType.TRAIN) {
            return 200;
        }
        return 3;
    }

    @Override
    public void releaseCart() {
        this.delay = 10;
    }

    @Override
    public boolean isCartLockedDown(EntityMinecart cart) {
        return !this.powered && this.lockedCart == cart && this.delay == 0;
    }

    @Override
    public boolean isPowered() {
        return this.powered;
    }

    @Override
    public void setPowered(boolean powered) {
        this.powered = powered;
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74774_a("profile", (byte)this.profile.ordinal());
        this.profileInstance.writeToNBT(data);
        data.func_74757_a("powered", this.powered);
        data.func_74768_a("delay", this.delay);
        data.func_74774_a("reset", this.reset);
        data.func_74772_a("uuidHigh", this.getUUID().getMostSignificantBits());
        data.func_74772_a("uuidLow", this.getUUID().getLeastSignificantBits());
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        if (data.func_74764_b("profile")) {
            this.profile = LockingProfileType.fromOrdinal(data.func_74771_c("profile"));
        }
        this.profileInstance = this.profile.create(this);
        this.profileInstance.readFromNBT(data);
        this.powered = data.func_74767_n("powered");
        this.delay = data.func_74762_e("delay");
        this.reset = data.func_74771_c("reset");
        if (data.func_74764_b("uuidHigh")) {
            this.uuid = new UUID(data.func_74763_f("uuidHigh"), data.func_74763_f("uuidLow"));
        }
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeByte(this.profile.ordinal());
        data.writeBoolean(this.powered);
        data.writeShort(this.delay);
        this.profileInstance.writePacketData(data);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        LockingProfileType p = LockingProfileType.fromOrdinal(data.readByte());
        if (this.profile != p) {
            this.profile = p;
            this.profileInstance = p.create(this);
        }
        this.powered = data.readBoolean();
        this.delay = data.readShort();
        this.profileInstance.readPacketData(data);
        this.markBlockNeedsUpdate();
    }

    public static enum LockingProfileType {
        LOCKDOWN(LockdownLockingProfile.class, LockType.CART, "lockdown"),
        LOCKDOWN_TRAIN(LockdownLockingProfile.class, LockType.TRAIN, "lockdown.train"),
        HOLDING(HoldingLockingProfile.class, LockType.CART, "holding"),
        HOLDING_TRAIN(HoldingLockingProfile.class, LockType.TRAIN, "holding.train"),
        BOARDING_A(BoardingLockingProfile.class, LockType.CART, "boarding"),
        BOARDING_B(BoardingLockingProfile.class, LockType.CART, "boarding"),
        BOARDING_A_TRAIN(BoardingLockingProfile.class, LockType.TRAIN, "boarding.train"),
        BOARDING_B_TRAIN(BoardingLockingProfile.class, LockType.TRAIN, "boarding.train");

        public static final LockingProfileType[] VALUES;
        private final Class<? extends LockingProfile> profileClass;
        public final LockType lockType;
        public final String tag;

        private LockingProfileType(Class<? extends LockingProfile> profileClass, LockType lockType, String tag) {
            this.profileClass = profileClass;
            this.lockType = lockType;
            this.tag = tag;
        }

        public LockingProfileType next() {
            LockingProfileType next = VALUES[(this.ordinal() + 1) % VALUES.length];
            return next;
        }

        public LockingProfile create(TrackNextGenLocking track) {
            try {
                Constructor<? extends LockingProfile> con = this.profileClass.getConstructor(TrackNextGenLocking.class);
                return con.newInstance(track);
            }
            catch (Throwable ex) {
                Game.logThrowable("Failed to create Locking Profile!", 10, ex, new Object[0]);
                throw new RuntimeException(ex);
            }
        }

        public static LockingProfileType fromOrdinal(int ordinal) {
            if (ordinal < 0 || ordinal >= VALUES.length) {
                return LOCKDOWN;
            }
            return VALUES[ordinal];
        }

        static {
            VALUES = LockingProfileType.values();
        }
    }

    public static enum LockType {
        CART,
        TRAIN;

    }
}

