/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.tracks;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mods.railcraft.api.core.items.IToolCrowbar;
import mods.railcraft.api.tracks.ITrackPowered;
import mods.railcraft.common.blocks.tracks.EnumTrack;
import mods.railcraft.common.blocks.tracks.TrackBaseRailcraft;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.util.effects.EffectManager;
import mods.railcraft.common.util.misc.MiscTools;
import mods.railcraft.common.util.network.IGuiReturnHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;

public class TrackEmbarking
extends TrackBaseRailcraft
implements ITrackPowered,
IGuiReturnHandler {
    public static final Set<Class> excludedEntities = new HashSet<Class>();
    public static final byte MIN_AREA = 1;
    public static final byte MAX_AREA = 5;
    private boolean powered = false;
    private byte area = (byte)2;

    @Override
    public EnumTrack getTrackType() {
        return EnumTrack.EMBARKING;
    }

    @Override
    public IIcon getIcon() {
        if (this.isPowered()) {
            return this.getIcon(0);
        }
        return this.getIcon(1);
    }

    @Override
    public boolean blockActivated(EntityPlayer player) {
        ItemStack current = player.func_71045_bC();
        if (current != null && current.func_77973_b() instanceof IToolCrowbar) {
            IToolCrowbar crowbar = (IToolCrowbar)current.func_77973_b();
            GuiHandler.openGui(EnumGui.TRACK_EMBARKING, player, this.getWorld(), this.tileEntity.field_145851_c, this.tileEntity.field_145848_d, this.tileEntity.field_145849_e);
            crowbar.onWhack(player, current, this.getX(), this.getY(), this.getZ());
            return true;
        }
        return false;
    }

    @Override
    public void onMinecartPass(EntityMinecart cart) {
        if (this.powered && cart.canBeRidden() && cart.field_70153_n == null && cart.getEntityData().func_74762_e("MountPrevention") <= 0) {
            byte a = this.area;
            AxisAlignedBB box = AxisAlignedBB.func_72332_a().func_72299_a((double)this.getX(), (double)this.getY(), (double)this.getZ(), (double)(this.getX() + 1), (double)(this.getY() + 1), (double)(this.getZ() + 1));
            box = box.func_72314_b((double)a, (double)a, (double)a);
            List entities = this.getWorld().func_72872_a(EntityLivingBase.class, box);
            if (entities.size() > 0) {
                EntityLivingBase entity = (EntityLivingBase)entities.get(MiscTools.getRand().nextInt(entities.size()));
                if (entity instanceof EntityPlayer) {
                    EntityPlayer player = (EntityPlayer)entity;
                    if (player.func_70093_af()) {
                        return;
                    }
                    ItemStack current = player.func_71045_bC();
                    if (current != null && current.func_77973_b() instanceof IToolCrowbar) {
                        return;
                    }
                } else {
                    EntitySlime slime;
                    if (excludedEntities.contains(entity.getClass())) {
                        return;
                    }
                    if (entity instanceof EntitySlime && (slime = (EntitySlime)entity).func_70809_q() >= 100) {
                        return;
                    }
                }
                if (entity.field_70154_o == null) {
                    EffectManager.instance.teleportEffect((Entity)entity, cart.field_70165_t, cart.field_70163_u, cart.field_70161_v);
                    entity.func_70078_a((Entity)cart);
                }
            }
        }
    }

    @Override
    public boolean isPowered() {
        return this.powered;
    }

    @Override
    public void setPowered(boolean powered) {
        this.powered = powered;
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74757_a("powered", this.powered);
        data.func_74774_a("area", this.area);
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.powered = data.func_74767_n("powered");
        this.area = data.func_74771_c("area");
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeBoolean(this.powered);
        data.writeByte(this.area);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        boolean p = data.readBoolean();
        this.setArea(data.readByte());
        if (p != this.powered) {
            this.powered = p;
            this.markBlockNeedsUpdate();
        }
    }

    @Override
    public void writeGuiData(DataOutputStream data) throws IOException {
        data.writeByte(this.area);
    }

    @Override
    public void readGuiData(DataInputStream data, EntityPlayer sender) throws IOException {
        byte a = data.readByte();
        if (this.area != a) {
            this.setArea(a);
            this.sendUpdateToClient();
        }
    }

    public void setArea(byte radius) {
        radius = (byte)Math.max(1, radius);
        this.area = radius = (byte)Math.min(5, radius);
    }

    public byte getArea() {
        return this.area;
    }

    static {
        excludedEntities.add(EntityIronGolem.class);
        excludedEntities.add(EntityDragon.class);
        excludedEntities.add(EntityWither.class);
        excludedEntities.add(EntityBlaze.class);
        excludedEntities.add(EntityMagmaCube.class);
        excludedEntities.add(EntitySquid.class);
        excludedEntities.add(EntityBat.class);
    }
}

