/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.tracks;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.api.carts.CartTools;
import mods.railcraft.api.carts.ILinkageManager;
import mods.railcraft.api.core.items.IToolCrowbar;
import mods.railcraft.api.tracks.ITrackPowered;
import mods.railcraft.common.blocks.tracks.EnumTrack;
import mods.railcraft.common.blocks.tracks.TrackBaseRailcraft;
import mods.railcraft.common.carts.LinkageManager;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;

public class TrackCoupler
extends TrackBaseRailcraft
implements ITrackPowered {
    private EntityMinecart taggedCart;
    private boolean powered = false;
    private boolean decouple = false;

    @Override
    public EnumTrack getTrackType() {
        return EnumTrack.COUPLER;
    }

    @Override
    public IIcon getIcon() {
        int iconIndex = 0;
        if (!this.isPowered()) {
            ++iconIndex;
        }
        if (this.decouple) {
            iconIndex += 2;
        }
        return this.getIcon(iconIndex);
    }

    @Override
    public boolean blockActivated(EntityPlayer player) {
        IToolCrowbar crowbar;
        ItemStack current = player.func_71045_bC();
        if (current != null && current.func_77973_b() instanceof IToolCrowbar && (crowbar = (IToolCrowbar)current.func_77973_b()).canWhack(player, current, this.getX(), this.getY(), this.getZ())) {
            this.decouple = !this.decouple;
            crowbar.onWhack(player, current, this.getX(), this.getY(), this.getZ());
            if (Game.isNotHost(this.getWorld())) {
                this.markBlockNeedsUpdate();
            } else {
                this.sendUpdateToClient();
            }
            return true;
        }
        return false;
    }

    @Override
    public void onMinecartPass(EntityMinecart cart) {
        if (this.isPowered()) {
            ILinkageManager lm = CartTools.getLinkageManager(cart.field_70170_p);
            if (this.decouple) {
                lm.breakLinks(cart);
                LinkageManager.printDebug("Reason For Broken Link: Passed Decoupler Track.", new Object[0]);
            } else {
                lm.createLink(this.taggedCart, cart);
                this.taggedCart = cart;
            }
        }
    }

    @Override
    public boolean isPowered() {
        return this.powered;
    }

    @Override
    public void setPowered(boolean powered) {
        this.powered = powered;
    }

    @Override
    public int getPowerPropagation() {
        return 8;
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74757_a("powered", this.powered);
        data.func_74757_a("decouple", this.decouple);
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.powered = data.func_74767_n("powered");
        this.decouple = data.func_74767_n("decouple");
        if (data.func_74762_e("trackId") == EnumTrack.DECOUPLER.ordinal()) {
            this.decouple = true;
        }
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeBoolean(this.powered);
        data.writeBoolean(this.decouple);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        boolean p = data.readBoolean();
        boolean d = data.readBoolean();
        boolean needsUpdate = false;
        if (p != this.powered) {
            this.powered = p;
            needsUpdate = true;
        }
        if (d != this.decouple) {
            this.decouple = d;
            needsUpdate = true;
        }
        if (needsUpdate) {
            this.markBlockNeedsUpdate();
        }
    }
}

