/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.tracks;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.api.tracks.ITrackCustomShape;
import mods.railcraft.api.tracks.ITrackReversable;
import mods.railcraft.common.blocks.tracks.EnumTrack;
import mods.railcraft.common.blocks.tracks.TrackBaseRailcraft;
import mods.railcraft.common.util.misc.MiscTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;

public class TrackBufferStop
extends TrackBaseRailcraft
implements ITrackReversable,
ITrackCustomShape {
    private static final float CBOX = 0.0625f;
    private static final float SBOX = 0.1875f;
    private static final float SBOXY = 0.3125f;
    private boolean reversed = false;

    @Override
    public EnumTrack getTrackType() {
        return EnumTrack.BUFFER_STOP;
    }

    @Override
    public IIcon getIcon() {
        if (this.reversed) {
            return this.getIcon(1);
        }
        return this.getIcon(0);
    }

    @Override
    public AxisAlignedBB getSelectedBoundingBoxFromPool() {
        return AxisAlignedBB.func_72332_a().func_72299_a((double)((float)this.tileEntity.field_145851_c + 0.1875f), (double)this.tileEntity.field_145848_d, (double)((float)this.tileEntity.field_145849_e + 0.1875f), (double)((float)(this.tileEntity.field_145851_c + 1) - 0.1875f), (double)((float)(this.tileEntity.field_145848_d + 1) - 0.3125f), (double)((float)(this.tileEntity.field_145849_e + 1) - 0.1875f));
    }

    @Override
    public MovingObjectPosition collisionRayTrace(Vec3 vec3d, Vec3 vec3d1) {
        return MiscTools.collisionRayTrace(vec3d, vec3d1, this.getX(), this.getY(), this.getZ());
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool() {
        return AxisAlignedBB.func_72332_a().func_72299_a((double)((float)this.tileEntity.field_145851_c + 0.0625f), (double)this.tileEntity.field_145848_d, (double)((float)this.tileEntity.field_145849_e + 0.0625f), (double)((float)(this.tileEntity.field_145851_c + 1) - 0.0625f), (double)(this.tileEntity.field_145848_d + 1), (double)((float)(this.tileEntity.field_145849_e + 1) - 0.0625f));
    }

    @Override
    public boolean canMakeSlopes() {
        return false;
    }

    @Override
    public boolean isReversed() {
        return this.reversed;
    }

    @Override
    public void setReversed(boolean reversed) {
        this.reversed = reversed;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.func_74757_a("direction", this.reversed);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.reversed = nbttagcompound.func_74767_n("direction");
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeBoolean(this.reversed);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        boolean r = data.readBoolean();
        if (this.reversed != r) {
            this.reversed = r;
            this.markBlockNeedsUpdate();
        }
    }
}

