/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.signals;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.api.signals.IReceiverTile;
import mods.railcraft.api.signals.SignalAspect;
import mods.railcraft.api.signals.SignalController;
import mods.railcraft.api.signals.SimpleSignalReceiver;
import mods.railcraft.common.blocks.signals.EnumSignal;
import mods.railcraft.common.blocks.signals.IAspectActionManager;
import mods.railcraft.common.blocks.signals.TileBoxActionManager;
import mods.railcraft.common.blocks.signals.TileBoxBase;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.plugins.buildcraft.triggers.IAspectProvider;
import mods.railcraft.common.plugins.forge.WorldPlugin;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.MiscTools;
import mods.railcraft.common.util.network.IGuiReturnHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileBoxReceiver
extends TileBoxActionManager
implements IAspectActionManager,
IGuiReturnHandler,
IReceiverTile,
IAspectProvider {
    private boolean prevBlinkState;
    private final SimpleSignalReceiver receiver = new SimpleSignalReceiver(this.getName(), this);

    @Override
    public EnumSignal getSignalType() {
        return EnumSignal.BOX_RECEIVER;
    }

    @Override
    public boolean blockActivated(int side, EntityPlayer player) {
        if (player.func_70093_af()) {
            return false;
        }
        if (Game.isHost(this.field_145850_b)) {
            GuiHandler.openGui(EnumGui.BOX_RECEIVER, player, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return true;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (Game.isNotHost(this.getWorld())) {
            this.receiver.tickClient();
            if (this.receiver.getAspect().isBlinkAspect() && this.prevBlinkState != SignalAspect.isBlinkOn()) {
                this.prevBlinkState = SignalAspect.isBlinkOn();
                this.markBlockForUpdate();
            }
            return;
        }
        this.receiver.tickServer();
        SignalAspect prevAspect = this.receiver.getAspect();
        if (this.receiver.isBeingPaired()) {
            this.receiver.setAspect(SignalAspect.BLINK_YELLOW);
        } else if (!this.receiver.isPaired()) {
            this.receiver.setAspect(SignalAspect.BLINK_RED);
        }
        if (prevAspect != this.receiver.getAspect()) {
            this.updateNeighbors();
            this.sendUpdateToClient();
        }
    }

    @Override
    public void onControllerAspectChange(SignalController con, SignalAspect aspect) {
        this.updateNeighbors();
        this.sendUpdateToClient();
    }

    private void updateNeighbors() {
        this.notifyBlocksOfNeighborChange();
        this.updateNeighborBoxes();
    }

    @Override
    public int getPowerOutput(int side) {
        TileEntity tile = WorldPlugin.getTileEntityOnSide(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, MiscTools.getOppositeSide(side));
        if (tile instanceof TileBoxBase) {
            return 0;
        }
        return this.doesActionOnAspect(this.receiver.getAspect()) ? 15 : 0;
    }

    @Override
    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        this.receiver.writeToNBT(data);
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.receiver.readFromNBT(data);
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        this.receiver.writePacketData(data);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.receiver.readPacketData(data);
        this.markBlockForUpdate();
    }

    @Override
    public void readGuiData(DataInputStream data, EntityPlayer sender) throws IOException {
        super.readGuiData(data, sender);
        this.updateNeighbors();
    }

    @Override
    public boolean isConnected(ForgeDirection side) {
        TileEntity tile = this.tileCache.getTileOnSide(side);
        if (tile instanceof TileBoxBase) {
            return ((TileBoxBase)tile).canReceiveAspect();
        }
        return false;
    }

    @Override
    public boolean isEmitingRedstone(ForgeDirection side) {
        return this.doesActionOnAspect(this.receiver.getAspect());
    }

    @Override
    public boolean canEmitingRedstone(ForgeDirection side) {
        return true;
    }

    @Override
    public void doActionOnAspect(SignalAspect aspect, boolean trigger) {
        super.doActionOnAspect(aspect, trigger);
        this.updateNeighbors();
    }

    @Override
    public SignalAspect getBoxSignalAspect(ForgeDirection side) {
        return this.receiver.getAspect();
    }

    @Override
    public boolean canTransferAspect() {
        return true;
    }

    @Override
    public SimpleSignalReceiver getReceiver() {
        return this.receiver;
    }

    @Override
    public SignalAspect getTriggerAspect() {
        return this.getBoxSignalAspect(null);
    }
}

