/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.beta;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mods.railcraft.common.blocks.machine.MultiBlockPattern;
import mods.railcraft.common.blocks.machine.TileMultiBlock;
import mods.railcraft.common.blocks.machine.beta.EnumMachineBeta;
import mods.railcraft.common.blocks.machine.beta.TileBoilerFirebox;
import mods.railcraft.common.fluids.FluidHelper;
import mods.railcraft.common.fluids.Fluids;
import mods.railcraft.common.fluids.TankManager;
import mods.railcraft.common.fluids.tanks.FakeTank;
import mods.railcraft.common.fluids.tanks.FilteredTank;
import mods.railcraft.common.fluids.tanks.StandardTank;
import mods.railcraft.common.plugins.forge.WorldPlugin;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.ITileFilter;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public abstract class TileBoiler
extends TileMultiBlock
implements IFluidHandler {
    private static final Set<Integer> boilerBlocks = new HashSet<Integer>();
    private static final Set<Integer> fireboxBlocks = new HashSet<Integer>();
    protected static final List<MultiBlockPattern> patterns = new ArrayList<MultiBlockPattern>();
    public static final int TANK_WATER = 0;
    public static final int TANK_STEAM = 1;
    public static final int TRANSFER_RATE = 80;
    public static final int TICKS_LOW = 16;
    public static final int TICKS_HIGH = 8;
    public static final int STEAM_LOW = 16;
    public static final int STEAM_HIGH = 32;
    public static final float HEAT_LOW = 500.0f;
    public static final float HEAT_HIGH = 1000.0f;
    protected final TankManager tankManager = new TankManager();
    protected final FilteredTank tankWater = new FilteredTank(4000, Fluids.WATER.get(), this);
    protected final FilteredTank tankSteam;

    private static MultiBlockPattern buildMap(int width, int tankHeight, int offset, char tank, int ticks, float heat, int capacity) {
        int z;
        int x;
        char[][][] map = new char[tankHeight + 3][width + 2][width + 2];
        for (x = 0; x < width + 2; ++x) {
            for (z = 0; z < width + 2; ++z) {
                map[0][x][z] = 79;
            }
        }
        for (x = 0; x < width + 2; ++x) {
            for (z = 0; z < width + 2; ++z) {
                int m;
                map[1][x][z] = m = x == 0 || z == 0 || x == width + 1 || z == width + 1 ? 79 : 70;
            }
        }
        for (int y = 2; y < tankHeight + 2; ++y) {
            for (int x2 = 0; x2 < width + 2; ++x2) {
                for (int z2 = 0; z2 < width + 2; ++z2) {
                    int m;
                    map[y][x2][z2] = m = x2 == 0 || z2 == 0 || x2 == width + 1 || z2 == width + 1 ? 79 : (int)tank;
                }
            }
        }
        for (x = 0; x < width + 2; ++x) {
            for (z = 0; z < width + 2; ++z) {
                map[tankHeight + 2][x][z] = 79;
            }
        }
        return new BoilerPattern(map, width * width * tankHeight, ticks, heat, capacity, offset, offset);
    }

    protected TileBoiler() {
        super(patterns);
        this.tankManager.add(this.tankWater);
        this.tankSteam = new FilteredTank(16000, Fluids.STEAM.get(), this);
        this.tankManager.add(this.tankSteam);
    }

    @Override
    public boolean blockActivated(EntityPlayer player, int side) {
        TileBoilerFirebox mBlock;
        ItemStack current = player.func_71045_bC();
        if (current != null && current.func_77973_b() != Items.field_151133_ar && (Game.isHost(this.field_145850_b) ? (mBlock = (TileBoilerFirebox)this.getMasterBlock()) != null && mBlock.handleClick(player, side) : FluidHelper.isContainer(current))) {
            return true;
        }
        return super.blockActivated(player, side);
    }

    public void explode() {
        if (Game.isHost(this.field_145850_b)) {
            this.field_145850_b.func_72876_a(null, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 5.0f + 0.1f * (float)this.getNumTanks(), true);
        }
    }

    public int getNumTanks() {
        MultiBlockPattern pattern = this.getPattern();
        return ((BoilerPattern)pattern).numTanks;
    }

    public float getMaxHeat() {
        MultiBlockPattern pattern = this.getPattern();
        return ((BoilerPattern)pattern).maxHeat;
    }

    public int getTicksPerConversion() {
        MultiBlockPattern pattern = this.getPattern();
        return ((BoilerPattern)pattern).ticksPerCycle;
    }

    public int getSteamCapacityPerTank() {
        MultiBlockPattern pattern = this.getPattern();
        return ((BoilerPattern)pattern).steamCapacity;
    }

    public TankManager getTankManager() {
        TileBoiler mBlock = (TileBoiler)this.getMasterBlock();
        if (mBlock != null) {
            return mBlock.tankManager;
        }
        return null;
    }

    @Override
    public void func_145845_h() {
        StandardTank tank;
        FluidStack steam;
        TileBoilerFirebox mBlock;
        super.func_145845_h();
        if (Game.isHost(this.field_145850_b) && (mBlock = (TileBoilerFirebox)this.getMasterBlock()) != null && (steam = (tank = mBlock.tankManager.get(1)).getFluid()) != null && (!mBlock.boiler.isBoiling() || steam.amount >= tank.getCapacity() / 2)) {
            mBlock.tankManager.outputLiquid(this.tileCache, this.getOutputFilter(), ForgeDirection.VALID_DIRECTIONS, 1, 80);
        }
    }

    public abstract ITileFilter getOutputFilter();

    @Override
    public boolean openGui(EntityPlayer player) {
        TileMultiBlock mBlock = this.getMasterBlock();
        if (mBlock != null) {
            return mBlock.openGui(player);
        }
        return false;
    }

    @Override
    protected int getMaxRecursionDepth() {
        return 20;
    }

    @Override
    protected boolean isMapPositionValid(int x, int y, int z, char mapPos) {
        Block block = WorldPlugin.getBlock((IBlockAccess)this.field_145850_b, x, y, z);
        int meta = this.field_145850_b.func_72805_g(x, y, z);
        switch (mapPos) {
            case 'O': {
                if (block != this.func_145838_q() || !boilerBlocks.contains(meta)) break;
                return false;
            }
            case 'L': {
                if (block == this.func_145838_q() && meta == EnumMachineBeta.BOILER_TANK_LOW_PRESSURE.ordinal()) break;
                return false;
            }
            case 'H': {
                if (block == this.func_145838_q() && meta == EnumMachineBeta.BOILER_TANK_HIGH_PRESSURE.ordinal()) break;
                return false;
            }
            case 'F': {
                if (block == this.func_145838_q() && meta == this.func_145832_p() && fireboxBlocks.contains(meta)) break;
                return false;
            }
            case 'A': {
                if (this.field_145850_b.func_147437_c(x, y, z)) break;
                return false;
            }
        }
        return true;
    }

    @Override
    protected boolean isStructureTile(TileEntity tile) {
        return tile instanceof TileBoiler;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        TileBoilerFirebox mBlock = (TileBoilerFirebox)this.getMasterBlock();
        if (mBlock == null) {
            return null;
        }
        return mBlock.tankManager.get(1).drain(maxDrain, doDrain);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (Fluids.STEAM.is(resource)) {
            return this.drain(from, resource.amount, doDrain);
        }
        return null;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return 0;
    }

    protected int fill(int tankIndex, FluidStack resource, boolean doFill) {
        if (tankIndex == 1) {
            return 0;
        }
        TileBoilerFirebox mBlock = (TileBoilerFirebox)this.getMasterBlock();
        if (mBlock == null) {
            return 0;
        }
        if (doFill && Fluids.WATER.is(resource)) {
            this.onFillWater();
        }
        return mBlock.tankManager.fill(tankIndex, resource, doFill);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return Fluids.WATER.is(fluid);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return Fluids.STEAM.is(fluid);
    }

    protected void onFillWater() {
        FluidStack water;
        TileBoilerFirebox mBlock = (TileBoilerFirebox)this.getMasterBlock();
        if (mBlock != null && mBlock.boiler.isSuperHeated() && ((water = mBlock.tankManager.get(0).getFluid()) == null || water.amount <= 0)) {
            mBlock.boiler.setHeat(299.0);
            this.explode();
        }
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection dir) {
        TileBoilerFirebox mBlock = (TileBoilerFirebox)this.getMasterBlock();
        if (mBlock != null) {
            return mBlock.tankManager.getTankInfo();
        }
        return FakeTank.INFO;
    }

    static {
        fireboxBlocks.add(EnumMachineBeta.BOILER_FIREBOX_SOLID.ordinal());
        fireboxBlocks.add(EnumMachineBeta.BOILER_FIREBOX_LIQUID.ordinal());
        boilerBlocks.addAll(fireboxBlocks);
        boilerBlocks.add(EnumMachineBeta.BOILER_TANK_LOW_PRESSURE.ordinal());
        boilerBlocks.add(EnumMachineBeta.BOILER_TANK_HIGH_PRESSURE.ordinal());
        patterns.add(TileBoiler.buildMap(3, 4, 2, 'H', 8, 1000.0f, 32));
        patterns.add(TileBoiler.buildMap(3, 3, 2, 'H', 8, 1000.0f, 32));
        patterns.add(TileBoiler.buildMap(3, 2, 2, 'H', 8, 1000.0f, 32));
        patterns.add(TileBoiler.buildMap(2, 3, 1, 'H', 8, 1000.0f, 32));
        patterns.add(TileBoiler.buildMap(2, 2, 1, 'H', 8, 1000.0f, 32));
        patterns.add(TileBoiler.buildMap(1, 1, 1, 'H', 8, 1000.0f, 32));
        patterns.add(TileBoiler.buildMap(3, 4, 2, 'L', 16, 500.0f, 16));
        patterns.add(TileBoiler.buildMap(3, 3, 2, 'L', 16, 500.0f, 16));
        patterns.add(TileBoiler.buildMap(3, 2, 2, 'L', 16, 500.0f, 16));
        patterns.add(TileBoiler.buildMap(2, 3, 1, 'L', 16, 500.0f, 16));
        patterns.add(TileBoiler.buildMap(2, 2, 1, 'L', 16, 500.0f, 16));
        patterns.add(TileBoiler.buildMap(1, 1, 1, 'L', 16, 500.0f, 16));
    }

    public static class BoilerPattern
    extends MultiBlockPattern {
        public final int numTanks;
        public final int ticksPerCycle;
        public final float maxHeat;
        public final int steamCapacity;

        public BoilerPattern(char[][][] pattern, int tanks, int ticks, float heat, int capacity, int xOffset, int yOffset) {
            super(pattern, xOffset, 1, yOffset);
            this.numTanks = tanks;
            this.ticksPerCycle = ticks;
            this.maxHeat = heat;
            this.steamCapacity = capacity;
        }
    }
}

