/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.beta;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import mods.railcraft.client.util.textures.TextureAtlasSheet;
import mods.railcraft.common.blocks.RailcraftBlocks;
import mods.railcraft.common.blocks.machine.IEnumMachine;
import mods.railcraft.common.blocks.machine.TileMachineBase;
import mods.railcraft.common.blocks.machine.beta.TileBoilerFireboxLiquid;
import mods.railcraft.common.blocks.machine.beta.TileBoilerFireboxSolid;
import mods.railcraft.common.blocks.machine.beta.TileBoilerTankHigh;
import mods.railcraft.common.blocks.machine.beta.TileBoilerTankLow;
import mods.railcraft.common.blocks.machine.beta.TileChestVoid;
import mods.railcraft.common.blocks.machine.beta.TileEngineSteamHigh;
import mods.railcraft.common.blocks.machine.beta.TileEngineSteamHobby;
import mods.railcraft.common.blocks.machine.beta.TileEngineSteamLow;
import mods.railcraft.common.blocks.machine.beta.TileSawmill;
import mods.railcraft.common.blocks.machine.beta.TileSentinel;
import mods.railcraft.common.blocks.machine.beta.TileTankIronGauge;
import mods.railcraft.common.blocks.machine.beta.TileTankIronValve;
import mods.railcraft.common.blocks.machine.beta.TileTankIronWall;
import mods.railcraft.common.blocks.machine.beta.TileTankSteelGauge;
import mods.railcraft.common.blocks.machine.beta.TileTankSteelValve;
import mods.railcraft.common.blocks.machine.beta.TileTankSteelWall;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.core.RailcraftLanguage;
import mods.railcraft.common.gui.tooltips.ToolTip;
import mods.railcraft.common.modules.ModuleManager;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;

public enum EnumMachineBeta implements IEnumMachine
{
    TANK_IRON_WALL(ModuleManager.Module.TRANSPORT, "tank.iron.wall", TileTankIronWall.class, 2, 1, 0, 0, 1, 1, 1, 1),
    TANK_IRON_GAUGE(ModuleManager.Module.TRANSPORT, "tank.iron.gauge", TileTankIronGauge.class, 1, 5, 0, 0, 0, 0, 0, 0, 1, 2, 3, 4),
    TANK_IRON_VALVE(ModuleManager.Module.TRANSPORT, "tank.iron.valve", TileTankIronValve.class, 4, 1, 0, 0, 1, 1, 1, 1, 2, 3),
    BOILER_TANK_LOW_PRESSURE(ModuleManager.Module.STEAM, "boiler.tank.pressure.low", TileBoilerTankLow.class, 2, 1, 0, 0, 1, 1, 1, 1),
    BOILER_TANK_HIGH_PRESSURE(ModuleManager.Module.STEAM, "boiler.tank.pressure.high", TileBoilerTankHigh.class, 2, 1, 0, 0, 1, 1, 1, 1),
    BOILER_FIREBOX_SOLID(ModuleManager.Module.STEAM, "boiler.firebox.solid", TileBoilerFireboxSolid.class, 3, 1, 0, 0, 1, 1, 1, 1, 2),
    BOILER_FIREBOX_LIQUID(ModuleManager.Module.STEAM, "boiler.firebox.liquid", TileBoilerFireboxLiquid.class, 3, 1, 0, 0, 1, 1, 1, 1, 2),
    ENGINE_STEAM_HOBBY(ModuleManager.Module.STEAM, "engine.steam.hobby", TileEngineSteamHobby.class, 1, 1, 0),
    ENGINE_STEAM_LOW(ModuleManager.Module.STEAM, "engine.steam.low", TileEngineSteamLow.class, 1, 1, 0),
    ENGINE_STEAM_HIGH(ModuleManager.Module.STEAM, "engine.steam.high", TileEngineSteamHigh.class, 1, 1, 0),
    SENTINEL(ModuleManager.Module.CHUNK_LOADING, "anchor.sentinel", TileSentinel.class, 2, 1, 0, 0, 1, 1, 1, 1),
    VOID_CHEST(ModuleManager.Module.TRANSPORT, "chest.void", TileChestVoid.class, 1, 1, 0),
    SAWMILL(null, "sawmill", TileSawmill.class, 1, 1, 0),
    TANK_STEEL_WALL(ModuleManager.Module.TRANSPORT, "tank.steel.wall", TileTankSteelWall.class, 2, 1, 0, 0, 1, 1, 1, 1),
    TANK_STEEL_GAUGE(ModuleManager.Module.TRANSPORT, "tank.steel.gauge", TileTankSteelGauge.class, 1, 5, 0, 0, 0, 0, 0, 0, 1, 2, 3, 4),
    TANK_STEEL_VALVE(ModuleManager.Module.TRANSPORT, "tank.steel.valve", TileTankSteelValve.class, 4, 1, 0, 0, 1, 1, 1, 1, 2, 3);

    private final ModuleManager.Module module;
    private final String tag;
    private final Class<? extends TileMachineBase> tile;
    private IIcon[] texture = new IIcon[12];
    private final int[] textureInfo;
    private static final List<EnumMachineBeta> creativeList;
    private static final EnumMachineBeta[] VALUES;
    private ToolTip tip;

    private EnumMachineBeta(ModuleManager.Module module, String tag, Class<? extends TileMachineBase> tile, int ... textureInfo) {
        this.module = module;
        this.tile = tile;
        this.tag = tag;
        this.textureInfo = textureInfo;
    }

    @Override
    public boolean isDepreciated() {
        return this.module == null;
    }

    public void setTexture(IIcon[] tex) {
        this.texture = tex;
    }

    public IIcon[] getTexture() {
        return this.texture;
    }

    @Override
    public IIcon getTexture(int index) {
        if (index < 0 || index >= this.texture.length) {
            index = 0;
        }
        return this.texture[index];
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerIcons(IIconRegister iconRegister) {
        for (EnumMachineBeta machine : VALUES) {
            if (machine.isDepreciated()) continue;
            machine.texture = new IIcon[machine.textureInfo.length - 2];
            int columns = machine.textureInfo[0];
            int rows = machine.textureInfo[1];
            IIcon[] icons = TextureAtlasSheet.unstitchIcons(iconRegister, "railcraft:" + machine.tag, columns, rows);
            for (int i = 0; i < machine.texture.length; ++i) {
                machine.texture[i] = icons[machine.textureInfo[i + 2]];
            }
        }
    }

    public static EnumMachineBeta fromId(int id) {
        if (id < 0 || id >= VALUES.length) {
            id = 0;
        }
        return VALUES[id];
    }

    public static List<EnumMachineBeta> getCreativeList() {
        return creativeList;
    }

    @Override
    public String getTag() {
        return "railcraft.machine.beta." + this.tag;
    }

    @Override
    public Class getTileClass() {
        return this.tile;
    }

    public TileMachineBase getTileEntity() {
        try {
            return this.tile.newInstance();
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public ItemStack getItem() {
        return this.getItem(1);
    }

    @Override
    public ItemStack getItem(int qty) {
        Block block = this.getBlock();
        if (block == null) {
            return null;
        }
        return new ItemStack(block, qty, this.ordinal());
    }

    public ModuleManager.Module getModule() {
        return this.module;
    }

    @Override
    public Block getBlock() {
        return RailcraftBlocks.getBlockMachineBeta();
    }

    public boolean isEnabled() {
        return ModuleManager.isModuleLoaded(this.getModule()) && RailcraftConfig.isSubBlockEnabled(this.getTag());
    }

    @Override
    public boolean isAvaliable() {
        return this.getBlock() != null && this.isEnabled();
    }

    public boolean register() {
        if (RailcraftConfig.isSubBlockEnabled(this.getTag())) {
            RailcraftBlocks.registerBlockMachineBeta();
            if (this.getBlock() != null) {
                ItemStack stack = this.getItem();
                RailcraftLanguage.instance().registerItemName(stack, this.getTag());
                return true;
            }
        }
        return false;
    }

    public ToolTip getToolTip(ItemStack stack, EntityPlayer player, boolean adv) {
        if (this.tip != null) {
            return this.tip;
        }
        String tipTag = "gui.tip." + this.tag;
        if (RailcraftLanguage.hasTag(tipTag)) {
            this.tip = ToolTip.buildToolTip(tipTag, new String[0]);
        }
        return this.tip;
    }

    static {
        creativeList = new ArrayList<EnumMachineBeta>();
        VALUES = EnumMachineBeta.values();
        creativeList.add(TANK_IRON_WALL);
        creativeList.add(TANK_IRON_GAUGE);
        creativeList.add(TANK_IRON_VALVE);
        creativeList.add(TANK_STEEL_WALL);
        creativeList.add(TANK_STEEL_GAUGE);
        creativeList.add(TANK_STEEL_VALVE);
        creativeList.add(BOILER_FIREBOX_SOLID);
        creativeList.add(BOILER_FIREBOX_LIQUID);
        creativeList.add(BOILER_TANK_LOW_PRESSURE);
        creativeList.add(BOILER_TANK_HIGH_PRESSURE);
        creativeList.add(ENGINE_STEAM_HOBBY);
        creativeList.add(ENGINE_STEAM_LOW);
        creativeList.add(ENGINE_STEAM_HIGH);
        creativeList.add(SENTINEL);
        creativeList.add(VOID_CHEST);
    }
}

