/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.alpha;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import mods.railcraft.common.blocks.machine.TileMachineBase;
import mods.railcraft.common.blocks.machine.alpha.DamageSourceSteam;
import mods.railcraft.common.blocks.machine.beta.ISteamUser;
import mods.railcraft.common.fluids.Fluids;
import mods.railcraft.common.fluids.TankManager;
import mods.railcraft.common.fluids.tanks.FilteredTank;
import mods.railcraft.common.plugins.forge.PowerPlugin;
import mods.railcraft.common.util.effects.EffectManager;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.MiscTools;
import mods.railcraft.common.util.sounds.SoundHelper;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public abstract class TileSteamTrap
extends TileMachineBase
implements IFluidHandler,
ISteamUser {
    private static final byte JET_TIME = 40;
    private static final byte DAMAGE = 8;
    private static final double RANGE = 3.5;
    protected ForgeDirection direction = ForgeDirection.NORTH;
    protected boolean powered;
    private byte jet;
    private final TankManager tankManager = new TankManager();
    private final FilteredTank tank = new FilteredTank(32000, Fluids.STEAM.get());

    public TileSteamTrap() {
        this.tankManager.add(this.tank);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.jet > 0) {
            this.jet = (byte)(this.jet - 1);
            if (this.jet == 0) {
                this.sendUpdateToClient();
            }
        }
        if (Game.isNotHost(this.field_145850_b)) {
            if (this.isJetting()) {
                double speedFactor = 0.2;
                for (int i = 0; i < 10; ++i) {
                    EffectManager.instance.steamJetEffect(this.field_145850_b, this, (double)this.direction.offsetX * speedFactor, (double)this.direction.offsetY * speedFactor, (double)this.direction.offsetZ * speedFactor);
                }
            }
            return;
        }
        this.triggerCheck();
        if (this.isJetting()) {
            for (EntityLivingBase entity : this.getEntitiesInSteamArea()) {
                entity.func_70097_a((DamageSource)DamageSourceSteam.INSTANCE, 8.0f);
            }
        }
    }

    public List<EntityLivingBase> getEntitiesInSteamArea() {
        AxisAlignedBB area = AxisAlignedBB.func_72332_a().func_72299_a(-0.5, -0.5, -0.5, 0.5, 0.5, 0.5);
        MiscTools.addCoordToAABB(area, (double)this.direction.offsetX * 3.5, (double)this.direction.offsetY * 3.5, (double)this.direction.offsetZ * 3.5);
        area.func_72317_d((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5);
        List entities = this.field_145850_b.func_72872_a(EntityLivingBase.class, area);
        return entities;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.tankManager.fill(0, resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return fluid == null || Fluids.STEAM.is(fluid);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection direction) {
        return this.tankManager.getTankInfo(direction);
    }

    protected abstract void triggerCheck();

    protected void jet() {
        if (!this.canJet()) {
            return;
        }
        this.jet = (byte)40;
        this.tank.setFluid(null);
        SoundHelper.playSound(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, "railcraft:machine.steamhiss", 1.0f, (float)(1.0 + MiscTools.getRand().nextGaussian() * 0.1));
        this.sendUpdateToClient();
    }

    public boolean isJetting() {
        return this.jet > 0;
    }

    public void onStopJetting() {
    }

    public boolean canJet() {
        return !this.isJetting() && this.tank.isFull();
    }

    @Override
    public void onBlockPlacedBy(EntityLivingBase entityliving) {
        super.onBlockPlacedBy(entityliving);
        this.direction = MiscTools.getSideClosestToPlayer(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, entityliving);
    }

    @Override
    public void onNeighborBlockChange(Block block) {
        super.onNeighborBlockChange(block);
        this.powered = PowerPlugin.isBlockBeingPowered(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public boolean rotateBlock(ForgeDirection axis) {
        this.direction = this.direction == axis ? axis.getOpposite() : axis;
        this.markBlockForUpdate();
        return true;
    }

    @Override
    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        data.func_74774_a("direction", (byte)this.direction.ordinal());
        data.func_74757_a("powered", this.powered);
        this.tankManager.writeTanksToNBT(data);
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.direction = ForgeDirection.getOrientation((int)data.func_74771_c("direction"));
        this.powered = data.func_74767_n("powered");
        this.tankManager.readTanksFromNBT(data);
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeByte(this.jet);
        data.writeByte(this.direction.ordinal());
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.jet = data.readByte();
        this.direction = ForgeDirection.getOrientation((int)data.readByte());
        this.markBlockForUpdate();
    }
}

