/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.detector;

import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.List;
import mods.railcraft.client.util.textures.TextureAtlasSheet;
import mods.railcraft.common.blocks.detector.EnumDetector;
import mods.railcraft.common.blocks.detector.ItemDetector;
import mods.railcraft.common.blocks.detector.TileDetector;
import mods.railcraft.common.blocks.tracks.TrackTools;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.core.RailcraftLanguage;
import mods.railcraft.common.items.IActivationBlockingItem;
import mods.railcraft.common.plugins.forge.CreativePlugin;
import mods.railcraft.common.plugins.forge.HarvestPlugin;
import mods.railcraft.common.plugins.forge.ItemRegistry;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.MiscTools;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockDetector
extends BlockContainer {
    private static BlockDetector block;

    public static void registerBlock() {
        if (block == null && RailcraftConfig.isBlockEnabled("detector")) {
            block = new BlockDetector();
            GameRegistry.registerBlock((Block)block, ItemDetector.class, (String)block.func_149739_a());
            HarvestPlugin.setHarvestLevel((Block)block, "pickaxe", 2);
            HarvestPlugin.setHarvestLevel((Block)block, "crowbar", 0);
            for (EnumDetector d : EnumDetector.VALUES) {
                ItemStack stack = new ItemStack((Block)block, 1, d.ordinal());
                String tag = d.getTag();
                RailcraftLanguage.instance().registerItemName(stack, tag);
                ItemRegistry.registerItemStack(tag, stack);
            }
        }
    }

    public static BlockDetector getBlock() {
        return block;
    }

    public BlockDetector() {
        super(Material.field_151576_e);
        this.func_149663_c("railcraft.detector");
        this.func_149752_b(4.5f);
        this.func_149711_c(2.0f);
        this.func_149672_a(field_149769_e);
        this.func_149647_a(CreativePlugin.RAILCRAFT_TAB);
        GameRegistry.registerTileEntity(TileDetector.class, (String)"RCDetectorTile");
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileDetector) {
            TileDetector detector = (TileDetector)tile;
            return detector.getDetector().getType().getItem();
        }
        return super.getPickBlock(target, world, x, y, z);
    }

    public boolean func_149637_q() {
        return false;
    }

    public boolean isSideSolid(IBlockAccess world, int i, int j, int k, ForgeDirection side) {
        return true;
    }

    public int func_149692_a(int meta) {
        return meta;
    }

    public ArrayList<ItemStack> getDrops(World world, int i, int j, int k, int md, int fortune) {
        TileEntity tile = world.func_147438_o(i, j, k);
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        if (tile instanceof TileDetector) {
            items.add(((TileDetector)tile).getDetector().getType().getItem());
        }
        return items;
    }

    public void func_149636_a(World world, EntityPlayer entityplayer, int i, int j, int k, int l) {
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        player.func_71064_a(StatList.field_75934_C[BlockDetector.func_149682_b((Block)this)], 1);
        player.func_71020_j(0.025f);
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileDetector) {
            ((TileDetector)tile).getDetector().onBlockRemoved();
        }
        if (Game.isHost(world) && !player.field_71075_bZ.field_75098_d) {
            this.func_149697_b(world, x, y, z, 0, 0);
        }
        return world.func_147468_f(x, y, z);
    }

    public TileEntity func_149915_a(World var1, int meta) {
        return null;
    }

    public TileEntity createTileEntity(World var1, int meta) {
        return new TileDetector();
    }

    public void func_149689_a(World world, int i, int j, int k, EntityLivingBase entityliving, ItemStack stack) {
        TileEntity tile = world.func_147438_o(i, j, k);
        if (tile instanceof TileDetector) {
            ((TileDetector)tile).direction = MiscTools.getSideClosestToPlayer(world, i, j, k, entityliving);
            ((TileDetector)tile).onBlockPlacedBy(entityliving);
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float u1, float u2, float u3) {
        TileEntity tile;
        if (player.func_70093_af()) {
            return false;
        }
        ItemStack current = player.func_71045_bC();
        if (current != null) {
            Item item = current.func_77973_b();
            if (item instanceof IActivationBlockingItem) {
                return false;
            }
            if (TrackTools.isRailItem(item)) {
                return false;
            }
        }
        if ((tile = world.func_147438_o(x, y, z)) instanceof TileDetector) {
            return ((TileDetector)tile).blockActivated(player);
        }
        return false;
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        super.func_149695_a(world, x, y, z, block);
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileDetector) {
            TileDetector detector = (TileDetector)tile;
            detector.onNeighborBlockChange(block);
        }
    }

    public boolean rotateBlock(World world, int x, int y, int z, ForgeDirection axis) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileDetector) {
            TileDetector detector = (TileDetector)tile;
            detector.direction = detector.direction == axis ? axis.getOpposite() : axis;
            world.func_147471_g(x, y, z);
            return true;
        }
        return false;
    }

    public ForgeDirection[] getValidRotations(World worldObj, int x, int y, int z) {
        return ForgeDirection.VALID_DIRECTIONS;
    }

    public void func_149651_a(IIconRegister iconRegister) {
        for (EnumDetector det : EnumDetector.VALUES) {
            String name = "railcraft:" + det.getTag();
            det.textures = TextureAtlasSheet.unstitchIcons(iconRegister, name, 3);
        }
    }

    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileDetector) {
            TileDetector detectorTile = (TileDetector)tile;
            EnumDetector det = detectorTile.getDetector().getType();
            if (detectorTile.direction.ordinal() == side) {
                if (detectorTile.powerState != 0) {
                    return det.textures[2];
                }
                return det.textures[1];
            }
            return det.textures[0];
        }
        return null;
    }

    public IIcon func_149691_a(int side, int meta) {
        EnumDetector det = EnumDetector.fromOrdinal(meta);
        if (side == 3) {
            return det.textures[2];
        }
        return det.textures[0];
    }

    public float func_149712_f(World world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileDetector) {
            return ((TileDetector)tile).getDetector().getHardness();
        }
        return super.func_149712_f(world, x, y, z);
    }

    public boolean func_149744_f() {
        return true;
    }

    public int func_149709_b(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity t = world.func_147438_o(x, y, z);
        if (t instanceof TileDetector) {
            TileDetector tile = (TileDetector)t;
            if (tile.direction == MiscTools.getOppositeSide(side)) {
                return tile.powerState;
            }
        }
        return 0;
    }

    public int func_149748_c(IBlockAccess world, int x, int y, int z, int side) {
        return this.func_149709_b(world, x, y, z, side);
    }

    public void func_149726_b(World world, int i, int j, int k) {
        super.func_149726_b(world, i, j, k);
        world.func_147471_g(i, j, k);
        if (Game.isNotHost(world)) {
            return;
        }
        world.func_147459_d(i + 1, j, k, (Block)this);
        world.func_147459_d(i - 1, j, k, (Block)this);
        world.func_147459_d(i, j, k + 1, (Block)this);
        world.func_147459_d(i, j, k - 1, (Block)this);
        world.func_147459_d(i, j - 1, k, (Block)this);
        world.func_147459_d(i, j + 1, k, (Block)this);
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int metadata) {
        super.func_149749_a(world, x, y, z, (Block)this, metadata);
        if (Game.isNotHost(world)) {
            return;
        }
        world.func_147459_d(x + 1, y, z, (Block)this);
        world.func_147459_d(x - 1, y, z, (Block)this);
        world.func_147459_d(x, y, z + 1, (Block)this);
        world.func_147459_d(x, y, z - 1, (Block)this);
        world.func_147459_d(x, y - 1, z, (Block)this);
        world.func_147459_d(x, y + 1, z, (Block)this);
    }

    public boolean canConnectRedstone(IBlockAccess world, int i, int j, int k, int dir) {
        TileEntity t = world.func_147438_o(i, j, k);
        if (t instanceof TileDetector) {
            TileDetector tile = (TileDetector)t;
            if (dir == 1 && tile.direction.ordinal() == 5) {
                return true;
            }
            if (dir == 3 && tile.direction.ordinal() == 4) {
                return true;
            }
            if (dir == 2 && tile.direction.ordinal() == 3) {
                return true;
            }
            if (dir == 0 && tile.direction.ordinal() == 2) {
                return true;
            }
        }
        return false;
    }

    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        for (EnumDetector detector : EnumDetector.VALUES) {
            if (!detector.isEnabled()) continue;
            list.add(detector.getItem());
        }
    }
}

