/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.aesthetics.stairs;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import mods.railcraft.client.particles.ParticleHelper;
import mods.railcraft.client.sounds.RailcraftSound;
import mods.railcraft.common.blocks.aesthetics.EnumBlockMaterial;
import mods.railcraft.common.blocks.aesthetics.stairs.TileStair;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.modules.ModuleManager;
import mods.railcraft.common.plugins.forge.CreativePlugin;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.sounds.IBlockSoundProvider;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStairs;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockRailcraftStairs
extends BlockStairs
implements IBlockSoundProvider {
    static BlockRailcraftStairs block;
    private final int renderId;
    public static int currentRenderPass;

    public static BlockRailcraftStairs getBlock() {
        return block;
    }

    public static ItemStack getItem(EnumBlockMaterial mat) {
        if (block == null) {
            return null;
        }
        return new ItemStack((Block)block, 1, mat.ordinal());
    }

    public static ItemStack getItem(EnumBlockMaterial mat, int qty) {
        if (block == null) {
            return null;
        }
        return new ItemStack((Block)block, qty, mat.ordinal());
    }

    public static String getTag(EnumBlockMaterial mat) {
        return "railcraft.stair." + mat.name().replace("_", ".").toLowerCase(Locale.ENGLISH);
    }

    public static boolean isEnabled(EnumBlockMaterial mat) {
        return ModuleManager.isModuleLoaded(ModuleManager.Module.STRUCTURES) && RailcraftConfig.isSubBlockEnabled(BlockRailcraftStairs.getTag(mat)) && BlockRailcraftStairs.getBlock() != null;
    }

    protected BlockRailcraftStairs(int renderId) {
        super(Blocks.field_150417_aV, 0);
        this.renderId = renderId;
        this.func_149672_a(RailcraftSound.getInstance());
        this.func_149647_a(CreativePlugin.RAILCRAFT_TAB);
        this.field_149783_u = true;
        this.field_149758_A = true;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileStair) {
            return new ItemStack((Block)this, 1, ((TileStair)tile).getStair().ordinal());
        }
        return null;
    }

    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        for (EnumBlockMaterial mat : EnumBlockMaterial.creativeList) {
            if (!BlockRailcraftStairs.isEnabled(mat)) continue;
            list.add(BlockRailcraftStairs.getItem(mat));
        }
    }

    public ArrayList<ItemStack> getDrops(World world, int i, int j, int k, int md, int fortune) {
        TileEntity tile = world.func_147438_o(i, j, k);
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        if (tile instanceof TileStair) {
            items.add(new ItemStack((Block)this, 1, ((TileStair)tile).getStair().ordinal()));
        }
        return items;
    }

    public int quantityDropped(int meta, int fortune, Random random) {
        return 1;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        super.func_149689_a(world, x, y, z, entity, stack);
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileStair) {
            ((TileStair)tile).setStair(EnumBlockMaterial.fromOrdinal(stack.func_77960_j()));
        }
    }

    public void func_149636_a(World world, EntityPlayer entityplayer, int i, int j, int k, int l) {
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        player.func_71064_a(StatList.field_75934_C[BlockRailcraftStairs.func_149682_b((Block)this)], 1);
        player.func_71020_j(0.025f);
        if (Game.isHost(world) && !player.field_71075_bZ.field_75098_d) {
            this.func_149697_b(world, x, y, z, 0, 0);
        }
        return world.func_147468_f(x, y, z);
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int par6) {
        super.func_149749_a(world, x, y, z, block, par6);
        world.func_147475_p(x, y, z);
    }

    public boolean hasTileEntity(int metadata) {
        return true;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        return new TileStair();
    }

    public float func_149712_f(World world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileStair) {
            return ((TileStair)tile).getStair().getBlockHardness(world, x, y, z);
        }
        return super.func_149712_f(world, x, y, z);
    }

    public float getExplosionResistance(Entity entity, World world, int x, int y, int z, double explosionX, double explosionY, double explosionZ) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileStair) {
            return ((TileStair)tile).getStair().getExplosionResistance(entity);
        }
        return super.getExplosionResistance(entity, world, x, y, z, explosionX, explosionY, explosionZ);
    }

    public int func_149645_b() {
        return this.renderId;
    }

    public int func_149701_w() {
        return 1;
    }

    public boolean canRenderInPass(int pass) {
        currentRenderPass = pass;
        return pass == 0 || pass == 1;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return EnumBlockMaterial.fromOrdinal(meta).getIcon(side);
    }

    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileStair) {
            return ((TileStair)tile).getTexture(side);
        }
        return super.func_149673_e(world, x, y, z, side);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(World worldObj, MovingObjectPosition target, EffectRenderer effectRenderer) {
        return ParticleHelper.addHitEffects(worldObj, (Block)block, target, effectRenderer, null);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World worldObj, int x, int y, int z, int meta, EffectRenderer effectRenderer) {
        return ParticleHelper.addDestroyEffects(worldObj, (Block)block, x, y, z, meta, effectRenderer, null);
    }

    @Override
    public Block.SoundType getSound(World world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileStair) {
            return ((TileStair)tile).getStair().getSound();
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister par1IconRegister) {
    }
}

