/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.aesthetics.stairs;

import cpw.mods.fml.common.registry.GameRegistry;
import mods.railcraft.api.crafting.IRockCrusherRecipe;
import mods.railcraft.api.crafting.RailcraftCraftingManager;
import mods.railcraft.common.blocks.BlockFactory;
import mods.railcraft.common.blocks.aesthetics.EnumBlockMaterial;
import mods.railcraft.common.blocks.aesthetics.brick.BlockBrick;
import mods.railcraft.common.blocks.aesthetics.stairs.BlockRailcraftStairs;
import mods.railcraft.common.blocks.aesthetics.stairs.ItemStair;
import mods.railcraft.common.blocks.aesthetics.stairs.TileStair;
import mods.railcraft.common.core.Railcraft;
import mods.railcraft.common.core.RailcraftLanguage;
import mods.railcraft.common.modules.ModuleManager;
import mods.railcraft.common.plugins.forestry.ForestryPlugin;
import mods.railcraft.common.plugins.forge.CraftingPlugin;
import mods.railcraft.common.plugins.forge.ItemRegistry;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;

public class BlockFactoryStairs
extends BlockFactory {
    public BlockFactoryStairs() {
        super("stair");
    }

    @Override
    protected void doBlockInit() {
        int renderId = Railcraft.getProxy().getRenderId();
        BlockRailcraftStairs.block = new BlockRailcraftStairs(renderId);
        BlockRailcraftStairs.block.func_149663_c("railcraft.stair");
        GameRegistry.registerBlock((Block)BlockRailcraftStairs.block, ItemStair.class, (String)BlockRailcraftStairs.block.func_149739_a());
        GameRegistry.registerTileEntity(TileStair.class, (String)"RCStairTile");
        block3: for (EnumBlockMaterial mat : EnumBlockMaterial.VALUES) {
            RailcraftLanguage.instance().registerItemName(BlockRailcraftStairs.getItem(mat), BlockRailcraftStairs.getTag(mat));
            ItemRegistry.registerItemStack(BlockRailcraftStairs.getTag(mat), BlockRailcraftStairs.getItem(mat));
            switch (mat) {
                case SNOW: 
                case ICE: {
                    continue block3;
                }
                default: {
                    ForestryPlugin.addBackpackItem("builder", BlockRailcraftStairs.getItem(mat));
                }
            }
        }
    }

    @Override
    protected void doRecipeInit(ModuleManager.Module module) {
        EnumBlockMaterial.initialize();
        for (EnumBlockMaterial mat : EnumBlockMaterial.VALUES) {
            if (!BlockRailcraftStairs.isEnabled(mat) || mat.getSourceBlock() == null) continue;
            CraftingPlugin.addShapedRecipe(BlockRailcraftStairs.getItem(mat, 4), "S  ", "SS ", "SSS", Character.valueOf('S'), mat.getSourceItem());
            IRockCrusherRecipe recipe = RailcraftCraftingManager.rockCrusher.createNewRecipe(BlockRailcraftStairs.getItem(mat), true, false);
            recipe.addOutput(mat.getSourceItem(), 1.0f);
        }
        this.addRockCrusherRecipe(BlockBrick.abyssal, EnumBlockMaterial.ABYSSAL_BLOCK, EnumBlockMaterial.ABYSSAL_BRICK, EnumBlockMaterial.ABYSSAL_COBBLE, EnumBlockMaterial.ABYSSAL_FITTED);
        this.addRockCrusherRecipe(BlockBrick.bleachedbone, EnumBlockMaterial.BLEACHEDBONE_BLOCK, EnumBlockMaterial.BLEACHEDBONE_BRICK, EnumBlockMaterial.BLEACHEDBONE_COBBLE, EnumBlockMaterial.BLEACHEDBONE_FITTED);
        this.addRockCrusherRecipe(BlockBrick.bloodstained, EnumBlockMaterial.BLOODSTAINED_BLOCK, EnumBlockMaterial.BLOODSTAINED_BRICK, EnumBlockMaterial.BLOODSTAINED_COBBLE, EnumBlockMaterial.BLOODSTAINED_FITTED);
        this.addRockCrusherRecipe(BlockBrick.frostbound, EnumBlockMaterial.FROSTBOUND_BLOCK, EnumBlockMaterial.FROSTBOUND_BRICK, EnumBlockMaterial.FROSTBOUND_COBBLE, EnumBlockMaterial.FROSTBOUND_FITTED);
        this.addRockCrusherRecipe(BlockBrick.infernal, EnumBlockMaterial.INFERNAL_BLOCK, EnumBlockMaterial.INFERNAL_BRICK, EnumBlockMaterial.INFERNAL_COBBLE, EnumBlockMaterial.INFERNAL_FITTED);
        this.addRockCrusherRecipe(BlockBrick.nether, EnumBlockMaterial.NETHER_BLOCK, EnumBlockMaterial.NETHER_COBBLE, EnumBlockMaterial.NETHER_FITTED);
        this.addRockCrusherRecipe(BlockBrick.quarried, EnumBlockMaterial.QUARRIED_BLOCK, EnumBlockMaterial.QUARRIED_BRICK, EnumBlockMaterial.QUARRIED_COBBLE, EnumBlockMaterial.QUARRIED_FITTED);
        this.addRockCrusherRecipe(BlockBrick.sandy, EnumBlockMaterial.SANDY_BLOCK, EnumBlockMaterial.SANDY_BRICK, EnumBlockMaterial.SANDY_COBBLE, EnumBlockMaterial.SANDY_FITTED);
    }

    private void addRockCrusherRecipe(BlockBrick brick, EnumBlockMaterial ... types) {
        if (brick == null) {
            return;
        }
        ItemStack output = brick.getItemStack(BlockBrick.BrickVariant.COBBLE, 1);
        for (EnumBlockMaterial mat : types) {
            if (!BlockRailcraftStairs.isEnabled(mat)) continue;
            IRockCrusherRecipe recipe = RailcraftCraftingManager.rockCrusher.createNewRecipe(BlockRailcraftStairs.getItem(mat), true, false);
            recipe.addOutput(output, 1.0f);
        }
    }
}

