/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.aesthetics.post;

import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.List;
import mods.railcraft.client.util.textures.TextureAtlasSheet;
import mods.railcraft.common.blocks.aesthetics.post.BlockPostBase;
import mods.railcraft.common.blocks.aesthetics.post.EnumPost;
import mods.railcraft.common.blocks.aesthetics.post.ItemPostMetal;
import mods.railcraft.common.core.Railcraft;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.core.RailcraftLanguage;
import mods.railcraft.common.plugins.forestry.ForestryPlugin;
import mods.railcraft.common.plugins.forge.HarvestPlugin;
import mods.railcraft.common.plugins.forge.ItemRegistry;
import mods.railcraft.common.util.misc.EnumColor;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockPostMetal
extends BlockPostBase {
    public static BlockPostMetal post;
    public static BlockPostMetal platform;
    public static IIcon[] textures;
    public final boolean isPlatform;

    private BlockPostMetal(int renderType, boolean isPlatform) {
        super(renderType);
        this.func_149672_a(Block.field_149777_j);
        this.isPlatform = isPlatform;
    }

    public static void registerPost() {
        if (post == null && RailcraftConfig.isBlockEnabled("post.metal")) {
            post = BlockPostMetal.make("post.metal", false);
        }
    }

    public static void registerPlatform() {
        if (platform == null && RailcraftConfig.isBlockEnabled("post.metal.platform")) {
            platform = BlockPostMetal.make("post.metal.platform", true);
        }
    }

    private static BlockPostMetal make(String tag, boolean isPlatform) {
        BlockPostMetal block = new BlockPostMetal(Railcraft.getProxy().getRenderId(), isPlatform);
        block.func_149663_c("railcraft." + tag);
        GameRegistry.registerBlock((Block)block, ItemPostMetal.class, (String)block.func_149739_a());
        HarvestPlugin.setHarvestLevel(block, "crowbar", 0);
        HarvestPlugin.setHarvestLevel(block, "pickaxe", 2);
        ForestryPlugin.addBackpackItem("builder", block);
        for (EnumColor color : EnumColor.values()) {
            ItemStack stack = block.getItem(1, color.ordinal());
            RailcraftLanguage.instance().registerItemName(stack, tag + "." + color.getBasicTag());
            ItemRegistry.registerItemStack(tag + "." + color.getBasicTag(), stack);
        }
        return block;
    }

    @Override
    public boolean isPlatform(int meta) {
        return this.isPlatform;
    }

    public ItemStack getItem() {
        return this.getItem(1, 3);
    }

    public ItemStack getItem(int qty) {
        return this.getItem(qty, 3);
    }

    public ItemStack getItem(int qty, int color) {
        return new ItemStack((Block)this, qty, color);
    }

    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        for (EnumColor color : EnumColor.values()) {
            list.add(this.getItem(1, color.ordinal()));
        }
    }

    protected boolean func_149700_E() {
        return true;
    }

    public boolean canSilkHarvest(World world, EntityPlayer player, int x, int y, int z, int metadata) {
        return true;
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(EnumPost.METAL.getItem());
        return list;
    }

    public void func_149651_a(IIconRegister iconRegister) {
        if (!this.isPlatform) {
            textures = TextureAtlasSheet.unstitchIcons(iconRegister, "railcraft:post.metal.painted", 16);
        }
    }

    public IIcon func_149691_a(int side, int meta) {
        return textures[meta];
    }

    public boolean recolourBlock(World world, int x, int y, int z, ForgeDirection side, int colour) {
        int c = 15 - colour;
        int meta = world.func_72805_g(x, y, z);
        if (meta != c) {
            world.func_72921_c(x, y, z, c, 3);
            return true;
        }
        return false;
    }
}

