/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.aesthetics.post;

import mods.railcraft.client.sounds.RailcraftSound;
import mods.railcraft.common.blocks.signals.MaterialStructure;
import mods.railcraft.common.blocks.tracks.TrackTools;
import mods.railcraft.common.plugins.forge.CreativePlugin;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class BlockPostBase
extends Block {
    private static final float SIZE = 0.15f;
    private static final float SELECT = 0.25f;
    private final int renderType;

    public BlockPostBase(int renderType) {
        super((Material)new MaterialStructure());
        this.renderType = renderType;
        this.func_149672_a(RailcraftSound.getInstance());
        this.func_149752_b(15.0f);
        this.func_149711_c(3.0f);
        this.func_149647_a(CreativePlugin.RAILCRAFT_TAB);
    }

    public boolean isPlatform(int meta) {
        return false;
    }

    public int func_149692_a(int meta) {
        return meta;
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        if (this.isPlatform(world.func_72805_g(x, y, z))) {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        } else {
            this.func_149676_a(0.2f, 0.0f, 0.2f, 0.8f, 1.0f, 0.8f);
        }
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        if (this.isPlatform(world.func_72805_g(x, y, z))) {
            return AxisAlignedBB.func_72332_a().func_72299_a((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1));
        }
        if (!(world.func_147437_c(x, y - 1, z) || world.func_147439_a(x, y - 1, z) instanceof BlockPostBase || TrackTools.isRailBlockAt(world, x, y + 1, z))) {
            return AxisAlignedBB.func_72332_a().func_72299_a((double)((float)x + 0.15f), (double)y, (double)((float)z + 0.15f), (double)((float)(x + 1) - 0.15f), (double)y + 1.5, (double)((float)(z + 1) - 0.15f));
        }
        return AxisAlignedBB.func_72332_a().func_72299_a((double)((float)x + 0.15f), (double)y, (double)((float)z + 0.15f), (double)((float)(x + 1) - 0.15f), (double)(y + 1), (double)((float)(z + 1) - 0.15f));
    }

    public AxisAlignedBB func_149633_g(World world, int x, int y, int z) {
        if (this.isPlatform(world.func_72805_g(x, y, z))) {
            return AxisAlignedBB.func_72332_a().func_72299_a((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1));
        }
        return AxisAlignedBB.func_72332_a().func_72299_a((double)((float)x + 0.25f), (double)y, (double)((float)z + 0.25f), (double)((float)(x + 1) - 0.25f), (double)((float)y + 1.0f), (double)((float)(z + 1) - 0.25f));
    }

    public boolean func_149655_b(IBlockAccess world, int x, int y, int z) {
        return false;
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return side == ForgeDirection.DOWN || side == ForgeDirection.UP;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return this.renderType;
    }

    public boolean func_149637_q() {
        return false;
    }

    public boolean canBeReplacedByLeaves(IBlockAccess world, int x, int y, int z) {
        return false;
    }

    public boolean canCreatureSpawn(EnumCreatureType type, IBlockAccess world, int x, int y, int z) {
        return false;
    }
}

