/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.aesthetics.cube;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import mods.railcraft.client.render.RenderFakeBlock;
import mods.railcraft.client.sounds.RailcraftSound;
import mods.railcraft.common.blocks.aesthetics.cube.EnumCube;
import mods.railcraft.common.blocks.aesthetics.cube.ItemCube;
import mods.railcraft.common.carts.EntityTunnelBore;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.plugins.forestry.ForestryPlugin;
import mods.railcraft.common.plugins.forge.CreativePlugin;
import mods.railcraft.common.plugins.misc.MicroBlockPlugin;
import mods.railcraft.common.util.misc.MiscTools;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockCube
extends Block {
    private static BlockCube instance;
    @SideOnly(value=Side.CLIENT)
    private RenderFakeBlock.RenderInfo override;

    public static BlockCube getBlock() {
        return instance;
    }

    public static void registerBlock() {
        if (instance == null && RailcraftConfig.isBlockEnabled("cube")) {
            instance = new BlockCube();
            GameRegistry.registerBlock((Block)instance, ItemCube.class, (String)instance.func_149739_a());
            EntityTunnelBore.addMineableBlock(instance);
            ForestryPlugin.addBackpackItem("miner", EnumCube.COKE_BLOCK.getItem());
            ForestryPlugin.addBackpackItem("builder", EnumCube.CONCRETE_BLOCK.getItem());
            ForestryPlugin.addBackpackItem("builder", EnumCube.CREOSOTE_BLOCK.getItem());
            ForestryPlugin.addBackpackItem("digger", EnumCube.ABYSSAL_STONE.getItem());
            ForestryPlugin.addBackpackItem("digger", EnumCube.QUARRIED_STONE.getItem());
            MicroBlockPlugin.addMicroBlockCandidate(instance, EnumCube.CONCRETE_BLOCK.ordinal());
            MicroBlockPlugin.addMicroBlockCandidate(instance, EnumCube.CREOSOTE_BLOCK.ordinal());
            MicroBlockPlugin.addMicroBlockCandidate(instance, EnumCube.STEEL_BLOCK.ordinal());
            MicroBlockPlugin.addMicroBlockCandidate(instance, EnumCube.ABYSSAL_STONE.ordinal());
            MicroBlockPlugin.addMicroBlockCandidate(instance, EnumCube.QUARRIED_STONE.ordinal());
        }
    }

    public BlockCube() {
        super(Material.field_151576_e);
        this.func_149663_c("railcraft.cube");
        this.func_149752_b(20.0f);
        this.func_149711_c(5.0f);
        this.func_149672_a(RailcraftSound.getInstance());
        this.func_149647_a(CreativePlugin.RAILCRAFT_TAB);
        this.setHarvestLevel("pickaxe", 1, EnumCube.COKE_BLOCK.ordinal());
        this.setHarvestLevel("pickaxe", 1, EnumCube.ABYSSAL_STONE.ordinal());
        this.setHarvestLevel("pickaxe", 2, EnumCube.STEEL_BLOCK.ordinal());
        this.setHarvestLevel("pickaxe", 1, EnumCube.CONCRETE_BLOCK.ordinal());
        this.setHarvestLevel("crowbar", 0, EnumCube.CONCRETE_BLOCK.ordinal());
        this.setHarvestLevel("axe", 0, EnumCube.CREOSOTE_BLOCK.ordinal());
        this.setHarvestLevel("crowbar", 0, EnumCube.CREOSOTE_BLOCK.ordinal());
        this.setHarvestLevel("shovel", 3, EnumCube.CRUSHED_OBSIDIAN.ordinal());
    }

    public float func_149712_f(World world, int i, int j, int k) {
        int meta = world.func_72805_g(i, j, k);
        return EnumCube.fromOrdinal(meta).getHardness();
    }

    public int func_149692_a(int meta) {
        return meta;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        for (EnumCube cube : EnumCube.VALUES) {
            if (!cube.isEnabled() || cube == EnumCube.CONCRETE_BLOCK || cube == EnumCube.CREOSOTE_BLOCK) continue;
            cube.setIcon(iconRegister.func_94245_a("railcraft:" + MiscTools.cleanTag(cube.getTag())));
        }
        EnumCube.CONCRETE_BLOCK.setIcon(iconRegister.func_94245_a("railcraft:concrete"));
        EnumCube.CREOSOTE_BLOCK.setIcon(iconRegister.func_94245_a("railcraft:post.wood"));
    }

    @SideOnly(value=Side.CLIENT)
    public void setTextureOveride(RenderFakeBlock.RenderInfo info) {
        this.override = info;
    }

    public IIcon func_149691_a(int side, int meta) {
        if (this.override != null) {
            return this.override.getBlockTextureFromSide(side);
        }
        IIcon icon = EnumCube.fromOrdinal(meta).getIcon();
        if (icon == null) {
            return EnumCube.CONCRETE_BLOCK.getIcon();
        }
        return icon;
    }

    public static String getBlockNameFromMetadata(int meta) {
        return EnumCube.fromOrdinal(meta).getTag();
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        int meta = world.func_72805_g(x, y, z);
        EnumCube.fromOrdinal(meta).getBlock().onNeighborBlockChange(world, x, y, z, block);
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        int meta = world.func_72805_g(x, y, z);
        EnumCube.fromOrdinal(meta).getBlock().updateTick(world, x, y, z, rand);
    }

    public void func_149714_e(World world, int i, int j, int k, int meta) {
        EnumCube.fromOrdinal(meta).getBlock().onBlockPlaced(world, i, j, k);
    }

    public void func_149734_b(World world, int i, int j, int k, Random rand) {
        int meta = world.func_72805_g(i, j, k);
        EnumCube.fromOrdinal(meta).getBlock().randomDisplayTick(world, i, j, k, rand);
    }

    public void func_149726_b(World world, int i, int j, int k) {
        int meta = world.func_72805_g(i, j, k);
        EnumCube.fromOrdinal(meta).getBlock().onBlockAdded(world, i, j, k);
    }

    public void func_149749_a(World world, int i, int j, int k, Block block, int meta) {
        EnumCube.fromOrdinal(meta).getBlock().onBlockRemoval(world, i, j, k);
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int i, int j, int k) {
        int meta = world.func_72805_g(i, j, k);
        return EnumCube.fromOrdinal(meta).getBlock().removedByPlayer(world, player, i, j, k);
    }

    public boolean func_149646_a(IBlockAccess world, int x, int y, int z, int side) {
        if (this.override != null) {
            return true;
        }
        return super.func_149646_a(world, x, y, z, side);
    }

    public boolean canCreatureSpawn(EnumCreatureType type, IBlockAccess world, int i, int j, int k) {
        int meta = world.func_72805_g(i, j, k);
        return EnumCube.fromOrdinal(meta).getBlock().canCreatureSpawn(type, world, i, j, k);
    }

    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        for (EnumCube type : EnumCube.getCreativeList()) {
            if (!type.isEnabled()) continue;
            list.add(type.getItem());
        }
    }

    public float getExplosionResistance(Entity exploder, World world, int i, int j, int k, double srcX, double srcY, double srcZ) {
        int meta = world.func_72805_g(i, j, k);
        return EnumCube.fromOrdinal(meta).getResistance() * 3.0f / 5.0f;
    }

    public int getFireSpreadSpeed(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        int metadata = world.func_72805_g(x, y, z);
        return EnumCube.fromOrdinal(metadata).getBlock().getFireSpreadSpeed(world, x, y, z, face);
    }

    public int getFlammability(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        int metadata = world.func_72805_g(x, y, z);
        return EnumCube.fromOrdinal(metadata).getBlock().getFlammability(world, x, y, z, face);
    }

    public boolean isFlammable(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        int metadata = world.func_72805_g(x, y, z);
        return EnumCube.fromOrdinal(metadata).getBlock().isFlammable(world, x, y, z, face);
    }
}

