/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.render.carts;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import mods.railcraft.api.carts.locomotive.IRenderer;
import mods.railcraft.client.render.RenderFakeBlock;
import mods.railcraft.client.render.carts.CartContentRenderer;
import mods.railcraft.client.render.carts.CartContentRendererMaintance;
import mods.railcraft.client.render.carts.CartContentRendererTNT;
import mods.railcraft.client.render.carts.CartContentRendererTank;
import mods.railcraft.client.render.carts.CartModelRenderer;
import mods.railcraft.client.render.carts.LocomotiveRenderer;
import mods.railcraft.common.carts.CartExplosiveBase;
import mods.railcraft.common.carts.CartMaintanceBase;
import mods.railcraft.common.carts.EntityCartTank;
import mods.railcraft.common.carts.EntityLocomotive;
import mods.railcraft.common.carts.IDirectionalCart;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import org.lwjgl.opengl.GL11;

public class RenderCart
extends Render
implements IRenderer {
    private final Random rand = new Random();
    private final RenderFakeBlock.RenderInfo fakeBlock = new RenderFakeBlock.RenderInfo();
    private static final Map<Class, CartModelRenderer> renderersCore = new HashMap<Class, CartModelRenderer>();
    private static final Map<Class, CartContentRenderer> renderersContent = new HashMap<Class, CartContentRenderer>();
    private static final CartModelRenderer defaultCoreRenderer = new CartModelRenderer();
    private static final CartContentRenderer defaultContentRenderer = new CartContentRenderer();

    public RenderCart() {
        this.field_76989_e = 0.5f;
        this.fakeBlock.texture = new IIcon[6];
        renderersCore.put(EntityLocomotive.class, LocomotiveRenderer.INSTANCE);
        renderersContent.put(EntityCartTank.class, new CartContentRendererTank());
        renderersContent.put(CartExplosiveBase.class, new CartContentRendererTNT());
        renderersContent.put(CartMaintanceBase.class, new CartContentRendererMaintance());
    }

    public void renderCart(EntityMinecart cart, double x, double y, double z, float yaw, float time) {
        float light;
        boolean renderContents;
        GL11.glPushMatrix();
        long var10 = (long)cart.func_145782_y() * 493286711L;
        var10 = var10 * var10 * 4392167121L + var10 * 98761L;
        float tx = (((float)(var10 >> 16 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        float ty = (((float)(var10 >> 20 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        float tz = (((float)(var10 >> 24 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        GL11.glTranslatef((float)tx, (float)ty, (float)tz);
        double mx = cart.field_70142_S + (cart.field_70165_t - cart.field_70142_S) * (double)time;
        double my = cart.field_70137_T + (cart.field_70163_u - cart.field_70137_T) * (double)time;
        double mz = cart.field_70136_U + (cart.field_70161_v - cart.field_70136_U) * (double)time;
        double d6 = 0.3;
        Vec3 vec3d = cart.func_70489_a(mx, my, mz);
        float pitch = cart.field_70127_C + (cart.field_70125_A - cart.field_70127_C) * time;
        if (vec3d != null) {
            Vec3 vec3d1 = cart.func_70495_a(mx, my, mz, d6);
            Vec3 vec3d2 = cart.func_70495_a(mx, my, mz, -d6);
            if (vec3d1 == null) {
                vec3d1 = vec3d;
            }
            if (vec3d2 == null) {
                vec3d2 = vec3d;
            }
            x += vec3d.field_72450_a - mx;
            y += (vec3d1.field_72448_b + vec3d2.field_72448_b) / 2.0 - my;
            z += vec3d.field_72449_c - mz;
            Vec3 vec3d3 = vec3d2.func_72441_c(-vec3d1.field_72450_a, -vec3d1.field_72448_b, -vec3d1.field_72449_c);
            if (vec3d3.func_72433_c() != 0.0) {
                vec3d3 = vec3d3.func_72432_b();
                yaw = (float)(Math.atan2(vec3d3.field_72449_c, vec3d3.field_72450_a) / Math.PI) * 180.0f;
                pitch = (float)(Math.atan(vec3d3.field_72448_b) * 73.0);
            }
        }
        if (cart instanceof IDirectionalCart) {
            if ((yaw %= 360.0f) < 0.0f) {
                yaw += 360.0f;
            }
            yaw += 360.0f;
            double serverYaw = cart.field_70177_z;
            serverYaw += 180.0;
            if ((serverYaw %= 360.0) < 0.0) {
                serverYaw += 360.0;
            }
            if (Math.abs((double)yaw - (serverYaw += 360.0)) > 90.0) {
                yaw += 180.0f;
                pitch = -pitch;
            }
            ((IDirectionalCart)cart).setRenderYaw(yaw);
        }
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        GL11.glRotatef((float)(180.0f - yaw), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(-pitch), (float)0.0f, (float)0.0f, (float)1.0f);
        float f3 = (float)cart.func_70496_j() - time;
        float f4 = cart.func_70491_i() - time;
        if (f4 < 0.0f) {
            f4 = 0.0f;
        }
        if (f3 > 0.0f) {
            float angle = MathHelper.func_76126_a((float)f3) * f3 * f4 / 10.0f;
            angle = Math.min(angle, 0.8f);
            angle = Math.copySign(angle, cart.func_70493_k());
            GL11.glRotatef((float)angle, (float)1.0f, (float)0.0f, (float)0.0f);
        }
        if (renderContents = this.renderCore(cart, light = cart.func_70013_c(time), time)) {
            float blockScale = 0.74f;
            GL11.glScalef((float)blockScale, (float)blockScale, (float)blockScale);
            GL11.glPushAttrib((int)64);
            this.renderContents(cart, light, time);
            GL11.glPopAttrib();
        }
        GL11.glPopMatrix();
    }

    private boolean renderCore(EntityMinecart cart, float light, float time) {
        return this.getCoreRenderer(cart.getClass()).render(this, cart, light, time);
    }

    private void renderContents(EntityMinecart cart, float light, float time) {
        this.getContentRenderer(cart.getClass()).render(this, cart, light, time);
    }

    public CartModelRenderer getCoreRenderer(Class eClass) {
        CartModelRenderer render = renderersCore.get(eClass);
        if (render == null && eClass != EntityMinecart.class) {
            render = this.getCoreRenderer(eClass.getSuperclass());
            if (render == null) {
                render = defaultCoreRenderer;
            }
            renderersCore.put(eClass, render);
        }
        return render;
    }

    public CartContentRenderer getContentRenderer(Class eClass) {
        CartContentRenderer render = renderersContent.get(eClass);
        if (render == null && eClass != EntityMinecart.class) {
            render = this.getContentRenderer(eClass.getSuperclass());
            if (render == null) {
                render = defaultContentRenderer;
            }
            renderersContent.put(eClass, render);
        }
        return render;
    }

    public void func_76986_a(Entity entity, double x, double y, double d2, float yaw, float time) {
        this.renderCart((EntityMinecart)entity, x, y, d2, yaw, time);
    }

    @Override
    public void bindTex(ResourceLocation texture) {
        super.func_110776_a(texture);
    }

    public RenderBlocks renderBlocks() {
        return this.field_147909_c;
    }

    protected ResourceLocation func_110775_a(Entity entity) {
        return null;
    }
}

