/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.render;

import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.opengl.GL11;

public class RenderTools {
    public static final int BOX_BRIGHTNESS = 165;
    public static final float PIXEL = 0.0625f;

    public static boolean renderStandardBlock(RenderBlocks renderblocks, Block block, int x, int y, int z) {
        renderblocks.func_147775_a(block);
        return renderblocks.func_147784_q(block, x, y, z);
    }

    public static boolean renderStandardBlockWithColorMultiplier(RenderBlocks renderblocks, Block block, int x, int y, int z) {
        renderblocks.func_147775_a(block);
        int mult = block.func_149720_d(renderblocks.field_147845_a, x, y, z);
        float r = (float)(mult >> 16 & 0xFF) / 255.0f;
        float g = (float)(mult >> 8 & 0xFF) / 255.0f;
        float b = (float)(mult & 0xFF) / 255.0f;
        if (EntityRenderer.field_78517_a) {
            float var9 = (r * 30.0f + g * 59.0f + b * 11.0f) / 100.0f;
            float var10 = (r * 30.0f + g * 70.0f) / 100.0f;
            float var11 = (r * 30.0f + b * 70.0f) / 100.0f;
            r = var9;
            g = var10;
            b = var11;
        }
        return renderblocks.func_147736_d(block, x, y, z, r, g, b);
    }

    public static void renderBlockSideWithBrightness(RenderBlocks renderblocks, IBlockAccess world, Block block, int i, int j, int k, int side, int brightness) {
        renderblocks.func_147775_a(block);
        renderblocks.field_147863_w = false;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78386_a(1.0f, 1.0f, 1.0f);
        tessellator.func_78380_c(brightness);
        if (side == 0) {
            renderblocks.func_147768_a(block, (double)i, (double)j, (double)k, block.func_149673_e(world, i, j, k, 0));
        } else if (side == 1) {
            renderblocks.func_147806_b(block, (double)i, (double)j, (double)k, block.func_149673_e(world, i, j, k, 1));
        } else if (side == 2) {
            renderblocks.func_147761_c(block, (double)i, (double)j, (double)k, block.func_149673_e(world, i, j, k, 2));
        } else if (side == 3) {
            renderblocks.func_147734_d(block, (double)i, (double)j, (double)k, block.func_149673_e(world, i, j, k, 3));
        } else if (side == 4) {
            renderblocks.func_147798_e(block, (double)i, (double)j, (double)k, block.func_149673_e(world, i, j, k, 4));
        } else if (side == 5) {
            renderblocks.func_147764_f(block, (double)i, (double)j, (double)k, block.func_149673_e(world, i, j, k, 5));
        }
    }

    public static void renderBlockOnInventory(RenderBlocks renderblocks, Block block, int meta, float light) {
        RenderTools.renderBlockOnInventory(renderblocks, block, meta, light, -1);
    }

    public static void renderBlockOnInventory(RenderBlocks renderblocks, Block block, int meta, float light, int side) {
        RenderTools.renderBlockOnInventory(renderblocks, block, meta, light, side, null);
    }

    public static void renderBlockOnInventory(RenderBlocks renderblocks, Block block, int meta, float light, int side, IIcon iconOveride) {
        IIcon icon;
        Tessellator tessellator = Tessellator.field_78398_a;
        block.func_149683_g();
        renderblocks.func_147775_a(block);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        if (side == 0 || side == -1) {
            tessellator.func_78382_b();
            tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
            IIcon iIcon = icon = iconOveride == null ? block.func_149691_a(0, meta) : iconOveride;
            if (icon != null) {
                renderblocks.func_147768_a(block, 0.0, 0.0, 0.0, icon);
            }
            tessellator.func_78381_a();
        }
        if (side == 1 || side == -1) {
            tessellator.func_78382_b();
            tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
            IIcon iIcon = icon = iconOveride == null ? block.func_149691_a(1, meta) : iconOveride;
            if (icon != null) {
                renderblocks.func_147806_b(block, 0.0, 0.0, 0.0, icon);
            }
            tessellator.func_78381_a();
        }
        if (side == 2 || side == -1) {
            tessellator.func_78382_b();
            tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
            IIcon iIcon = icon = iconOveride == null ? block.func_149691_a(2, meta) : iconOveride;
            if (icon != null) {
                renderblocks.func_147761_c(block, 0.0, 0.0, 0.0, icon);
            }
            tessellator.func_78381_a();
        }
        if (side == 3 || side == -1) {
            tessellator.func_78382_b();
            tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
            IIcon iIcon = icon = iconOveride == null ? block.func_149691_a(3, meta) : iconOveride;
            if (icon != null) {
                renderblocks.func_147734_d(block, 0.0, 0.0, 0.0, icon);
            }
            tessellator.func_78381_a();
        }
        if (side == 4 || side == -1) {
            tessellator.func_78382_b();
            tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
            IIcon iIcon = icon = iconOveride == null ? block.func_149691_a(4, meta) : iconOveride;
            if (icon != null) {
                renderblocks.func_147798_e(block, 0.0, 0.0, 0.0, icon);
            }
            tessellator.func_78381_a();
        }
        if (side == 5 || side == -1) {
            tessellator.func_78382_b();
            tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
            IIcon iIcon = icon = iconOveride == null ? block.func_149691_a(5, meta) : iconOveride;
            if (icon != null) {
                renderblocks.func_147764_f(block, 0.0, 0.0, 0.0, icon);
            }
            tessellator.func_78381_a();
        }
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
    }

    public static IIcon getSafeIcon(IIcon icon) {
        if (icon == null) {
            return RenderTools.getMissingIcon();
        }
        return icon;
    }

    public static IIcon getMissingIcon() {
        return ((TextureMap)Minecraft.func_71410_x().func_110434_K().func_110581_b(TextureMap.field_110575_b)).func_110572_b("missingno");
    }
}

