/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.render;

import mods.railcraft.api.tracks.ITrackSwitch;
import mods.railcraft.client.render.ICombinedRenderer;
import mods.railcraft.client.render.RenderFakeBlock;
import mods.railcraft.common.blocks.signals.BlockSignal;
import mods.railcraft.common.blocks.signals.EnumSignal;
import mods.railcraft.common.blocks.signals.TileSwitchBase;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.Vec3;
import net.minecraft.util.Vec3Pool;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class RenderSwitch
implements ICombinedRenderer {
    private static final float PIX = 0.0625f;
    private static final int LEVER_HEIGHT = 10;
    private EnumSignal type;
    private RenderFakeBlock.RenderInfo info = new RenderFakeBlock.RenderInfo();

    public RenderSwitch(EnumSignal signal) {
        this.type = signal;
        this.info.texture = new IIcon[6];
    }

    @Override
    public void renderBlock(RenderBlocks renderblocks, IBlockAccess world, int x, int y, int z, Block block) {
        TileSwitchBase tile = (TileSwitchBase)world.func_147438_o(x, y, z);
        ITrackSwitch track = null;
        boolean powered = false;
        byte facing = 0;
        if (tile != null) {
            track = tile.getSwitchTrack();
            facing = tile.getFacing();
            powered = tile.isPowered();
        }
        this.setTextureCore();
        float f = 0.25f;
        float f1 = 0.75f;
        this.info.setBlockBounds(f, 0.0f, f, f1, 0.3125f, f1);
        RenderFakeBlock.renderAsBlock(this.info, renderblocks, world, x, y, z);
        f = 0.4375f;
        f1 = 0.5625f;
        this.info.setBlockBounds(f, 0.0f, f, f1, 0.5f, f1);
        RenderFakeBlock.renderAsBlock(this.info, renderblocks, world, x, y, z);
        this.info.setBlockBounds(f, 0.6875f, f, f1, 0.75f, f1);
        RenderFakeBlock.renderAsBlock(this.info, renderblocks, world, x, y, z);
        this.setTextureExtension();
        if (facing == 2 || facing == 3) {
            this.info.setBlockBounds(0.374375f, 0.0f, 0.0f, 0.625625f, 0.188125f, 1.0f);
            RenderFakeBlock.renderAsBlock(this.info, renderblocks, world, x, y, z);
        } else {
            this.info.setBlockBounds(0.0f, 0.0f, 0.374375f, 1.0f, 0.188125f, 0.625625f);
            RenderFakeBlock.renderAsBlock(this.info, renderblocks, world, x, y, z);
        }
        if (track == null) {
            this.setTextureWhite();
            this.renderTargetNorthSouth(renderblocks, world, x, y, z);
            this.setTextureRed();
            this.renderTargetEastWest(renderblocks, world, x, y, z);
            return;
        }
        this.setTextureWhite();
        ITrackSwitch.ArrowDirection whiteArrow = track.getWhiteSignDirection();
        this.renderTarget(whiteArrow, renderblocks, world, x, y, z);
        this.setTextureRed();
        ITrackSwitch.ArrowDirection redArrow = track.getRedSignDirection();
        this.renderTarget(redArrow, renderblocks, world, x, y, z);
        if (this.type == EnumSignal.SWITCH_LEVER) {
            this.renderLever(world.func_82732_R(), x, y, z, facing, powered);
        }
    }

    private void setTextureCore() {
        IIcon icon;
        this.info.texture[0] = BlockSignal.texturesSwitch[0];
        this.info.texture[1] = BlockSignal.texturesSwitch[0];
        this.info.texture[2] = icon = this.type.getIcon();
        this.info.texture[3] = icon;
        this.info.texture[4] = icon;
        this.info.texture[5] = icon;
    }

    private void setTextureExtension() {
        this.info.texture[0] = BlockSignal.texturesSwitch[0];
        this.info.texture[1] = BlockSignal.texturesSwitch[0];
        this.info.texture[2] = BlockSignal.texturesSwitch[1];
        this.info.texture[3] = BlockSignal.texturesSwitch[1];
        this.info.texture[4] = BlockSignal.texturesSwitch[1];
        this.info.texture[5] = BlockSignal.texturesSwitch[1];
    }

    private void setTextureWhite() {
        for (int i = 0; i < 6; ++i) {
            this.info.texture[i] = BlockSignal.texturesSwitchTarget[0];
        }
    }

    private void setTextureRed() {
        for (int i = 0; i < 6; ++i) {
            this.info.texture[i] = BlockSignal.texturesSwitchTarget[1];
        }
    }

    private void renderLever(Vec3Pool vecPool, double x, double y, double z, int facing, boolean thrown) {
        IIcon icon = BlockSignal.texturesSwitchLever;
        float pix = 0.0625f;
        Tessellator tess = Tessellator.field_78398_a;
        Vec3[] vertices = new Vec3[8];
        float vx = pix;
        float vz = pix;
        float vy = pix * 10.0f;
        vertices[0] = vecPool.func_72345_a((double)(-vx), 0.0, (double)(-vz));
        vertices[1] = vecPool.func_72345_a((double)vx, 0.0, (double)(-vz));
        vertices[2] = vecPool.func_72345_a((double)vx, 0.0, (double)vz);
        vertices[3] = vecPool.func_72345_a((double)(-vx), 0.0, (double)vz);
        vertices[4] = vecPool.func_72345_a((double)(-vx), (double)vy, (double)(-vz));
        vertices[5] = vecPool.func_72345_a((double)vx, (double)vy, (double)(-vz));
        vertices[6] = vecPool.func_72345_a((double)vx, (double)vy, (double)vz);
        vertices[7] = vecPool.func_72345_a((double)(-vx), (double)vy, (double)vz);
        for (int i = 0; i < 8; ++i) {
            if (thrown) {
                vertices[i].field_72449_c -= 0.0625;
                vertices[i].func_72440_a(0.69813174f);
            } else {
                vertices[i].field_72449_c += 0.0625;
                vertices[i].func_72440_a(-0.69813174f);
            }
            vertices[i].field_72450_a += (double)(pix * 6.0f);
            if (facing == 2) {
                vertices[i].func_72442_b(4.712389f);
            } else if (facing == 3) {
                vertices[i].func_72442_b(1.5707964f);
            } else if (facing == 5) {
                vertices[i].func_72442_b((float)Math.PI);
            }
            vertices[i].field_72450_a += x + 0.5;
            vertices[i].field_72448_b += y + 0.125;
            vertices[i].field_72449_c += z + 0.5;
        }
        double minU = icon.func_94214_a(7.0);
        double minV = icon.func_94207_b(6.0);
        double maxU = icon.func_94214_a(9.0);
        double maxV = icon.func_94207_b(8.0);
        for (int side = 0; side < 6; ++side) {
            Vec3 vertex4;
            Vec3 vertex3;
            Vec3 vertex2;
            Vec3 vertex1;
            if (side == 2) {
                maxV = icon.func_94210_h();
            }
            if (side == 0) {
                vertex1 = vertices[0];
                vertex2 = vertices[1];
                vertex3 = vertices[2];
                vertex4 = vertices[3];
            } else if (side == 1) {
                vertex1 = vertices[7];
                vertex2 = vertices[6];
                vertex3 = vertices[5];
                vertex4 = vertices[4];
            } else if (side == 2) {
                vertex1 = vertices[1];
                vertex2 = vertices[0];
                vertex3 = vertices[4];
                vertex4 = vertices[5];
            } else if (side == 3) {
                vertex1 = vertices[2];
                vertex2 = vertices[1];
                vertex3 = vertices[5];
                vertex4 = vertices[6];
            } else if (side == 4) {
                vertex1 = vertices[3];
                vertex2 = vertices[2];
                vertex3 = vertices[6];
                vertex4 = vertices[7];
            } else {
                vertex1 = vertices[0];
                vertex2 = vertices[3];
                vertex3 = vertices[7];
                vertex4 = vertices[4];
            }
            tess.func_78374_a(vertex1.field_72450_a, vertex1.field_72448_b, vertex1.field_72449_c, minU, maxV);
            tess.func_78374_a(vertex2.field_72450_a, vertex2.field_72448_b, vertex2.field_72449_c, maxU, maxV);
            tess.func_78374_a(vertex3.field_72450_a, vertex3.field_72448_b, vertex3.field_72449_c, maxU, minV);
            tess.func_78374_a(vertex4.field_72450_a, vertex4.field_72448_b, vertex4.field_72449_c, minU, minV);
        }
    }

    private void renderTarget(ITrackSwitch.ArrowDirection arrow, RenderBlocks renderblocks, IBlockAccess world, int x, int y, int z) {
        switch (arrow) {
            case NORTH: {
                this.renderTargetNorth(renderblocks, world, x, y, z);
                break;
            }
            case SOUTH: {
                this.renderTargetSouth(renderblocks, world, x, y, z);
                break;
            }
            case EAST: {
                this.renderTargetEast(renderblocks, world, x, y, z);
                break;
            }
            case WEST: {
                this.renderTargetWest(renderblocks, world, x, y, z);
                break;
            }
            case NORTH_SOUTH: {
                this.renderTargetNorthSouth(renderblocks, world, x, y, z);
                break;
            }
            case EAST_WEST: {
                this.renderTargetEastWest(renderblocks, world, x, y, z);
            }
        }
    }

    private void renderTargetNorthSouth(RenderBlocks renderblocks, IBlockAccess world, int x, int y, int z) {
        this.info.setBlockBounds(0.5f, 0.5f, 0.25f, 0.5625f, 0.6875f, 0.5f);
        RenderFakeBlock.renderAsBlock(this.info, renderblocks, world, x, y, z);
        this.info.setBlockBounds(0.4375f, 0.5f, 0.5f, 0.5f, 0.6875f, 0.75f);
        RenderFakeBlock.renderAsBlock(this.info, renderblocks, world, x, y, z);
    }

    private void renderTargetEastWest(RenderBlocks renderblocks, IBlockAccess world, int x, int y, int z) {
        this.info.setBlockBounds(0.25f, 0.5f, 0.4375f, 0.5f, 0.6875f, 0.5f);
        RenderFakeBlock.renderAsBlock(this.info, renderblocks, world, x, y, z);
        this.info.setBlockBounds(0.5f, 0.5f, 0.5f, 0.75f, 0.6875f, 0.5625f);
        RenderFakeBlock.renderAsBlock(this.info, renderblocks, world, x, y, z);
    }

    private void renderTargetNorth(RenderBlocks renderblocks, IBlockAccess world, int x, int y, int z) {
        this.info.setBlockBounds(0.5f, 0.5f, 0.25f, 0.5625f, 0.6875f, 0.5f);
        RenderFakeBlock.renderAsBlock(this.info, renderblocks, world, x, y, z);
        this.info.setBlockBounds(0.4375f, 0.5f, 0.5f, 0.5f, 0.6875f, 0.75f);
        RenderFakeBlock.renderAsBlock(this.info, renderblocks, world, x, y, z);
        this.info.setBlockBounds(0.5f, 0.5625f, 0.1875f, 0.5625f, 0.625f, 0.25f);
        RenderFakeBlock.renderAsBlock(this.info, renderblocks, world, x, y, z);
        this.info.setBlockBounds(0.4375f, 0.5f, 0.75f, 0.5f, 0.5625f, 0.8125f);
        RenderFakeBlock.renderAsBlock(this.info, renderblocks, world, x, y, z);
        this.info.setBlockBounds(0.4375f, 0.625f, 0.75f, 0.5f, 0.6875f, 0.8125f);
        RenderFakeBlock.renderAsBlock(this.info, renderblocks, world, x, y, z);
    }

    private void renderTargetSouth(RenderBlocks renderblocks, IBlockAccess world, int x, int y, int z) {
        this.info.setBlockBounds(0.5f, 0.5f, 0.25f, 0.5625f, 0.6875f, 0.5f);
        RenderFakeBlock.renderAsBlock(this.info, renderblocks, world, x, y, z);
        this.info.setBlockBounds(0.4375f, 0.5f, 0.5f, 0.5f, 0.6875f, 0.75f);
        RenderFakeBlock.renderAsBlock(this.info, renderblocks, world, x, y, z);
        this.info.setBlockBounds(0.4375f, 0.5625f, 0.75f, 0.5f, 0.625f, 0.8125f);
        RenderFakeBlock.renderAsBlock(this.info, renderblocks, world, x, y, z);
        this.info.setBlockBounds(0.5f, 0.5f, 0.1875f, 0.5625f, 0.5625f, 0.25f);
        RenderFakeBlock.renderAsBlock(this.info, renderblocks, world, x, y, z);
        this.info.setBlockBounds(0.5f, 0.625f, 0.1875f, 0.5625f, 0.6875f, 0.25f);
        RenderFakeBlock.renderAsBlock(this.info, renderblocks, world, x, y, z);
    }

    private void renderTargetEast(RenderBlocks renderblocks, IBlockAccess world, int x, int y, int z) {
        this.info.setBlockBounds(0.25f, 0.5f, 0.4375f, 0.5f, 0.6875f, 0.5f);
        RenderFakeBlock.renderAsBlock(this.info, renderblocks, world, x, y, z);
        this.info.setBlockBounds(0.5f, 0.5f, 0.5f, 0.75f, 0.6875f, 0.5625f);
        RenderFakeBlock.renderAsBlock(this.info, renderblocks, world, x, y, z);
        this.info.setBlockBounds(0.1875f, 0.5625f, 0.4375f, 0.25f, 0.625f, 0.5f);
        RenderFakeBlock.renderAsBlock(this.info, renderblocks, world, x, y, z);
        this.info.setBlockBounds(0.75f, 0.5f, 0.5f, 0.8125f, 0.5625f, 0.5625f);
        RenderFakeBlock.renderAsBlock(this.info, renderblocks, world, x, y, z);
        this.info.setBlockBounds(0.75f, 0.625f, 0.5f, 0.8125f, 0.6875f, 0.5625f);
        RenderFakeBlock.renderAsBlock(this.info, renderblocks, world, x, y, z);
    }

    private void renderTargetWest(RenderBlocks renderblocks, IBlockAccess world, int x, int y, int z) {
        this.info.setBlockBounds(0.25f, 0.5f, 0.4375f, 0.5f, 0.6875f, 0.5f);
        RenderFakeBlock.renderAsBlock(this.info, renderblocks, world, x, y, z);
        this.info.setBlockBounds(0.5f, 0.5f, 0.5f, 0.75f, 0.6875f, 0.5625f);
        RenderFakeBlock.renderAsBlock(this.info, renderblocks, world, x, y, z);
        this.info.setBlockBounds(0.75f, 0.5625f, 0.5f, 0.8125f, 0.625f, 0.5625f);
        RenderFakeBlock.renderAsBlock(this.info, renderblocks, world, x, y, z);
        this.info.setBlockBounds(0.1875f, 0.5f, 0.4375f, 0.25f, 0.5625f, 0.5f);
        RenderFakeBlock.renderAsBlock(this.info, renderblocks, world, x, y, z);
        this.info.setBlockBounds(0.1875f, 0.625f, 0.4375f, 0.25f, 0.6875f, 0.5f);
        RenderFakeBlock.renderAsBlock(this.info, renderblocks, world, x, y, z);
    }

    @Override
    public void renderItem(RenderBlocks renderblocks, ItemStack item, IItemRenderer.ItemRenderType renderType) {
        switch (renderType) {
            case EQUIPPED: 
            case EQUIPPED_FIRST_PERSON: 
            case ENTITY: {
                float scale = 1.5f;
                GL11.glScalef((float)scale, (float)scale, (float)scale);
            }
        }
        this.setTextureCore();
        float min = 0.25f;
        float max = 0.75f;
        this.info.setBlockBounds(min, 0.0f, min, max, 0.3125f, max);
        RenderFakeBlock.renderBlockOnInventory(renderblocks, this.info, 1.0f);
        min = 0.4375f;
        max = 0.5625f;
        this.info.setBlockBounds(min, 0.0f, min, max, 0.5f, max);
        RenderFakeBlock.renderBlockOnInventory(renderblocks, this.info, 1.0f);
        this.info.setBlockBounds(min, 0.6875f, min, max, 0.75f, max);
        RenderFakeBlock.renderBlockOnInventory(renderblocks, this.info, 1.0f);
        this.setTextureExtension();
        this.info.setBlockBounds(0.375f, 0.0f, 0.0f, 0.625f, 0.1875f, 1.0f);
        RenderFakeBlock.renderBlockOnInventory(renderblocks, this.info, 1.0f);
        this.setTextureRed();
        this.info.setBlockBounds(0.25f, 0.5f, 0.4375f, 0.5f, 0.6875f, 0.5f);
        RenderFakeBlock.renderBlockOnInventory(renderblocks, this.info, 1.0f);
        this.info.setBlockBounds(0.5f, 0.5f, 0.5f, 0.75f, 0.6875f, 0.5625f);
        RenderFakeBlock.renderBlockOnInventory(renderblocks, this.info, 1.0f);
        this.info.setBlockBounds(0.75f, 0.5625f, 0.5f, 0.8125f, 0.625f, 0.5625f);
        RenderFakeBlock.renderBlockOnInventory(renderblocks, this.info, 1.0f);
        this.info.setBlockBounds(0.1875f, 0.5f, 0.4375f, 0.25f, 0.5625f, 0.5f);
        RenderFakeBlock.renderBlockOnInventory(renderblocks, this.info, 1.0f);
        this.info.setBlockBounds(0.1875f, 0.625f, 0.4375f, 0.25f, 0.6875f, 0.5f);
        RenderFakeBlock.renderBlockOnInventory(renderblocks, this.info, 1.0f);
        this.setTextureWhite();
        this.info.setBlockBounds(0.5f, 0.5f, 0.25f, 0.5625f, 0.6875f, 0.5f);
        RenderFakeBlock.renderBlockOnInventory(renderblocks, this.info, 1.0f);
        this.info.setBlockBounds(0.4375f, 0.5f, 0.5f, 0.5f, 0.6875f, 0.75f);
        RenderFakeBlock.renderBlockOnInventory(renderblocks, this.info, 1.0f);
        if (this.type == EnumSignal.SWITCH_LEVER) {
            Tessellator tess = Tessellator.field_78398_a;
            tess.func_78382_b();
            this.renderLever(Game.getWorld().func_82732_R(), -0.5, -0.5, -0.5, 3, false);
            tess.func_78381_a();
        }
    }
}

