/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.render;

import mods.railcraft.client.render.FluidRenderer;
import mods.railcraft.client.render.RenderFakeBlock;
import mods.railcraft.common.blocks.machine.gamma.EnumMachineGamma;
import mods.railcraft.common.blocks.machine.gamma.TileLiquidLoader;
import mods.railcraft.common.blocks.machine.gamma.TileLoaderLiquidBase;
import mods.railcraft.common.fluids.tanks.StandardTank;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class RenderLiquidLoader
extends TileEntitySpecialRenderer {
    private static final float PIPE_OFFSET = 0.3125f;
    private static final RenderFakeBlock.RenderInfo backDrop = new RenderFakeBlock.RenderInfo();
    private static final RenderFakeBlock.RenderInfo pipe = new RenderFakeBlock.RenderInfo();

    public RenderLiquidLoader() {
        RenderLiquidLoader.backDrop.minX = 0.011f;
        RenderLiquidLoader.backDrop.minY = 0.01f;
        RenderLiquidLoader.backDrop.minZ = 0.011f;
        RenderLiquidLoader.backDrop.maxX = 0.989f;
        RenderLiquidLoader.backDrop.maxY = 0.99f;
        RenderLiquidLoader.backDrop.maxZ = 0.989f;
        RenderLiquidLoader.pipe.texture = EnumMachineGamma.pipeTexture;
        RenderLiquidLoader.pipe.minX = 0.3125f;
        RenderLiquidLoader.pipe.minZ = 0.3125f;
        RenderLiquidLoader.pipe.maxX = 0.6875f;
        RenderLiquidLoader.pipe.maxY = 0.0625f;
        RenderLiquidLoader.pipe.maxZ = 0.6875f;
        RenderLiquidLoader.backDrop.texture = new IIcon[1];
    }

    public void func_147500_a(TileEntity tile, double x, double y, double z, float f) {
        int[] displayLists;
        TileLoaderLiquidBase base = (TileLoaderLiquidBase)tile;
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)8192);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)3042);
        RenderLiquidLoader.backDrop.texture[0] = base.getMachineType().getTexture(7);
        this.func_147499_a(TextureMap.field_110575_b);
        RenderFakeBlock.renderBlock(backDrop, (IBlockAccess)base.getWorld(), x, y, z, false, true);
        GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 0.5f), (float)((float)z + 0.5f));
        GL11.glScalef((float)1.0f, (float)0.6f, (float)1.0f);
        StandardTank tank = base.getTankManager().get(0);
        FluidStack fluidStack = tank.getFluid();
        if (fluidStack != null && fluidStack.amount > 0 && (displayLists = FluidRenderer.getLiquidDisplayLists(fluidStack)) != null) {
            GL11.glPushMatrix();
            if (FluidRenderer.getFluidTexture(fluidStack, false) != null) {
                float cap = tank.getCapacity();
                float level = Math.min((float)fluidStack.amount, cap) / cap;
                this.func_147499_a(FluidRenderer.getFluidSheet(fluidStack));
                FluidRenderer.setColorForFluidStack(fluidStack);
                GL11.glCallList((int)displayLists[(int)(level * 99.0f)]);
            }
            GL11.glPopMatrix();
        }
        GL11.glPopAttrib();
        GL11.glPopMatrix();
        if (tile.getClass() == TileLiquidLoader.class) {
            TileLiquidLoader loader = (TileLiquidLoader)tile;
            RenderLiquidLoader.pipe.minY = 0.0625f - loader.getPipeLenght();
            RenderFakeBlock.renderBlock(pipe, (IBlockAccess)loader.getWorld(), x, y, z, false, true);
        }
    }
}

