/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.render;

import java.util.Arrays;
import mods.railcraft.common.blocks.aesthetics.cube.BlockCube;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.init.Blocks;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.opengl.GL11;

public class RenderFakeBlock {
    private static RenderBlocks renderBlocks = new RenderBlocks();

    public static void renderBlockForEntity(RenderInfo info, IBlockAccess blockAccess, int i, int j, int k, boolean doLight, boolean doTessellating) {
        RenderFakeBlock.renderBlock(info, blockAccess, -0.5, -0.5, -0.5, i, j, k, doLight, doTessellating);
    }

    public static void renderAsBlock(RenderInfo info, RenderBlocks renderBlocks, IBlockAccess blockAccess, double x, double y, double z) {
        BlockCube block = BlockCube.getBlock();
        if (block != null) {
            block.setTextureOveride(info);
            renderBlocks.func_147782_a((double)info.minX, (double)info.minY, (double)info.minZ, (double)info.maxX, (double)info.maxY, (double)info.maxZ);
            renderBlocks.func_147784_q((Block)block, (int)x, (int)y, (int)z);
            block.setTextureOveride(null);
        } else {
            RenderFakeBlock.renderBlock(info, blockAccess, x, y, z, true, false);
        }
    }

    public static void renderBlock(RenderInfo info, IBlockAccess blockAccess, double x, double y, double z, boolean doLight, boolean doTessellating) {
        RenderFakeBlock.renderBlock(info, blockAccess, x, y, z, (int)x, (int)y, (int)z, doLight, doTessellating);
    }

    public static void renderBlock(RenderInfo info, IBlockAccess blockAccess, double x, double y, double z, int lightX, int lightY, int lightZ, boolean doLight, boolean doTessellating) {
        float lightBottom = 0.5f;
        float lightTop = 1.0f;
        float lightEastWest = 0.8f;
        float lightNorthSouth = 0.6f;
        Tessellator tessellator = Tessellator.field_78398_a;
        if (blockAccess == null) {
            doLight = false;
        }
        if (doTessellating) {
            tessellator.func_78382_b();
        }
        float light = 0.0f;
        if (doLight) {
            light = info.light < 0.0f ? 1.0f : info.light;
            int brightness = 0;
            brightness = info.brightness < 0 ? info.template.func_149677_c(blockAccess, lightX, lightY, lightZ) : info.brightness;
            tessellator.func_78380_c(brightness);
            tessellator.func_78386_a(lightBottom * light, lightBottom * light, lightBottom * light);
        } else {
            tessellator.func_78386_a(1.0f, 1.0f, 1.0f);
            if (info.brightness >= 0) {
                tessellator.func_78380_c(info.brightness);
            }
        }
        renderBlocks.func_147782_a((double)info.minX, (double)info.minY, (double)info.minZ, (double)info.maxX, (double)info.maxY, (double)info.maxZ);
        if (info.renderSide[0]) {
            renderBlocks.func_147768_a(info.template, x, y, z, info.getBlockTextureFromSide(0));
        }
        if (doLight) {
            tessellator.func_78386_a(lightTop * light, lightTop * light, lightTop * light);
        }
        if (info.renderSide[1]) {
            renderBlocks.func_147806_b(info.template, x, y, z, info.getBlockTextureFromSide(1));
        }
        if (doLight) {
            tessellator.func_78386_a(lightEastWest * light, lightEastWest * light, lightEastWest * light);
        }
        if (info.renderSide[2]) {
            renderBlocks.func_147761_c(info.template, x, y, z, info.getBlockTextureFromSide(2));
        }
        if (doLight) {
            tessellator.func_78386_a(lightEastWest * light, lightEastWest * light, lightEastWest * light);
        }
        if (info.renderSide[3]) {
            renderBlocks.func_147734_d(info.template, x, y, z, info.getBlockTextureFromSide(3));
        }
        if (doLight) {
            tessellator.func_78386_a(lightNorthSouth * light, lightNorthSouth * light, lightNorthSouth * light);
        }
        if (info.renderSide[4]) {
            renderBlocks.func_147798_e(info.template, x, y, z, info.getBlockTextureFromSide(4));
        }
        if (doLight) {
            tessellator.func_78386_a(lightNorthSouth * light, lightNorthSouth * light, lightNorthSouth * light);
        }
        if (info.renderSide[5]) {
            renderBlocks.func_147764_f(info.template, x, y, z, info.getBlockTextureFromSide(5));
        }
        if (doTessellating) {
            tessellator.func_78381_a();
        }
    }

    public static void renderBlockOnInventory(RenderBlocks renderblocks, RenderInfo info, float light) {
        RenderFakeBlock.renderBlockOnInventory(renderblocks, info, light, -1);
    }

    public static void renderBlockOnInventory(RenderBlocks renderer, RenderInfo info, float light, int side) {
        if (side >= 0) {
            info.setRenderSingleSide(side);
        }
        Block block = info.template;
        Tessellator tessellator = Tessellator.field_78398_a;
        if (renderer.field_147844_c) {
            int j = block.func_149741_i(9);
            float red = (float)(j >> 16 & 0xFF) / 255.0f;
            float green = (float)(j >> 8 & 0xFF) / 255.0f;
            float blue = (float)(j & 0xFF) / 255.0f;
            GL11.glColor4f((float)(red * light), (float)(green * light), (float)(blue * light), (float)1.0f);
        }
        renderer.func_147782_a((double)info.minX, (double)info.minY, (double)info.minZ, (double)info.maxX, (double)info.maxY, (double)info.maxZ);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        int s = 0;
        if (info.renderSide[s]) {
            tessellator.func_78382_b();
            tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
            IIcon icon = info.getBlockTextureFromSide(s);
            if (icon != null) {
                renderer.func_147768_a(block, 0.0, 0.0, 0.0, icon);
            }
            tessellator.func_78381_a();
        }
        if (info.renderSide[s = 1]) {
            tessellator.func_78382_b();
            tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
            IIcon icon = info.getBlockTextureFromSide(s);
            if (icon != null) {
                renderer.func_147806_b(block, 0.0, 0.0, 0.0, icon);
            }
            tessellator.func_78381_a();
        }
        if (info.renderSide[s = 2]) {
            tessellator.func_78382_b();
            tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
            IIcon icon = info.getBlockTextureFromSide(s);
            if (icon != null) {
                renderer.func_147761_c(block, 0.0, 0.0, 0.0, icon);
            }
            tessellator.func_78381_a();
        }
        if (info.renderSide[s = 3]) {
            tessellator.func_78382_b();
            tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
            IIcon icon = info.getBlockTextureFromSide(s);
            if (icon != null) {
                renderer.func_147734_d(block, 0.0, 0.0, 0.0, icon);
            }
            tessellator.func_78381_a();
        }
        if (info.renderSide[s = 4]) {
            tessellator.func_78382_b();
            tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
            IIcon icon = info.getBlockTextureFromSide(s);
            if (icon != null) {
                renderer.func_147798_e(block, 0.0, 0.0, 0.0, icon);
            }
            tessellator.func_78381_a();
        }
        if (info.renderSide[s = 5]) {
            tessellator.func_78382_b();
            tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
            IIcon icon = info.getBlockTextureFromSide(s);
            if (icon != null) {
                renderer.func_147764_f(block, 0.0, 0.0, 0.0, icon);
            }
            tessellator.func_78381_a();
        }
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        if (side >= 0) {
            info.setRenderAllSides();
        }
    }

    public static class RenderInfo {
        public Block template = Blocks.field_150348_b;
        public IIcon[] texture = null;
        public IIcon override = null;
        public float minX = 0.0f;
        public float minY = 0.0f;
        public float minZ = 0.0f;
        public float maxX = 1.0f;
        public float maxY = 1.0f;
        public float maxZ = 1.0f;
        public boolean[] renderSide = new boolean[6];
        public float light = -1.0f;
        public int brightness = -1;

        public RenderInfo() {
            this.setRenderAllSides();
        }

        public RenderInfo(Block template, IIcon[] texture) {
            this();
            this.template = template;
            this.texture = texture;
        }

        public RenderInfo(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
            this();
            this.setBlockBounds(minX, minY, minZ, maxX, maxY, maxZ);
        }

        public final void setBlockBounds(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
            this.minX = minX;
            this.minY = minY;
            this.minZ = minZ;
            this.maxX = maxX;
            this.maxY = maxY;
            this.maxZ = maxZ;
        }

        public final void setRenderSingleSide(int side) {
            Arrays.fill(this.renderSide, false);
            this.renderSide[side] = true;
        }

        public final void setRenderAllSides() {
            Arrays.fill(this.renderSide, true);
        }

        public void rotate() {
            float temp = this.minX;
            this.minX = this.minZ;
            this.minZ = temp;
            temp = this.maxX;
            this.maxX = this.maxZ;
            this.maxZ = temp;
        }

        public void reverseX() {
            float temp = this.minX;
            this.minX = 1.0f - this.maxX;
            this.maxX = 1.0f - temp;
        }

        public void reverseZ() {
            float temp = this.minZ;
            this.minZ = 1.0f - this.maxZ;
            this.maxZ = 1.0f - temp;
        }

        public IIcon getBlockTextureFromSide(int i) {
            if (this.override != null) {
                return this.override;
            }
            if (this.texture == null || this.texture.length == 0) {
                return this.template.func_149733_h(i);
            }
            if (i >= this.texture.length) {
                i = 0;
            }
            return this.texture[i];
        }
    }
}

