/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.gui;

import mods.railcraft.client.gui.GuiTools;
import mods.railcraft.client.gui.TileGui;
import mods.railcraft.client.gui.buttons.GuiMultiButton;
import mods.railcraft.common.blocks.RailcraftTileEntity;
import mods.railcraft.common.blocks.signals.IRouter;
import mods.railcraft.common.blocks.signals.RoutingLogic;
import mods.railcraft.common.core.RailcraftLanguage;
import mods.railcraft.common.gui.buttons.LockButtonState;
import mods.railcraft.common.gui.containers.ContainerRouting;
import mods.railcraft.common.gui.tooltips.ToolTip;
import mods.railcraft.common.util.network.IGuiReturnHandler;
import mods.railcraft.common.util.network.PacketBuilder;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.StatCollector;

public class GuiRouting
extends TileGui {
    private final IRouter router;
    private GuiMultiButton lockButton;
    private GuiMultiButton routingButton;
    private final EntityPlayer player;
    private final RailcraftTileEntity tile;
    private ToolTip lockedToolTips;
    private ToolTip unlockedToolTips;
    private ToolTip notownedToolTips;
    private ToolTip privateToolTips;
    private ToolTip publicToolTips;
    private String owner = "[Unknown]";

    public GuiRouting(InventoryPlayer inv, RailcraftTileEntity tile, IRouter router) {
        super(tile, new ContainerRouting(inv, router), "railcraft:textures/gui/gui_routing.png");
        this.field_147000_g = 160;
        this.tile = tile;
        this.router = router;
        this.player = inv.field_70458_d;
        this.lockedToolTips = ToolTip.buildToolTip("gui.tip.button.lock.locked", "{owner}=" + this.owner);
        this.unlockedToolTips = ToolTip.buildToolTip("gui.tip.button.lock.unlocked", "{owner}=" + this.owner);
        this.notownedToolTips = ToolTip.buildToolTip("gui.tip.button.lock.notowner", "{owner}=" + this.owner);
        this.privateToolTips = ToolTip.buildToolTip("routing.type.private.tip", "{owner}=" + this.owner);
        this.publicToolTips = ToolTip.buildToolTip("routing.type.public.tip", new String[0]);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        if (this.router == null) {
            return;
        }
        this.field_146292_n.clear();
        int w = (this.field_146294_l - this.field_146999_f) / 2;
        int h = (this.field_146295_m - this.field_147000_g) / 2;
        this.lockButton = new GuiMultiButton(8, w + 152, h + 8, 16, this.router.getLockController());
        this.field_146292_n.add(this.lockButton);
        this.lockButton.field_146124_l = ((ContainerRouting)this.container).canLock;
        this.routingButton = new GuiMultiButton(8, w + 65, h + 50, 100, this.router.getRoutingController());
        this.field_146292_n.add(this.routingButton);
        this.routingButton.canChange = false;
    }

    protected void func_146284_a(GuiButton guibutton) {
        if (this.router == null) {
            return;
        }
        this.updateButtons();
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.updateButtons();
        ContainerRouting con = (ContainerRouting)this.container;
        RoutingLogic logic = this.router.getLogic();
        con.errorElement.hidden = logic == null || logic.isValid();
    }

    private void updateButtons() {
        this.lockButton.field_146124_l = ((ContainerRouting)this.container).canLock;
        this.routingButton.canChange = !this.router.isSecure() || ((ContainerRouting)this.container).canLock;
        String o = ((ContainerRouting)this.container).owner;
        if (!this.owner.equals(o)) {
            this.owner = o;
            this.lockedToolTips = ToolTip.buildToolTip("gui.tip.button.lock.locked", "{owner}=" + this.owner);
            this.unlockedToolTips = ToolTip.buildToolTip("gui.tip.button.lock.unlocked", "{owner}=" + this.owner);
            this.notownedToolTips = ToolTip.buildToolTip("gui.tip.button.lock.notowner", "{owner}=" + this.owner);
            this.privateToolTips = ToolTip.buildToolTip("routing.type.private.tip", "{owner}=" + this.owner);
        }
        this.lockButton.setToolTip(this.router.getLockController().getButtonState() == LockButtonState.LOCKED ? this.lockedToolTips : (this.lockButton.field_146124_l ? this.unlockedToolTips : this.notownedToolTips));
        this.routingButton.setToolTip(this.router.getRoutingController().getButtonState() == IRouter.RoutingButtonState.PRIVATE ? this.privateToolTips : this.publicToolTips);
    }

    public void func_146281_b() {
        this.sendUpdatePacket();
    }

    private void sendUpdatePacket() {
        PacketBuilder.instance().sendGuiReturnPacket((IGuiReturnHandler)((Object)this.tile));
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        GuiTools.drawCenteredString(this.field_146289_q, this.router.getName(), 6);
        this.field_146289_q.func_78276_b(RailcraftLanguage.translate("routing.slot.label"), 64, 29, 0x404040);
        this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)"container.inventory"), 8, this.field_147000_g - 96 + 2, 0x404040);
    }
}

