/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.gui;

import java.util.ArrayList;
import mods.railcraft.client.gui.EntityGui;
import mods.railcraft.client.gui.GuiTools;
import mods.railcraft.client.gui.buttons.GuiMultiButton;
import mods.railcraft.client.gui.buttons.GuiToggleButtonSmall;
import mods.railcraft.common.carts.EntityLocomotive;
import mods.railcraft.common.carts.EntityLocomotiveSteamSolid;
import mods.railcraft.common.core.RailcraftLanguage;
import mods.railcraft.common.gui.containers.ContainerLocomotiveSteamSolid;
import mods.railcraft.common.gui.tooltips.ToolTip;
import mods.railcraft.common.util.network.PacketBuilder;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.StatCollector;

public class GuiLocomotiveSteamSolid
extends EntityGui {
    private final EntityLocomotiveSteamSolid loco;
    private GuiToggleButtonSmall running;
    private GuiToggleButtonSmall idle;
    private GuiToggleButtonSmall shutdown;
    private GuiToggleButtonSmall reverse;
    private GuiToggleButtonSmall slowest;
    private GuiToggleButtonSmall slower;
    private GuiToggleButtonSmall slow;
    private GuiToggleButtonSmall max;
    private GuiMultiButton lockButton;
    private final EntityPlayer player;
    private ToolTip lockedToolTips;
    private ToolTip unlockedToolTips;
    private String locoOwner = "[Unknown]";

    public GuiLocomotiveSteamSolid(InventoryPlayer inv, EntityLocomotiveSteamSolid loco) {
        super((Entity)loco, new ContainerLocomotiveSteamSolid(inv, loco), "railcraft:textures/gui/gui_locomotive_steam.png");
        this.field_147000_g = 205;
        this.loco = loco;
        this.player = inv.field_70458_d;
        loco.clientMode = loco.getMode();
        loco.clientSpeed = loco.getSpeed();
        this.lockedToolTips = ToolTip.buildToolTip("gui.locomotive.tip.button.locked", "{owner}=" + this.locoOwner);
        this.unlockedToolTips = ToolTip.buildToolTip("gui.locomotive.tip.button.unlocked", "{owner}=" + this.locoOwner);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        if (this.loco == null) {
            return;
        }
        this.field_146292_n.clear();
        int w = (this.field_146294_l - this.field_146999_f) / 2;
        int h = (this.field_146295_m - this.field_147000_g) / 2;
        ArrayList<GuiToggleButtonSmall> buttons = new ArrayList<GuiToggleButtonSmall>();
        this.running = new GuiToggleButtonSmall(0, 0, h + 76, 55, RailcraftLanguage.translate("gui.locomotive.mode.running"), this.loco.clientMode == EntityLocomotive.LocoMode.RUNNING);
        buttons.add(this.running);
        this.idle = new GuiToggleButtonSmall(1, 0, h + 76, 45, RailcraftLanguage.translate("gui.locomotive.mode.idle"), this.loco.clientMode == EntityLocomotive.LocoMode.IDLE);
        buttons.add(this.idle);
        this.shutdown = new GuiToggleButtonSmall(2, 0, h + 76, 55, RailcraftLanguage.translate("gui.locomotive.mode.shutdown"), this.loco.clientMode == EntityLocomotive.LocoMode.SHUTDOWN);
        buttons.add(this.shutdown);
        this.running.setToolTip(ToolTip.buildToolTip("gui.locomotive.tip.button.running", new String[0]));
        this.idle.setToolTip(ToolTip.buildToolTip("gui.locomotive.tip.button.idle", new String[0]));
        this.shutdown.setToolTip(ToolTip.buildToolTip("gui.locomotive.tip.button.shutdown", new String[0]));
        GuiTools.newButtonRowAuto(this.field_146292_n, w + 3, 171, buttons);
        ArrayList<GuiToggleButtonSmall> speedButtons = new ArrayList<GuiToggleButtonSmall>();
        this.reverse = new GuiToggleButtonSmall(3, 0, h + 93, 12, "<", this.loco.clientSpeed == EntityLocomotive.LocoSpeed.REVERSE);
        speedButtons.add(this.reverse);
        this.slowest = new GuiToggleButtonSmall(4, 0, h + 93, 12, ">", this.loco.clientSpeed == EntityLocomotive.LocoSpeed.SLOWEST);
        speedButtons.add(this.slowest);
        this.slower = new GuiToggleButtonSmall(5, 0, h + 93, 17, ">>", this.loco.clientSpeed == EntityLocomotive.LocoSpeed.SLOWER);
        speedButtons.add(this.slower);
        this.slow = new GuiToggleButtonSmall(6, 0, h + 93, 22, ">>>", this.loco.clientSpeed == EntityLocomotive.LocoSpeed.SLOW);
        speedButtons.add(this.slow);
        this.max = new GuiToggleButtonSmall(7, 0, h + 93, 27, ">>>>", this.loco.clientSpeed == EntityLocomotive.LocoSpeed.MAX);
        speedButtons.add(this.max);
        GuiTools.newButtonRow(this.field_146292_n, w + 8, 3, speedButtons);
        this.lockButton = new GuiMultiButton(8, w + 152, h + 94, 16, this.loco.getLockController());
        this.field_146292_n.add(this.lockButton);
        this.lockButton.field_146124_l = this.loco.clientCanLock;
    }

    protected void func_146284_a(GuiButton guibutton) {
        if (this.loco == null) {
            return;
        }
        switch (guibutton.field_146127_k) {
            case 0: {
                this.loco.clientMode = EntityLocomotive.LocoMode.RUNNING;
                break;
            }
            case 1: {
                this.loco.clientMode = EntityLocomotive.LocoMode.IDLE;
                break;
            }
            case 2: {
                this.loco.clientMode = EntityLocomotive.LocoMode.SHUTDOWN;
                break;
            }
            case 3: {
                this.loco.clientSpeed = EntityLocomotive.LocoSpeed.REVERSE;
                break;
            }
            case 4: {
                this.loco.clientSpeed = EntityLocomotive.LocoSpeed.SLOWEST;
                break;
            }
            case 5: {
                this.loco.clientSpeed = EntityLocomotive.LocoSpeed.SLOWER;
                break;
            }
            case 6: {
                this.loco.clientSpeed = EntityLocomotive.LocoSpeed.SLOW;
                break;
            }
            case 7: {
                this.loco.clientSpeed = EntityLocomotive.LocoSpeed.MAX;
            }
        }
        this.updateButtons();
        this.sendUpdatePacket();
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.updateButtons();
    }

    private void updateButtons() {
        this.lockButton.field_146124_l = this.loco.clientCanLock;
        this.lockButton.setToolTip(this.loco.isSecure() ? this.lockedToolTips : (this.lockButton.field_146124_l ? this.unlockedToolTips : null));
        String owner = ((ContainerLocomotiveSteamSolid)this.container).owner;
        if (!owner.equals(this.locoOwner)) {
            this.locoOwner = owner;
            this.lockedToolTips = ToolTip.buildToolTip("gui.locomotive.tip.button.locked", "{owner}=" + this.locoOwner);
            this.unlockedToolTips = ToolTip.buildToolTip("gui.locomotive.tip.button.unlocked", "{owner}=" + this.locoOwner);
        }
        this.running.active = this.loco.clientMode == EntityLocomotive.LocoMode.RUNNING;
        this.idle.active = this.loco.clientMode == EntityLocomotive.LocoMode.IDLE;
        this.shutdown.active = this.loco.clientMode == EntityLocomotive.LocoMode.SHUTDOWN;
        this.reverse.active = this.loco.clientSpeed == EntityLocomotive.LocoSpeed.REVERSE;
        this.slowest.active = this.loco.clientSpeed == EntityLocomotive.LocoSpeed.SLOWEST;
        this.slower.active = this.loco.clientSpeed == EntityLocomotive.LocoSpeed.SLOWER;
        this.slow.active = this.loco.clientSpeed == EntityLocomotive.LocoSpeed.SLOW;
        this.max.active = this.loco.clientSpeed == EntityLocomotive.LocoSpeed.MAX;
    }

    public void func_146281_b() {
        this.sendUpdatePacket();
    }

    private void sendUpdatePacket() {
        PacketBuilder.instance().sendGuiReturnPacket(this.loco);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        String name = this.loco.func_145818_k_() ? this.loco.func_95999_t() : this.loco.func_145825_b();
        GuiTools.drawCenteredString(this.field_146289_q, name, 6);
        this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)"container.inventory"), 8, this.field_147000_g - 96 + 2, 0x404040);
    }

    @Override
    protected void func_146976_a(float par1, int par2, int par3) {
        super.func_146976_a(par1, par3, par3);
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        if (this.loco.boiler.hasFuel()) {
            int scale = this.loco.boiler.getBurnProgressScaled(12);
            this.func_73729_b(x + 62, y + 34 - scale, 176, 59 - scale, 14, scale + 2);
        }
    }
}

