/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.gui;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.client.gui.GuiTools;
import mods.railcraft.client.gui.TileGui;
import mods.railcraft.client.gui.buttons.GuiBetterButton;
import mods.railcraft.client.gui.buttons.GuiButtonSmall;
import mods.railcraft.common.blocks.machine.alpha.TileEngravingBench;
import mods.railcraft.common.core.RailcraftLanguage;
import mods.railcraft.common.gui.buttons.StandardButtonTextureSets;
import mods.railcraft.common.gui.containers.ContainerEngravingBench;
import mods.railcraft.common.util.network.PacketBuilder;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.StatCollector;

public class GuiEngravingBench
extends TileGui {
    private final TileEngravingBench tile;
    private final EntityPlayer player;

    public GuiEngravingBench(InventoryPlayer inventoryplayer, TileEngravingBench tile) {
        super(tile, new ContainerEngravingBench(inventoryplayer, tile), "railcraft:textures/gui/gui_engraving.png");
        this.tile = tile;
        this.player = inventoryplayer.field_70458_d;
        this.field_147000_g = 215;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        int w = (this.field_146294_l - this.field_146999_f) / 2;
        int h = (this.field_146295_m - this.field_147000_g) / 2;
        this.field_146292_n.add(new GuiBetterButton(0, w + 12, h + 26, 10, StandardButtonTextureSets.LEFT_BUTTON, ""));
        this.field_146292_n.add(new GuiBetterButton(1, w + 154, h + 26, 10, StandardButtonTextureSets.RIGHT_BUTTON, ""));
        this.field_146292_n.add(new GuiButtonSmall(2, w + 61, h + 60, 54, RailcraftLanguage.translate("gui.engrave")));
        this.field_146292_n.add(new GuiButtonSmall(3, w + 35, h + 100, 106, RailcraftLanguage.translate("gui.engrave.openunlock")));
    }

    protected void func_146284_a(GuiButton button) {
        super.func_146284_a(button);
        TileEngravingBench.GuiPacketType packetType = TileEngravingBench.GuiPacketType.NORMAL_RETURN;
        if (button.field_146127_k == 0) {
            ((ContainerEngravingBench)this.container).emblemBank.shiftLeft();
        }
        if (button.field_146127_k == 1) {
            ((ContainerEngravingBench)this.container).emblemBank.shiftRight();
        }
        if (button.field_146127_k == 2) {
            packetType = TileEngravingBench.GuiPacketType.START_CRAFTING;
        }
        if (button.field_146127_k == 3) {
            packetType = TileEngravingBench.GuiPacketType.OPEN_UNLOCK;
        }
        this.sendUpdateToTile(packetType);
    }

    public void sendUpdateToTile(TileEngravingBench.GuiPacketType type) {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        DataOutputStream data = new DataOutputStream(bytes);
        try {
            data.writeByte(type.ordinal());
            switch (type) {
                case NORMAL_RETURN: 
                case START_CRAFTING: {
                    data.writeUTF(((ContainerEngravingBench)this.container).emblemBank.getSelectedEmblem());
                }
            }
        }
        catch (IOException ex) {
            // empty catch block
        }
        PacketBuilder.instance().sendGuiReturnPacket(this.tile, bytes.toByteArray());
    }

    public void func_146281_b() {
        super.func_146281_b();
        this.sendUpdateToTile(TileEngravingBench.GuiPacketType.NORMAL_RETURN);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        GuiTools.drawCenteredString(this.field_146289_q, this.tile.getName(), 6);
        this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)"container.inventory"), 8, this.field_147000_g - 96 + 2, 0x404040);
    }

    @Override
    protected void func_146976_a(float f, int i, int j) {
        super.func_146976_a(f, i, j);
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        if (this.tile.getProgress() > 0) {
            int progress = this.tile.getProgressScaled(23);
            this.func_73729_b(x + 76, y + 76, 176, 0, progress + 1, 12);
        }
    }
}

