/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.emblems;

import java.awt.image.BufferedImage;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import javax.imageio.ImageIO;
import mods.railcraft.client.emblems.EmblemPackageManager;
import mods.railcraft.client.emblems.Texture;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.Level;

public class EmblemTexture
extends Texture {
    private final String identifier;
    private boolean cachedImage = false;
    private boolean triedDownloading;
    private final ResourceLocation location;

    public EmblemTexture(String ident) {
        this.identifier = ident;
        this.location = new ResourceLocation("railcraft:textures/emblems/" + this.identifier);
    }

    public void func_110551_a(IResourceManager resourceManager) throws IOException {
        if (this.imageData == null && !this.loadEmblemTexture() && !this.triedDownloading) {
            this.triedDownloading = true;
            Game.log(Level.INFO, "Attempting to download Emblem - \"emblem-{0}\"", this.identifier);
            EmblemDownloader downloader = new EmblemDownloader();
            downloader.setDaemon(true);
            downloader.setName("Emblem downloader: " + this.identifier);
            downloader.start();
        }
    }

    private boolean loadEmblemTexture() throws IOException {
        EmblemPackageManager.Emblem emblem = EmblemPackageManager.getEmblem(this.identifier);
        if (emblem == null) {
            return false;
        }
        InputStream istream = EmblemPackageManager.class.getResourceAsStream(emblem.textureFile);
        if (istream == null) {
            return false;
        }
        this.imageData = ImageIO.read(istream);
        istream.close();
        return true;
    }

    public int func_110552_b() {
        int textureIndex = super.func_110552_b();
        if (!this.cachedImage && this.imageData != null) {
            TextureUtil.func_110987_a((int)textureIndex, (BufferedImage)this.imageData);
            this.cachedImage = true;
        }
        if (this.imageData == null) {
            return EmblemPackageManager.blankEmblem.func_110552_b();
        }
        return textureIndex;
    }

    @Override
    public BufferedImage getImage() {
        if (this.imageData == null) {
            return EmblemPackageManager.blankEmblem.getImage();
        }
        return this.imageData;
    }

    public ResourceLocation getLocation() {
        return this.location;
    }

    public String toString() {
        return String.format("Emblem Texture - %s - Location: %s", this.identifier, this.location);
    }

    private class EmblemDownloader
    extends Thread {
        private EmblemDownloader() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            FileOutputStream fos = null;
            try {
                URL url = new URL("https://dl.dropboxusercontent.com/u/38558957/Minecraft/Railcraft/Emblems/emblem-" + EmblemTexture.this.identifier + ".jar");
                ReadableByteChannel rbc = Channels.newChannel(url.openStream());
                fos = new FileOutputStream(EmblemPackageManager.getEmblemFile(EmblemTexture.this.identifier));
                fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
                EmblemPackageManager.loadEmblem(EmblemTexture.this.identifier);
                EmblemTexture.this.loadEmblemTexture();
            }
            catch (Exception ex) {
                Game.log(Level.WARN, "Failed to download Emblem: \"emblem-{0}\". Reason: {1}", EmblemTexture.this.identifier, ex);
            }
            finally {
                try {
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }
}

