/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.emblems;

import cpw.mods.fml.common.CertificateHelper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import mods.railcraft.client.emblems.BlankTexture;
import mods.railcraft.client.emblems.EmblemTexture;
import mods.railcraft.client.emblems.Texture;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.item.EnumRarity;
import net.minecraft.launchwrapper.LaunchClassLoader;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.Level;

public class EmblemPackageManager {
    private static final Map<String, Emblem> loadedEmblems = new HashMap<String, Emblem>();
    private static final Map<String, EmblemTexture> emblemTextures = new HashMap<String, EmblemTexture>();
    public static final Texture blankEmblem = new BlankTexture();

    public static EmblemTexture getEmblemTexture(String identifier) {
        EmblemTexture texture = emblemTextures.get(identifier);
        if (texture == null) {
            texture = new EmblemTexture(identifier);
            emblemTextures.put(identifier, texture);
            Minecraft.func_71410_x().field_71446_o.func_110579_a(texture.getLocation(), (ITextureObject)texture);
        }
        return texture;
    }

    public static Emblem getEmblem(String identifier) {
        return loadedEmblems.get(identifier);
    }

    public static Emblem getEmblemOrLoad(String identifier) {
        Emblem emblem = loadedEmblems.get(identifier);
        if (emblem != null) {
            return emblem;
        }
        EmblemPackageManager.getEmblemTexture(identifier);
        return null;
    }

    public static void loadEmblems() {
        File emblems = new File(Minecraft.func_71410_x().field_71412_D, "mods/railcraft/emblems");
        if (!emblems.exists()) {
            emblems.mkdirs();
        }
        if (!emblems.isDirectory()) {
            return;
        }
        for (File file : emblems.listFiles()) {
            if (!file.getName().endsWith(".jar")) continue;
            String identifier = file.getName().replace(".jar", "").replace("emblem-", "");
            EmblemPackageManager.loadEmblem(file, identifier);
        }
    }

    public static File getEmblemFile(String identifier) {
        File emblems = new File(Minecraft.func_71410_x().field_71412_D, "mods/railcraft/emblems");
        if (!emblems.exists()) {
            emblems.mkdirs();
        }
        File emblem = new File(emblems, "emblem-" + identifier + ".jar");
        return emblem;
    }

    public static Emblem loadEmblem(String identifier) {
        return EmblemPackageManager.loadEmblem(EmblemPackageManager.getEmblemFile(identifier), identifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Emblem loadEmblem(File file, String identifier) {
        JarFile jar = null;
        try {
            if (file == null) {
                throw new IOException("Cannot find file.");
            }
            jar = new JarFile(file);
            Manifest man = jar.getManifest();
            if (man == null) {
                throw new SecurityException("Emblem Jar is not signed!");
            }
            ArrayList<JarEntry> jarEntries = new ArrayList<JarEntry>();
            byte[] buffer = new byte[8192];
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                jarEntries.add(entry);
                InputStream is = jar.getInputStream(entry);
                while (is.read(buffer, 0, buffer.length) != -1) {
                }
                is.close();
            }
            for (JarEntry entry : jarEntries) {
                if (entry.isDirectory()) continue;
                if (entry.getName().endsWith(".class")) {
                    throw new SecurityException("Emblem Jars should not have code!");
                }
                Certificate[] certs = entry.getCertificates();
                if (!(certs == null || certs.length == 0 ? !entry.getName().startsWith("META-INF") : !CertificateHelper.getFingerprint((Certificate)certs[0]).equals("a0c255ac501b2749537d5824bb0f0588bf0320fa"))) continue;
                throw new SecurityException("Emblem Jar is not signed!");
            }
            LaunchClassLoader classLoader = (LaunchClassLoader)EmblemPackageManager.class.getClassLoader();
            classLoader.addURL(file.toURI().toURL());
            for (JarEntry entry : jarEntries) {
                if (entry.isDirectory() || !entry.getName().endsWith(".meta")) continue;
                Properties emblemData = new Properties();
                InputStream iStream = jar.getInputStream(entry);
                try {
                    emblemData.load(iStream);
                }
                finally {
                    iStream.close();
                }
                int rarity = 0;
                try {
                    rarity = Integer.parseInt(emblemData.getProperty("rarity"));
                    EnumRarity[] rarities = EnumRarity.values();
                    if (rarity >= rarities.length) {
                        rarity = rarities.length - 1;
                    }
                }
                catch (NumberFormatException numEx) {
                    // empty catch block
                }
                boolean hasEffect = Boolean.parseBoolean(emblemData.getProperty("effect"));
                String texturePath = EmblemPackageManager.parseTexturePath(emblemData.getProperty("texture"), identifier);
                Emblem emblem = new Emblem(identifier, texturePath, emblemData.getProperty("name"), rarity, hasEffect);
                loadedEmblems.put(emblem.identifier, emblem);
                Game.log(Level.INFO, "Loaded Emblem - \"{0}\"", emblem.displayName);
                Emblem emblem2 = emblem;
                return emblem2;
            }
        }
        catch (IOException ex) {
            Game.log(Level.WARN, "Failed to load Emblem due to IO exception - \"{0}\"", file.getName().replace(".jar", ""));
            Game.log(Level.WARN, "Reason: {0}", ex);
            Emblem emblem = null;
            return emblem;
        }
        catch (SecurityException ex) {
            Game.log(Level.WARN, "Failed to load Emblem due to security failure - \"{0}\"", file.getName().replace(".jar", ""));
            Game.log(Level.WARN, "Reason: {0}", ex);
            Emblem emblem = null;
            return emblem;
        }
        finally {
            try {
                if (jar != null) {
                    jar.close();
                }
            }
            catch (IOException ex) {}
        }
        return null;
    }

    private static String parseTexturePath(String path, String idenifier) {
        path = path.replace("%emblem%", "/assets/railcraft/textures/emblems/" + idenifier);
        path = path.replace("%minecraft_block%", "/assets/minecraft/textures/blocks");
        path = path.replace("%minecraft_item%", "/assets/minecraft/textures/items");
        path = path.replace("%railcraft_item%", "/assets/railcraft/textures/items");
        return path;
    }

    static {
        ResourceLocation location = new ResourceLocation("railcraft:textures/emblems/blank");
        Minecraft.func_71410_x().field_71446_o.func_110579_a(location, (ITextureObject)blankEmblem);
    }

    public static class Emblem {
        public final String textureFile;
        public final String identifier;
        public final String displayName;
        public final int rarity;
        public final boolean hasEffect;

        public Emblem(String ident, String text, String display, int rarity, boolean hasEffect) {
            this.identifier = ident;
            this.textureFile = text;
            this.displayName = display;
            this.rarity = rarity;
            this.hasEffect = hasEffect;
        }

        public String toString() {
            return String.format("Emblem - \"%s\" - %s", this.displayName, this.identifier);
        }
    }
}

