/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.api.tracks;

import java.util.List;
import java.util.Locale;
import mods.railcraft.api.tracks.ITrackInstance;
import mods.railcraft.api.tracks.ITrackItemIconProvider;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;

public final class TrackSpec {
    public static Block blockTrack;
    private final String tag;
    private final short trackId;
    private final List<String> tooltip;
    private final ITrackItemIconProvider iconProvider;
    private final Class<? extends ITrackInstance> instanceClass;

    public TrackSpec(short trackId, String tag, ITrackItemIconProvider iconProvider, Class<? extends ITrackInstance> instanceClass) {
        this(trackId, tag, iconProvider, instanceClass, null);
    }

    public TrackSpec(short trackId, String tag, ITrackItemIconProvider iconProvider, Class<? extends ITrackInstance> instanceClass, List<String> tooltip) {
        this.trackId = trackId;
        this.tag = tag.toLowerCase(Locale.ENGLISH);
        this.iconProvider = iconProvider;
        this.instanceClass = instanceClass;
        this.tooltip = tooltip;
    }

    public String getTrackTag() {
        return this.tag;
    }

    public short getTrackId() {
        return this.trackId;
    }

    public ItemStack getItem() {
        return this.getItem(1);
    }

    public ItemStack getItem(int qty) {
        if (blockTrack != null) {
            ItemStack stack = new ItemStack(blockTrack, qty);
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74778_a("track", this.tag);
            stack.func_77982_d(nbt);
            return stack;
        }
        return null;
    }

    public ITrackInstance createInstanceFromSpec() {
        try {
            return this.instanceClass.newInstance();
        }
        catch (Exception ex) {
            throw new RuntimeException("Improper Track Instance Constructor", ex);
        }
    }

    public IIcon getItemIcon() {
        if (this.iconProvider == null) {
            return Blocks.field_150448_aq.func_149691_a(0, 0);
        }
        return this.iconProvider.getTrackItemIcon(this);
    }

    public List<String> getItemToolTip() {
        return this.tooltip;
    }

    public String toString() {
        return "Track -> " + this.getTrackTag();
    }
}

