/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.api.tracks;

import mods.railcraft.api.core.items.ITrackItem;
import mods.railcraft.api.tracks.ITrackInstance;
import mods.railcraft.api.tracks.ITrackLockdown;
import mods.railcraft.api.tracks.ITrackTile;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRailBase;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public abstract class RailTools {
    public static boolean placeRailAt(ItemStack stack, World world, int i, int j, int k) {
        Block block;
        if (stack == null) {
            return false;
        }
        if (stack.func_77973_b() instanceof ITrackItem) {
            return ((ITrackItem)stack.func_77973_b()).placeTrack(stack.func_77946_l(), world, i, j, k);
        }
        if (stack.func_77973_b() instanceof ItemBlock && BlockRailBase.func_150051_a((Block)(block = ((ItemBlock)stack.func_77973_b()).field_150939_a))) {
            boolean success = world.func_147449_b(i, j, k, block);
            if (success) {
                world.func_72908_a((double)((float)i + 0.5f), (double)((float)j + 0.5f), (double)((float)k + 0.5f), block.field_149762_H.func_150496_b(), (block.field_149762_H.func_150497_c() + 1.0f) / 2.0f, block.field_149762_H.func_150494_d() * 0.8f);
            }
            return success;
        }
        return false;
    }

    public static boolean isTrackItem(ItemStack stack) {
        return stack != null && stack.func_77973_b() instanceof ITrackItem;
    }

    public static boolean isCartLockedDown(EntityMinecart cart) {
        TileEntity tile;
        int z;
        int y;
        int x = MathHelper.func_76128_c((double)cart.field_70165_t);
        if (BlockRailBase.func_150049_b_((World)cart.field_70170_p, (int)x, (int)((y = MathHelper.func_76128_c((double)cart.field_70163_u)) - 1), (int)(z = MathHelper.func_76128_c((double)cart.field_70161_v)))) {
            --y;
        }
        if ((tile = cart.field_70170_p.func_147438_o(x, y, z)) instanceof ITrackTile) {
            ITrackInstance track = ((ITrackTile)tile).getTrackInstance();
            return track instanceof ITrackLockdown && ((ITrackLockdown)track).isCartLockedDown(cart);
        }
        if (tile instanceof ITrackLockdown) {
            return ((ITrackLockdown)tile).isCartLockedDown(cart);
        }
        return false;
    }

    public static int countAdjecentTracks(World world, int x, int y, int z) {
        int i = 0;
        if (RailTools.isTrackFuzzyAt(world, x, y, z - 1)) {
            ++i;
        }
        if (RailTools.isTrackFuzzyAt(world, x, y, z + 1)) {
            ++i;
        }
        if (RailTools.isTrackFuzzyAt(world, x - 1, y, z)) {
            ++i;
        }
        if (RailTools.isTrackFuzzyAt(world, x + 1, y, z)) {
            ++i;
        }
        return i;
    }

    public static boolean isTrackFuzzyAt(World world, int x, int y, int z) {
        return BlockRailBase.func_150049_b_((World)world, (int)x, (int)y, (int)z) ? true : (BlockRailBase.func_150049_b_((World)world, (int)x, (int)(y + 1), (int)z) ? true : BlockRailBase.func_150049_b_((World)world, (int)x, (int)(y - 1), (int)z));
    }
}

