/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.api.signals;

import mods.railcraft.api.core.WorldCoordinate;
import mods.railcraft.api.signals.AbstractPair;
import mods.railcraft.api.signals.IReceiverTile;
import mods.railcraft.api.signals.SignalAspect;
import mods.railcraft.api.signals.SignalReceiver;
import mods.railcraft.api.signals.SignalTools;
import net.minecraft.tileentity.TileEntity;

public abstract class SignalController
extends AbstractPair {
    public SignalController(String name, TileEntity tile, int maxPairings) {
        super(name, tile, maxPairings);
    }

    public SignalReceiver getReceiverAt(WorldCoordinate coord) {
        TileEntity recv = this.getPairAt(coord);
        if (recv != null) {
            return ((IReceiverTile)recv).getReceiver();
        }
        return null;
    }

    public abstract SignalAspect getAspectFor(WorldCoordinate var1);

    public boolean sendAspectTo(WorldCoordinate receiver, SignalAspect aspect) {
        SignalReceiver recv = this.getReceiverAt(receiver);
        if (recv != null) {
            recv.onControllerAspectChange(this, aspect);
            return true;
        }
        return false;
    }

    @Override
    protected String getTagName() {
        return "controller";
    }

    @Override
    public boolean isValidPair(TileEntity tile) {
        if (tile instanceof IReceiverTile) {
            SignalReceiver receiver = ((IReceiverTile)tile).getReceiver();
            return receiver.isPairedWith(this.getCoords());
        }
        return false;
    }

    @Deprecated
    public void registerLegacyReceiver(int x, int y, int z) {
        this.pairings.add(new WorldCoordinate(0, x, y, z));
    }

    public void registerReceiver(SignalReceiver receiver) {
        WorldCoordinate coords = receiver.getCoords();
        this.addPairing(coords);
        receiver.registerController(this);
        receiver.onControllerAspectChange(this, this.getAspectFor(coords));
    }

    @Override
    public void tickClient() {
        super.tickClient();
        if (SignalTools.effectManager != null && SignalTools.effectManager.isTuningAuraActive()) {
            for (WorldCoordinate coord : this.pairings) {
                SignalReceiver receiver = this.getReceiverAt(coord);
                if (receiver == null) continue;
                SignalTools.effectManager.tuningEffect(this.getTile(), receiver.getTile());
            }
        }
    }
}

