/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.integration;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.vec.BlockCoord;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.multipart.RedstoneInteractions;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileMultipart;
import java.util.Arrays;
import mrtjp.projectred.core.Configurator;
import mrtjp.projectred.core.libmc.PRLib;
import mrtjp.projectred.integration.ArrayCommons;
import mrtjp.projectred.integration.SimpleGatePart;
import mrtjp.projectred.transmission.IRedwireEmitter;
import mrtjp.projectred.transmission.IRedwirePart;
import mrtjp.projectred.transmission.IWirePart;
import mrtjp.projectred.transmission.IWirePart$;
import mrtjp.projectred.transmission.WirePropagator;
import mrtjp.projectred.transmission.WirePropagator$;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;

public class RowGatePart
extends SimpleGatePart
implements IRedwirePart,
ArrayCommons.ITopArrayWire {
    public byte signal;

    @Override
    public String getType() {
        return "pr_rgate";
    }

    @Override
    public void save(NBTTagCompound tag) {
        super.save(tag);
        tag.func_74774_a("signal", this.signal);
    }

    @Override
    public void load(NBTTagCompound tag) {
        super.load(tag);
        this.signal = tag.func_74771_c("signal");
    }

    @Override
    public void writeDesc(MCDataOutput packet) {
        super.writeDesc(packet);
        packet.writeByte((int)this.signal);
    }

    @Override
    public void readDesc(MCDataInput packet) {
        super.readDesc(packet);
        this.signal = packet.readByte();
    }

    @Override
    public void read(MCDataInput packet, int switch_key) {
        if (switch_key == 11) {
            this.signal = packet.readByte();
            if (Configurator.staticGates) {
                this.tile().markRender();
            }
        } else {
            super.read(packet, switch_key);
        }
    }

    @Override
    public void updateAndPropagate(TMultiPart prev, int mode) {
        int wireMask = this.wireMask(prev);
        if ((wireMask & 2) != 0) {
            this._updateAndPropogate(prev, mode);
        } else {
            WirePropagator.addNeighborChange(new BlockCoord((TileEntity)this.tile()));
        }
    }

    private void _updateAndPropogate(TMultiPart prev, int mode) {
        int oldSignal = this.signal & 0xFF;
        if (mode == IWirePart$.MODULE$.DROPPING() && oldSignal == 0) {
            return;
        }
        int newSignal = this.calculateSignal();
        if (newSignal < oldSignal) {
            if (newSignal > 0) {
                WirePropagator.propagateAnalogDrop(this);
            }
            this.signal = 0;
            this.propogate(prev, IWirePart$.MODULE$.DROPPING());
        } else if (newSignal > oldSignal) {
            this.signal = (byte)newSignal;
            if (mode == IWirePart$.MODULE$.DROPPING()) {
                this.propogate(null, IWirePart$.MODULE$.RISING());
            } else {
                this.propogate(prev, IWirePart$.MODULE$.RISING());
            }
        } else if (mode == IWirePart$.MODULE$.DROPPING()) {
            this.propogateTo(prev, IWirePart$.MODULE$.RISING());
        } else if (mode == IWirePart$.MODULE$.FORCE()) {
            this.propogate(prev, IWirePart$.MODULE$.FORCED());
        }
    }

    public int calculateSignal() {
        WirePropagator.setDustProvidePower(false);
        WirePropagator$.MODULE$.redwiresProvidePower_$eq(false);
        int s = 0;
        for (int r = 0; r < 4; ++r) {
            int i;
            if (this.toInternal(r) % 2 == 0 || (i = (this.connMap & 1 << r) != 0 ? this.calculateCornerSignal(r) : this.calculateStraightSignal(r)) <= s) continue;
            s = i;
        }
        WirePropagator.setDustProvidePower(true);
        WirePropagator$.MODULE$.redwiresProvidePower_$eq(true);
        return s;
    }

    @Override
    public int calculateCornerSignal(int r) {
        int absDir = Rotation.rotateSide((int)this.side(), (int)r);
        BlockCoord pos = new BlockCoord((TileEntity)this.tile()).offset(absDir).offset(this.side());
        TileMultipart t = PRLib.getMultipartTile((IBlockAccess)this.world(), (BlockCoord)pos);
        if (t != null) {
            return this.getPartSignal(t.partMap(absDir ^ 1), Rotation.rotationTo((int)(absDir ^ 1), (int)(this.side() ^ 1)));
        }
        return 0;
    }

    @Override
    public int calculateStraightSignal(int r) {
        int absDir = Rotation.rotateSide((int)this.side(), (int)r);
        int s = 0;
        BlockCoord pos = new BlockCoord((TileEntity)this.tile()).offset(absDir);
        TileMultipart t = PRLib.getMultipartTile((IBlockAccess)this.world(), (BlockCoord)pos);
        if (t != null && (this.connMap & 16 << r) != 0) {
            TMultiPart tp = t.partMap(this.side());
            if (tp != null) {
                s = this.getPartSignal(tp, (r + 2) % 4);
            }
        } else {
            Block b = this.world().func_147439_a(pos.x, pos.y, pos.z);
            if (b == Blocks.field_150488_af) {
                return this.world().func_72805_g(pos.x, pos.y, pos.z) - 1;
            }
        }
        int i = this.calculateRedstoneSignal(r);
        if (i > s) {
            s = i;
        }
        return s;
    }

    @Override
    public int calculateRedstoneSignal(int r) {
        int absDir = Rotation.rotateSide((int)this.side(), (int)r);
        int i = RedstoneInteractions.getPowerTo((TMultiPart)this, (int)absDir) * 17;
        if (i > 0) {
            return i;
        }
        BlockCoord pos = new BlockCoord((TileEntity)this.tile()).offset(absDir);
        return this.world().func_72878_l(pos.x, pos.y, pos.z, absDir) * 17;
    }

    @Override
    public int getPartSignal(TMultiPart part, int r) {
        if (part instanceof IRedwirePart && ((IRedwirePart)part).isWireSide(r)) {
            return ((IRedwirePart)part).getRedwireSignal(r) - 1;
        }
        if (part instanceof IRedwireEmitter) {
            return ((IRedwireEmitter)part).getRedwireSignal(r);
        }
        return 0;
    }

    @Override
    public void onSignalUpdate() {
        this.tile().func_70296_d();
        super.onChange();
        this.getWriteStream(11).writeByte((int)this.signal);
    }

    public void propogate(TMultiPart prev, int mode) {
        if (mode != IWirePart$.MODULE$.FORCED()) {
            WirePropagator.addPartChange((TMultiPart)this);
        }
        for (int r = 0; r < 4; ++r) {
            if (this.toInternal(r) % 2 == 0) continue;
            if ((this.connMap & 1 << r) != 0) {
                this.propogateCorner(r, prev, mode);
                continue;
            }
            this.propogateStraight(r, prev, mode);
        }
    }

    public void propogateCorner(int r, TMultiPart prev, int mode) {
        int absDir = Rotation.rotateSide((int)this.side(), (int)r);
        BlockCoord pos = new BlockCoord((TileEntity)this.tile()).offset(absDir).offset(this.side());
        TileMultipart t = PRLib.getMultipartTile((IBlockAccess)this.world(), (BlockCoord)pos);
        if (t != null) {
            TMultiPart tp = t.partMap(absDir ^ 1);
            if (tp == prev) {
                return;
            }
            if (this.propogateTo(tp, mode)) {
                return;
            }
        }
        WirePropagator.addNeighborChange(pos);
    }

    public void propogateStraight(int r, TMultiPart prev, int mode) {
        int absDir = Rotation.rotateSide((int)this.side(), (int)r);
        BlockCoord pos = new BlockCoord((TileEntity)this.tile()).offset(absDir);
        TileMultipart t = PRLib.getMultipartTile((IBlockAccess)this.world(), (BlockCoord)pos);
        if (t != null) {
            TMultiPart tp = t.partMap(this.side());
            if (tp == prev) {
                return;
            }
            if (this.propogateTo(tp, mode)) {
                return;
            }
        }
        WirePropagator.addNeighborChange(pos);
    }

    public int wireMask(TMultiPart propogator) {
        if (propogator.tile() == null) {
            return 3;
        }
        if (this.sideDiff(propogator) == Rotation.rotateSide((int)this.side(), (int)this.toAbsolute(0)) >> 1) {
            return 1;
        }
        return 2;
    }

    public int sideDiff(TMultiPart part) {
        int a = this.side() >> 1;
        if (a != 0 && this.y() != part.y()) {
            return 0;
        }
        if (a != 1 && this.z() != part.z()) {
            return 1;
        }
        return 2;
    }

    public boolean propogateTo(TMultiPart part, int mode) {
        if (part instanceof IWirePart) {
            WirePropagator.propagateTo((IWirePart)part, (TMultiPart)this, mode);
            return true;
        }
        return false;
    }

    @Override
    public int getRedwireSignal(int side) {
        int r = this.toInternal(side);
        return r % 2 == 0 ? this.getLogic().getOutput(this, r) * 17 : this.signal & 0xFF;
    }

    @Override
    public void onChange() {
        super.onChange();
        WirePropagator.propagateTo(this, IWirePart$.MODULE$.RISING());
    }

    @Override
    public boolean canConnectRedstone(int side) {
        if ((side & 6) == (this.side() & 6)) {
            return false;
        }
        int r = this.relRot(side);
        if (r % 2 != 0) {
            return true;
        }
        return this.getLogic().canConnect(this, r);
    }

    @Override
    public int weakPowerLevel(int side) {
        if ((side & 6) == (this.side() & 6)) {
            return 0;
        }
        int r = this.relRot(side);
        if (r % 2 != 0) {
            return this.rsLevel(this.signal & 0xFF);
        }
        return super.weakPowerLevel(side);
    }

    public int rsLevel(int i) {
        if (WirePropagator$.MODULE$.redwiresProvidePower()) {
            return (i + 16) / 17;
        }
        return 0;
    }

    @Override
    public boolean isWireSide(int side) {
        if (side < 0) {
            return false;
        }
        return this.toInternal(side) % 2 != 0;
    }

    @Override
    public Cuboid6 getBounds() {
        return ArrayCommons.cBoxes[this.side()];
    }

    @Override
    public Iterable<Cuboid6> getOcclusionBoxes() {
        return Arrays.asList(ArrayCommons.oBoxes[this.side()]);
    }
}

