/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.integration;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.TextureUtils;
import codechicken.lib.vec.BlockCoord;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Vector3;
import codechicken.microblock.FaceMicroClass;
import codechicken.multipart.IconHitEffects;
import codechicken.multipart.JCuboidPart;
import codechicken.multipart.JIconHitEffects;
import codechicken.multipart.JNormalOcclusion;
import codechicken.multipart.NormalOcclusionTest;
import codechicken.multipart.PartMap;
import codechicken.multipart.TFacePart;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileMultipart;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Arrays;
import mrtjp.projectred.api.IConnectable;
import mrtjp.projectred.api.IScrewdriver;
import mrtjp.projectred.core.Configurator;
import mrtjp.projectred.core.libmc.PRLib;
import mrtjp.projectred.core.libmc.WireLib;
import mrtjp.projectred.integration.ComponentStore;
import mrtjp.projectred.integration.EnumGate;
import mrtjp.projectred.integration.GateLogic;
import mrtjp.projectred.integration.RenderGate;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public abstract class GatePart
extends JCuboidPart
implements JNormalOcclusion,
IConnectable,
TFacePart,
JIconHitEffects {
    public static Cuboid6[][] oBoxes = new Cuboid6[6][2];
    public byte orientation;
    public byte subID;
    public byte shape;
    public int connMap;
    public long schedTime;

    public abstract GateLogic getLogic();

    public int side() {
        return this.orientation >> 2;
    }

    public void setSide(int s) {
        this.orientation = (byte)(this.orientation & 3 | s << 2);
    }

    public int rotation() {
        return this.orientation & 3;
    }

    public void setRotation(int r) {
        this.orientation = (byte)(this.orientation & 0xFC | r);
    }

    public int shape() {
        return this.shape & 0xFF;
    }

    public void setShape(int s) {
        this.shape = (byte)s;
    }

    public Transformation rotationT() {
        return Rotation.sideOrientation((int)this.side(), (int)this.rotation()).at(Vector3.center);
    }

    public void preparePlacement(EntityPlayer player, BlockCoord pos, int side, int meta) {
        this.subID = (byte)meta;
        this.setSide(side ^ 1);
        this.setRotation((Rotation.getSidedRotation((EntityPlayer)player, (int)side) + 2) % 4);
    }

    public void save(NBTTagCompound tag) {
        tag.func_74774_a("orient", this.orientation);
        tag.func_74774_a("subID", this.subID);
        tag.func_74774_a("shape", this.shape);
        tag.func_74777_a("connMap", (short)this.connMap);
        tag.func_74772_a("schedTime", this.schedTime);
    }

    public void load(NBTTagCompound tag) {
        this.orientation = tag.func_74771_c("orient");
        this.subID = tag.func_74771_c("subID");
        this.shape = tag.func_74771_c("shape");
        this.connMap = tag.func_74765_d("connMap") & 0xFFFF;
        this.schedTime = tag.func_74763_f("schedTime");
    }

    public void readDesc(MCDataInput packet) {
        this.orientation = packet.readByte();
        this.subID = packet.readByte();
        this.shape = packet.readByte();
    }

    public void read(MCDataInput packet) {
        this.read(packet, packet.readUByte());
    }

    public void read(MCDataInput packet, int switch_key) {
        if (switch_key == 0) {
            this.orientation = packet.readByte();
            if (Configurator.staticGates) {
                this.tile().markRender();
            }
        } else if (switch_key == 1) {
            this.shape = packet.readByte();
            if (Configurator.staticGates) {
                this.tile().markRender();
            }
        }
    }

    public void writeDesc(MCDataOutput packet) {
        packet.writeByte((int)this.orientation);
        packet.writeByte((int)this.subID);
        packet.writeByte((int)this.shape);
    }

    public void scheduleTick(int ticks) {
        if (this.schedTime < 0L) {
            this.schedTime = this.world().func_82737_E() + (long)ticks;
        }
    }

    private void processScheduled() {
        if (this.schedTime >= 0L && this.world().func_82737_E() >= this.schedTime) {
            this.schedTime = -1L;
            this.scheduledTick();
        }
    }

    public void onChange() {
        this.processScheduled();
        this.getLogic().onChange(this);
    }

    public void update() {
        if (!this.world().field_72995_K) {
            this.processScheduled();
        }
        this.getLogic().onTick(this);
    }

    public void onPartChanged(TMultiPart part) {
        if (!this.world().field_72995_K) {
            this.updateInternalConnections();
            this.onChange();
        }
    }

    public void onNeighborChanged() {
        if (!this.world().field_72995_K) {
            if (this.dropIfCantStay()) {
                return;
            }
            this.updateExternalConnections();
            this.onChange();
        }
    }

    public void onAdded() {
        super.onAdded();
        if (!this.world().field_72995_K) {
            this.getLogic().setup(this);
            this.updateConnections();
            this.onChange();
        }
    }

    public void onRemoved() {
        super.onRemoved();
        if (!this.world().field_72995_K) {
            this.notifyNeighbors(15);
        }
    }

    public boolean canStay() {
        BlockCoord pos = new BlockCoord((TileEntity)this.tile()).offset(this.side());
        return WireLib.canPlaceWireOnSide((World)this.world(), (int)pos.x, (int)pos.y, (int)pos.z, (ForgeDirection)ForgeDirection.getOrientation((int)(this.side() ^ 1)), (boolean)false);
    }

    public boolean dropIfCantStay() {
        if (!this.canStay()) {
            this.drop();
            return true;
        }
        return false;
    }

    public void drop() {
        TileMultipart.dropItem((ItemStack)this.getItem(), (World)this.world(), (Vector3)Vector3.fromTileEntityCenter((TileEntity)this.tile()));
        this.tile().remPart((TMultiPart)this);
    }

    public EnumGate getGateType() {
        return EnumGate.VALID_GATES[this.subID & 0xFF];
    }

    protected void updateConnections() {
        this.updateInternalConnections();
        this.updateExternalConnections();
    }

    protected boolean updateExternalConnections() {
        int newConn = 0;
        for (int r = 0; r < 4; ++r) {
            if (this.connectStraight(r)) {
                newConn |= 16 << r;
                continue;
            }
            if (!this.connectCorner(r)) continue;
            newConn |= 1 << r;
        }
        if (newConn != (this.connMap & 0xF000FF)) {
            int diff = this.connMap ^ newConn;
            this.connMap = this.connMap & 0xFF0FFF00 | newConn;
            for (int r = 0; r < 4; ++r) {
                if ((diff & 1 << r) == 0) continue;
                this.notifyCornerChange(r);
            }
            return true;
        }
        return false;
    }

    protected boolean updateInternalConnections() {
        int newConn = 0;
        for (int r = 0; r < 4; ++r) {
            if (!this.connectInternal(r)) continue;
            newConn |= 256 << r;
        }
        if (newConn != (this.connMap & 0x10F00)) {
            this.connMap = this.connMap & 0xFFFEF0FF | newConn;
            return true;
        }
        return false;
    }

    public boolean connectCorner(int r) {
        TMultiPart tp;
        int absDir = Rotation.rotateSide((int)this.side(), (int)r);
        BlockCoord pos = new BlockCoord((TileEntity)this.tile()).offset(absDir);
        if (!this.world().func_147437_c(pos.x, pos.y, pos.z)) {
            int side1 = absDir ^ 1;
            int side2 = this.side();
            TileMultipart t = PRLib.getMultipartTile((IBlockAccess)this.world(), (BlockCoord)pos);
            if (t != null && (t.partMap(side1) != null || t.partMap(side2) != null || t.partMap(PartMap.edgeBetween((int)side1, (int)side2)) != null)) {
                return false;
            }
        }
        pos.offset(this.side());
        TileMultipart t = PRLib.getMultipartTile((IBlockAccess)this.world(), (BlockCoord)pos);
        if (t != null && (tp = t.partMap(absDir ^ 1)) instanceof IConnectable) {
            IConnectable conn = (IConnectable)tp;
            int r2 = Rotation.rotationTo((int)(absDir ^ 1), (int)(this.side() ^ 1));
            return this.canConnectTo(conn, r) && conn.canConnectCorner(r2) && conn.connectCorner((IConnectable)this, r2, -1);
        }
        return false;
    }

    public boolean connectStraight(int r) {
        TMultiPart tp;
        int absDir = Rotation.rotateSide((int)this.side(), (int)r);
        BlockCoord pos = new BlockCoord((TileEntity)this.tile()).offset(absDir);
        TileMultipart t = PRLib.getMultipartTile((IBlockAccess)this.world(), (BlockCoord)pos);
        if (t != null && (tp = t.partMap(this.side())) instanceof IConnectable) {
            IConnectable conn = (IConnectable)tp;
            return this.canConnectTo(conn, r) && conn.connectStraight((IConnectable)this, (r + 2) % 4, -1);
        }
        return this.connectStraightOverride(absDir);
    }

    public boolean connectStraightOverride(int absDir) {
        return false;
    }

    public boolean connectInternal(int r) {
        int absDir = Rotation.rotateSide((int)this.side(), (int)r);
        if (this.tile().partMap(PartMap.edgeBetween((int)absDir, (int)this.side())) != null) {
            return false;
        }
        TMultiPart tp = this.tile().partMap(absDir);
        if (tp instanceof IConnectable) {
            IConnectable conn = (IConnectable)tp;
            return this.canConnectTo(conn, r) && conn.connectInternal((IConnectable)this, Rotation.rotationTo((int)absDir, (int)this.side()));
        }
        return false;
    }

    public void notifyCornerChange(int r) {
        int absDir = Rotation.rotateSide((int)this.side(), (int)r);
        BlockCoord pos = new BlockCoord((TileEntity)this.tile()).offset(absDir).offset(this.side());
        this.world().func_147460_e(pos.x, pos.y, pos.z, this.tile().func_145838_q());
    }

    public void notifyStraightChange(int r) {
        int absDir = Rotation.rotateSide((int)this.side(), (int)r);
        BlockCoord pos = new BlockCoord((TileEntity)this.tile()).offset(absDir);
        this.world().func_147460_e(pos.x, pos.y, pos.z, this.tile().func_145838_q());
    }

    public boolean maskConnects(int r) {
        return (this.connMap & 273 << r) != 0;
    }

    public Cuboid6 getBounds() {
        return FaceMicroClass.aBounds()[0x10 | this.side()];
    }

    public Iterable<Cuboid6> getOcclusionBoxes() {
        return Arrays.asList(oBoxes[this.side()]);
    }

    public boolean occlusionTest(TMultiPart npart) {
        return NormalOcclusionTest.apply((JNormalOcclusion)this, (TMultiPart)npart);
    }

    public float getStrength(MovingObjectPosition hit, EntityPlayer player) {
        return hit.field_72310_e == 1 ? 1.75f : 1.5f;
    }

    public ItemStack getItem() {
        return this.getGateType().makeStack();
    }

    public ItemStack pickItem(MovingObjectPosition hit) {
        return this.getItem();
    }

    public Iterable<ItemStack> getDrops() {
        return Arrays.asList(this.getItem());
    }

    public boolean activate(EntityPlayer player, MovingObjectPosition hit, ItemStack held) {
        if (this.getLogic().activate(this, player, held)) {
            return true;
        }
        if (held != null && held.func_77973_b() instanceof IScrewdriver) {
            if (!this.world().field_72995_K) {
                if (player.func_70093_af()) {
                    this.configure();
                } else {
                    this.rotate();
                }
                ((IScrewdriver)held.func_77973_b()).damageScrewdriver(this.world(), player);
            }
            return true;
        }
        return false;
    }

    public void configure() {
        boolean changed = this.getLogic().cycleShape(this);
        if (changed) {
            this.updateConnections();
            this.tile().func_70296_d();
            this.tile().notifyPartChange((TMultiPart)this);
            this.sendShapeUpdate();
            this.notifyNeighbors(15);
            this.onChange();
        }
    }

    public void rotate() {
        this.setRotation((this.rotation() + 1) % 4);
        this.updateConnections();
        this.tile().func_70296_d();
        this.tile().notifyPartChange((TMultiPart)this);
        this.sendOrientationUpdate();
        this.notifyNeighbors(15);
        this.onChange();
    }

    public MCDataOutput getWriteStream(int switch_key) {
        return this.tile().getWriteStream((TMultiPart)this).writeByte(switch_key);
    }

    public void sendShapeUpdate() {
        this.getWriteStream(1).writeByte((int)this.shape);
    }

    public void sendOrientationUpdate() {
        this.getWriteStream(0).writeByte((int)this.orientation);
    }

    public void notifyNeighbors(int mask) {
        for (int r = 0; r < 4; ++r) {
            if ((mask & 1 << r) != 0) {
                this.notifyCornerChange(r);
                continue;
            }
            if ((mask & 16 << r) == 0) continue;
            this.notifyStraightChange(r);
        }
    }

    public void scheduledTick() {
        this.getLogic().scheduledTick(this);
    }

    public boolean connectCorner(IConnectable part, int r, int edgeSide) {
        if (this.canConnectTo(part, r)) {
            this.connMap |= 1 << r;
            return true;
        }
        return false;
    }

    public boolean connectStraight(IConnectable part, int r, int edgeSide) {
        if (this.canConnectTo(part, r)) {
            this.connMap |= 16 << r;
            return true;
        }
        return false;
    }

    public boolean connectInternal(IConnectable part, int r) {
        if (r < 0) {
            return false;
        }
        if (this.canConnectTo(part, r)) {
            this.connMap |= 256 << r;
            return true;
        }
        return false;
    }

    public boolean canConnectCorner(int r) {
        return false;
    }

    public int toInternal(int absRot) {
        return (absRot + 6 - this.rotation()) % 4;
    }

    public int toAbsolute(int r) {
        return (r + this.rotation() + 2) % 4;
    }

    public static int shiftMask(int mask, int r) {
        return (mask << r | mask >> 4 - r) & 0xF;
    }

    public static int flipMaskZ(int mask) {
        return mask & 5 | mask << 2 & 8 | mask >> 2 & 2;
    }

    public int toAbsoluteMask(int mask) {
        return GatePart.shiftMask(mask, this.toAbsolute(0));
    }

    public int toInternalMask(int mask) {
        return GatePart.shiftMask(mask, this.toInternal(0));
    }

    public int relRot(int side) {
        return this.toInternal(Rotation.rotationTo((int)this.side(), (int)side));
    }

    public boolean canConnectTo(IConnectable part, int r) {
        return this.getLogic().canConnectTo(this, part, this.toInternal(r));
    }

    @SideOnly(value=Side.CLIENT)
    public boolean renderStatic(Vector3 pos, int pass) {
        if (pass == 0 && Configurator.staticGates) {
            TextureUtils.bindAtlas((int)0);
            CCRenderState.setBrightness((IBlockAccess)this.world(), (int)this.x(), (int)this.y(), (int)this.z());
            RenderGate.renderStatic(this, pos);
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderDynamic(Vector3 pos, float frame, int pass) {
        if (pass == 0) {
            TextureUtils.bindAtlas((int)0);
            if (!Configurator.staticGates) {
                GL11.glDisable((int)2896);
                CCRenderState.startDrawing();
                RenderGate.renderStatic(this, pos);
                CCRenderState.draw();
                GL11.glEnable((int)2896);
            }
            RenderGate.renderDynamic(this, pos, frame);
        }
    }

    public int getSlotMask() {
        return 1 << this.side();
    }

    public int redstoneConductionMap() {
        return 0;
    }

    public boolean solid(int side) {
        return false;
    }

    public int getLightValue() {
        return this.getLogic().lightLevel();
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getBreakingIcon(Object arg0, int arg1) {
        return this.getBrokenIcon(arg1);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getBrokenIcon(int arg0) {
        return ComponentStore.baseIcon;
    }

    public void addHitEffects(MovingObjectPosition hit, EffectRenderer effectRenderer) {
        IconHitEffects.addHitEffects((JIconHitEffects)this, (MovingObjectPosition)hit, (EffectRenderer)effectRenderer);
    }

    public void addDestroyEffects(EffectRenderer effectRenderer) {
        IconHitEffects.addDestroyEffects((JIconHitEffects)this, (EffectRenderer)effectRenderer, (boolean)false);
    }

    public abstract String getType();

    static {
        GatePart.oBoxes[0][0] = new Cuboid6(0.125, 0.0, 0.0, 0.875, 0.125, 1.0);
        GatePart.oBoxes[0][1] = new Cuboid6(0.0, 0.0, 0.125, 1.0, 0.125, 0.875);
        for (int s = 1; s < 6; ++s) {
            Transformation t = Rotation.sideRotations[s].at(Vector3.center);
            GatePart.oBoxes[s][0] = oBoxes[0][0].copy().apply(t);
            GatePart.oBoxes[s][1] = oBoxes[0][1].copy().apply(t);
        }
    }
}

