/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.integration;

import codechicken.lib.colour.Colour;
import codechicken.lib.lighting.LightModel;
import codechicken.lib.lighting.PlanarLightModel;
import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.ColourMultiplier;
import codechicken.lib.render.TextureDataHolder;
import codechicken.lib.render.TextureSpecial;
import codechicken.lib.render.TextureUtils;
import codechicken.lib.render.Vertex5;
import codechicken.lib.render.uv.IconTransformation;
import codechicken.lib.render.uv.MultiIconTransformation;
import codechicken.lib.render.uv.UVScale;
import codechicken.lib.render.uv.UVTransformation;
import codechicken.lib.render.uv.UVTranslation;
import codechicken.lib.vec.Rectangle4i;
import codechicken.lib.vec.RedundantTransformation;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Scale;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import mrtjp.projectred.core.Configurator;
import mrtjp.projectred.core.InvertX;
import mrtjp.projectred.integration.RenderGate;
import mrtjp.projectred.transmission.UVT;
import mrtjp.projectred.transmission.WireModelGen;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;

public class ComponentStore {
    public static CCModel base = ComponentStore.loadBase("base");
    public static CCModel lightChip = ComponentStore.loadModel("chip");
    public static CCModel leverOn = ComponentStore.loadModel("leveron");
    public static CCModel leverOff = ComponentStore.loadModel("leveroff");
    public static CCModel solarArray = ComponentStore.loadModel("solar");
    public static CCModel rainSensor = ComponentStore.loadModel("rainsensor");
    public static CCModel pointer = ComponentStore.loadModel("pointer");
    public static CCModel busXcvr = ComponentStore.loadModel("array/busxcvr");
    public static CCModel busXcvrPanel = ComponentStore.loadModel("array/busxcvrpanel");
    public static CCModel nullCellWireBottom = ComponentStore.loadModel("array/nullcellbottomwire").apply((Transformation)new Translation(0.5, 0.0, 0.5));
    public static CCModel nullCellWireTop = ComponentStore.loadModel("array/nullcelltopwire").apply((Transformation)new Translation(0.5, 0.0, 0.5));
    public static CCModel nullCellBase = ComponentStore.loadBase("array/nullcellbase");
    public static CCModel extendedCellWireBottom = ComponentStore.loadModel("array/extendedcellbottomwire").apply((Transformation)new Translation(0.5, 0.0, 0.5));
    public static CCModel extendedCellWireTop = ComponentStore.loadModel("array/extendedcelltopwire").apply((Transformation)new Translation(0.5, 0.0, 0.5));
    public static CCModel extendedCellBase = ComponentStore.loadBase("array/extendedcellbase");
    public static CCModel cellWireSide = ComponentStore.loadModel("array/cellsidewire").apply((Transformation)new Translation(0.5, 0.0, 0.5));
    public static CCModel cellFrame = ComponentStore.loadModel("array/cellstand").apply((Transformation)new Translation(0.5, 0.0, 0.5));
    public static CCModel cellPlate = ComponentStore.loadModel("array/cellplate").apply((Transformation)new Translation(0.5, 0.0, 0.5));
    public static IIcon baseIcon;
    public static IIcon[] wireIcons;
    public static Colour[][] wireData;
    public static IIcon[] redstoneTorchIcons;
    public static IIcon[] taintedChipIcons;
    public static IIcon[] redstoneChipIcons;
    public static IIcon[] minusChipIcons;
    public static IIcon[] plusChipIcons;
    public static IIcon leverIcon;
    public static IIcon[] solarIcons;
    public static IIcon rainIcon;
    public static IIcon pointerIcon;
    public static IIcon busXcvrIcon;
    public static IIcon cellIcon;

    public static Map<String, CCModel> loadModels(String name) {
        return CCModel.parseObjModels((ResourceLocation)new ResourceLocation("projectred:textures/obj/gateparts/" + name + ".obj"), (int)7, (Transformation)new InvertX());
    }

    public static CCModel loadModel(String name) {
        Map<String, CCModel> models = ComponentStore.loadModels(name);
        CCModel m = CCModel.combine(models.values());
        m.computeNormals();
        m.shrinkUVs(5.0E-4);
        return m;
    }

    public static CCModel[] loadModelSet(String name, String[] ... groups) {
        Map<String, CCModel> modelMap = ComponentStore.loadModels(name);
        CCModel[] models = new CCModel[groups.length];
        for (int i = 0; i < groups.length; ++i) {
            LinkedList<CCModel> grp = new LinkedList<CCModel>();
            for (String s : groups[i]) {
                grp.add(modelMap.get(s));
            }
            CCModel m = CCModel.combine(grp);
            m.computeNormals();
            m.shrinkUVs(5.0E-4);
            models[i] = m;
        }
        return models;
    }

    private static CCModel loadBase(String name) {
        CCModel m = ComponentStore.loadModel(name);
        m.apply((Transformation)new Translation(0.5, 0.0, 0.5));
        for (int i = 0; i < m.verts.length; ++i) {
            m.verts[i].vec.subtract(m.normals()[i].copy().multiply(2.0E-4));
        }
        return m;
    }

    public static void registerIcons(IIconRegister r) {
        int i;
        String baseTex = "projectred:gates/";
        baseIcon = r.func_94245_a(baseTex + "base");
        ComponentStore.wireIcons[0] = r.func_94245_a(baseTex + "surface/bordermatte");
        ComponentStore.wireIcons[1] = r.func_94245_a(baseTex + "surface/wirematte-OFF");
        ComponentStore.wireIcons[2] = r.func_94245_a(baseTex + "surface/wirematte-ON");
        for (i = 0; i < 3; ++i) {
            ResourceLocation res = new ResourceLocation(wireIcons[i].func_94215_i());
            ComponentStore.wireData[i] = TextureUtils.loadTextureColours((ResourceLocation)new ResourceLocation(res.func_110624_b(), "textures/blocks/" + res.func_110623_a() + ".png"));
        }
        ComponentStore.redstoneTorchIcons[0] = r.func_94245_a("redstone_torch_off");
        ComponentStore.redstoneTorchIcons[1] = r.func_94245_a("redstone_torch_on");
        ComponentStore.taintedChipIcons[0] = r.func_94245_a(baseTex + "yellowchipoff");
        ComponentStore.taintedChipIcons[1] = r.func_94245_a(baseTex + "yellowchipon");
        ComponentStore.redstoneChipIcons[0] = r.func_94245_a(baseTex + "redchipoff");
        ComponentStore.redstoneChipIcons[1] = r.func_94245_a(baseTex + "redchipon");
        ComponentStore.minusChipIcons[0] = r.func_94245_a(baseTex + "minuschipoff");
        ComponentStore.minusChipIcons[1] = r.func_94245_a(baseTex + "minuschipon");
        ComponentStore.plusChipIcons[0] = r.func_94245_a(baseTex + "pluschipoff");
        ComponentStore.plusChipIcons[1] = r.func_94245_a(baseTex + "pluschipon");
        for (i = 0; i < 3; ++i) {
            ComponentStore.solarIcons[i] = r.func_94245_a(baseTex + "solar" + i);
        }
        rainIcon = r.func_94245_a(baseTex + "rainsensor");
        leverIcon = r.func_94245_a(baseTex + "lever");
        pointerIcon = r.func_94245_a(baseTex + "pointer");
        busXcvrIcon = r.func_94245_a(baseTex + "busxcvr");
        cellIcon = r.func_94245_a(baseTex + "cells");
        RenderGate.registerIcons(r);
    }

    public static WireComponentModel[] generateWireModels(String name, int count) {
        WireComponentModel[] models = new WireComponentModel[count];
        for (int i = 0; i < count; ++i) {
            models[i] = ComponentStore.generateWireModel(name + "-" + i);
        }
        return models;
    }

    public static WireComponentModel generateWireModel(String name) {
        Colour[] data = TextureUtils.loadTextureColours((ResourceLocation)new ResourceLocation("projectred:textures/blocks/gates/surface/" + name + ".png"));
        WireComponentModel m = new WireComponentModel();
        if (Configurator.logicwires3D) {
            new WireModel3D(data).bind(m);
        } else {
            new WireModel2D(data).bind(m);
        }
        return m;
    }

    public static Transformation orientT(int orient) {
        Transformation t = Rotation.sideOrientation((int)(orient % 24 >> 2), (int)(orient & 3));
        if (orient >= 24) {
            t = new Scale(-1.0, 1.0, 1.0).with(t);
        }
        return t.at(Vector3.center);
    }

    public static Transformation dynamicT(int orient) {
        return orient == 0 ? new RedundantTransformation() : new Scale(-1.0, 1.0, 1.0).at(Vector3.center);
    }

    public static CCModel bakeCopy(CCModel base, int orient) {
        CCModel m = base.copy();
        if (orient >= 24) {
            ComponentStore.reverseFacing(m);
        }
        m.apply(ComponentStore.orientT(orient)).computeLighting(LightModel.standardLightModel);
        return m;
    }

    public static CCModel[] bakeDynamic(CCModel base) {
        return new CCModel[]{base.copy(), ComponentStore.reverseFacing(base.copy())};
    }

    public static CCModel reverseFacing(CCModel m) {
        for (int i = 0; i < m.verts.length; i += 4) {
            Vertex5 vtmp = m.verts[i + 1];
            Vector3 ntmp = m.normals()[i + 1];
            m.verts[i + 1] = m.verts[i + 3];
            m.normals()[i + 1] = m.normals()[i + 3];
            m.verts[i + 3] = vtmp;
            m.normals()[i + 3] = ntmp;
        }
        return m;
    }

    static {
        wireIcons = new IIcon[3];
        wireData = new Colour[3][];
        redstoneTorchIcons = new IIcon[2];
        taintedChipIcons = new IIcon[2];
        redstoneChipIcons = new IIcon[2];
        minusChipIcons = new IIcon[2];
        plusChipIcons = new IIcon[2];
        solarIcons = new IIcon[3];
    }

    public static class ExtendedCellBaseModel
    extends SimpleComponentModel {
        public ExtendedCellBaseModel() {
            super(extendedCellBase);
        }

        @Override
        public IIcon getIcon() {
            return cellIcon;
        }
    }

    public static class NullCellBaseModel
    extends SimpleComponentModel {
        public NullCellBaseModel() {
            super(nullCellBase);
        }

        @Override
        public IIcon getIcon() {
            return cellIcon;
        }
    }

    public static class CellPlateModel
    extends SimpleComponentModel {
        public CellPlateModel() {
            super(cellPlate);
        }

        @Override
        public IIcon getIcon() {
            return cellIcon;
        }
    }

    public static class CellFrameModel
    extends SimpleComponentModel {
        public CellFrameModel() {
            super(cellFrame);
        }

        @Override
        public IIcon getIcon() {
            return cellIcon;
        }
    }

    public static class CellBottomWireModel
    extends CellWireModel {
        public CCModel[] bottom = new CCModel[24];

        public CellBottomWireModel(CCModel wireBottom) {
            for (int i = 0; i < 24; ++i) {
                this.bottom[i] = ComponentStore.bakeCopy(wireBottom, i);
            }
        }

        @Override
        public void renderModel(Transformation t, int orient) {
            this.bottom[orient].render(new CCRenderState.IVertexOperation[]{t, new IconTransformation(cellIcon), this.colourMult()});
        }
    }

    public static class CellTopWireModel
    extends CellWireModel {
        public static CCModel[] left = new CCModel[24];
        public static CCModel[] right = new CCModel[24];
        public CCModel[] top = new CCModel[24];
        public byte conn;

        public CellTopWireModel(CCModel wireTop) {
            for (int i = 0; i < 24; ++i) {
                this.top[i] = ComponentStore.bakeCopy(wireTop, i);
            }
        }

        @Override
        public void renderModel(Transformation t, int orient) {
            IconTransformation icont = new IconTransformation(cellIcon);
            this.top[orient].render(new CCRenderState.IVertexOperation[]{t, icont, this.colourMult()});
            if ((this.conn & 2) == 0) {
                right[orient].render(new CCRenderState.IVertexOperation[]{t, icont, this.colourMult()});
            }
            if ((this.conn & 8) == 0) {
                left[orient].render(new CCRenderState.IVertexOperation[]{t, icont, this.colourMult()});
            }
        }

        static {
            CCModel cellWireLeft = cellWireSide.copy().apply((Transformation)new Translation(-0.4375625, 0.0, 0.0));
            CCModel cellWireRight = cellWireSide.copy().apply((Transformation)new Translation(0.4375625, 0.0, 0.0));
            for (int i = 0; i < 24; ++i) {
                CellTopWireModel.left[i] = ComponentStore.bakeCopy(cellWireLeft, i);
                CellTopWireModel.right[i] = ComponentStore.bakeCopy(cellWireRight, i);
            }
        }
    }

    public static abstract class CellWireModel
    extends ComponentModel {
        public byte signal;

        public static int signalColour(byte signal) {
            return (signal & 0xFF) / 2 + 60 << 24 | 0xFF;
        }

        public CCRenderState.IVertexOperation colourMult() {
            return ColourMultiplier.instance((int)CellWireModel.signalColour(this.signal));
        }
    }

    public static class BusXcvrPanelModel
    extends ComponentModel {
        public static CCModel[] displayModels = new CCModel[16];
        public CCModel[] models;
        public Vector3 pos;
        public boolean flip;
        public int signal;

        public BusXcvrPanelModel(double x, double z, boolean flip) {
            this.flip = flip;
            this.pos = new Vector3(x, 0.0, z).multiply(0.0625);
            CCModel base = busXcvrPanel.copy();
            if (flip) {
                base.apply(Rotation.quarterRotations[2]);
            }
            base.apply((Transformation)this.pos.translation());
            this.models = new CCModel[48];
            for (int i = 0; i < 48; ++i) {
                this.models[i] = ComponentStore.bakeCopy(base, i);
            }
        }

        @Override
        public void renderModel(Transformation t, int orient) {
            IconTransformation icont = new IconTransformation(busXcvrIcon);
            this.models[orient].render(new CCRenderState.IVertexOperation[]{t, icont});
            Vector3 displayPos = this.pos.copy();
            if (orient >= 24) {
                displayPos.x = 1.0 - displayPos.x;
            }
            RedundantTransformation displayT = this.flip ? new RedundantTransformation() : Rotation.quarterRotations[2];
            displayT = displayT.with((Transformation)displayPos.translation()).with(ComponentStore.orientT(orient % 24)).with(t);
            for (int i = 0; i < 16; ++i) {
                if ((this.signal & 1 << i) == 0) continue;
                displayModels[i].render(new CCRenderState.IVertexOperation[]{displayT, icont, PlanarLightModel.standardLightModel});
            }
        }

        static {
            for (int i = 0; i < 16; ++i) {
                CCModel m = CCModel.quadModel((int)4);
                int x = i % 4;
                int z = i / 4;
                double y = 0.3126;
                m.verts[0] = new Vertex5((double)x, y, (double)(z + 1), (double)x, (double)z);
                m.verts[1] = new Vertex5((double)(x + 1), y, (double)(z + 1), (double)(x + 1), (double)z);
                m.verts[2] = new Vertex5((double)(x + 1), y, (double)z, (double)(x + 1), (double)(z + 1));
                m.verts[3] = new Vertex5((double)x, y, (double)z, (double)x, (double)(z + 1));
                m.apply((Transformation)new Scale(0.0625, 1.0, 0.0625).with((Transformation)new Translation(-0.125, 0.0, -0.125)));
                m.apply((UVTransformation)new UVTranslation(22.0, 0.0));
                m.apply((UVTransformation)new UVScale(0.03125));
                m.computeNormals();
                m.shrinkUVs(5.0E-4);
                BusXcvrPanelModel.displayModels[i] = m;
            }
        }
    }

    public static class BusXcvrCableModel
    extends BundledCableModel {
        public BusXcvrCableModel() {
            super(busXcvr, new Vector3(8.0, 0.0, 8.0), 0.3125, 0.4375);
        }

        @Override
        public UVTransformation getUVT() {
            return new IconTransformation(busXcvrIcon);
        }
    }

    public static abstract class BundledCableModel
    extends SingleComponentModel {
        public BundledCableModel(CCModel model, Vector3 pos, double texCenterU, double texCenterV) {
            super(model, pos);
            for (int orient = 0; orient < 48; ++orient) {
                int side = orient % 24 >> 2;
                int r = orient & 3;
                boolean reflect = orient >= 24;
                boolean rotate = (r + WireModelGen.reorientSide()[side]) % 4 >= 2;
                RedundantTransformation t = new RedundantTransformation();
                if (reflect) {
                    t = t.with((Transformation)new Scale(-1.0, 0.0, 1.0));
                }
                if (rotate) {
                    t = t.with(Rotation.quarterRotations[2]);
                }
                if (t instanceof RedundantTransformation) continue;
                this.models[orient].apply((UVTransformation)new UVT(t.at(new Vector3(texCenterU, 0.0, texCenterV))));
            }
        }
    }

    public static class PointerModel
    extends ComponentModel {
        public CCModel[] models;
        public double angle;
        public Vector3 pos;

        public PointerModel(double x, double y, double z) {
            this.models = ComponentStore.bakeDynamic(pointer);
            this.pos = new Vector3(x, y - 1.0, z).multiply(0.0625);
        }

        public PointerModel(double x, double y, double z, double scale) {
            this.models = ComponentStore.bakeDynamic(pointer.copy().apply((Transformation)new Scale(scale, 1.0, scale)));
            this.pos = new Vector3(x, y - 1.0, z).multiply(0.0625);
        }

        @Override
        public void renderModel(Transformation t, int orient) {
            this.models[orient].render(new CCRenderState.IVertexOperation[]{new Rotation(-this.angle + Math.PI, 0.0, 1.0, 0.0).with((Transformation)this.pos.translation()).with(ComponentStore.dynamicT(orient)).with(t), new IconTransformation(pointerIcon)});
        }
    }

    public static class RainSensorModel
    extends SimpleComponentModel {
        public RainSensorModel(double x, double z) {
            super(rainSensor, new Vector3(x, 0.0, z));
        }

        @Override
        public IIcon getIcon() {
            return rainIcon;
        }
    }

    public static class SolarModel
    extends StateIconModel {
        public SolarModel(double x, double z) {
            super(solarArray, new Vector3(x, 0.0, z));
        }

        @Override
        public IIcon[] getIcons() {
            return solarIcons;
        }
    }

    public static class PlusChipModel
    extends OnOffModel {
        public PlusChipModel(double x, double z) {
            super(lightChip, new Vector3(x, 0.0, z));
        }

        @Override
        public IIcon[] getIcons() {
            return plusChipIcons;
        }
    }

    public static class MinusChipModel
    extends OnOffModel {
        public MinusChipModel(double x, double z) {
            super(lightChip, new Vector3(x, 0.0, z));
        }

        @Override
        public IIcon[] getIcons() {
            return minusChipIcons;
        }
    }

    public static class RedChipModel
    extends OnOffModel {
        public RedChipModel(double x, double z) {
            super(lightChip, new Vector3(x, 0.0, z));
        }

        @Override
        public IIcon[] getIcons() {
            return redstoneChipIcons;
        }
    }

    public static class YellowChipModel
    extends OnOffModel {
        public YellowChipModel(double x, double z) {
            super(lightChip, new Vector3(x, 0.0, z));
        }

        @Override
        public IIcon[] getIcons() {
            return taintedChipIcons;
        }
    }

    public static class FlippedRSTorchModel
    extends RedstoneTorchModel {
        public FlippedRSTorchModel(double x, double z) {
            super(FlippedRSTorchModel.genModel(4, x, z).apply((Transformation)new Rotation(3.1415926535897403, 0.0, 0.0, 1.0).at(Vector3.center).with((Transformation)new Translation(new Vector3(0.0, -6.0, 0.0).multiply(0.0625)))));
            this.lightPos = new Vector3(x, 3.0, z).multiply(0.0625);
        }
    }

    public static class RedstoneTorchModel
    extends OnOffModel {
        public Vector3 lightPos;

        public RedstoneTorchModel(double x, double z, int height) {
            super(RedstoneTorchModel.genModel(height, x, z));
            this.lightPos = new Vector3(x, (double)(height - 1), z).multiply(0.0625);
        }

        public RedstoneTorchModel(CCModel m) {
            super(m);
        }

        public static CCModel genModel(int height, double x, double z) {
            CCModel m = CCModel.quadModel((int)20);
            m.verts[0] = new Vertex5(0.4375, 0.625, 0.5625, 0.4375, 0.5);
            m.verts[1] = new Vertex5(0.5625, 0.625, 0.5625, 0.5625, 0.5);
            m.verts[2] = new Vertex5(0.5625, 0.625, 0.4375, 0.5625, 0.375);
            m.verts[3] = new Vertex5(0.4375, 0.625, 0.4375, 0.4375, 0.375);
            m.generateBlock(4, 0.375, (double)(10 - height) / 16.0, 0.4375, 0.625, 0.6875, 0.5625, 51);
            m.generateBlock(12, 0.4375, (double)(10 - height) / 16.0, 0.375, 0.5625, 0.6875, 0.625, 15);
            m.apply((Transformation)new Translation(-0.5 + x / 16.0, (double)(height - 10) / 16.0, -0.5 + z / 16.0));
            m.computeNormals();
            m.shrinkUVs(5.0E-4);
            m.apply((Transformation)new Scale(1.0005));
            return m;
        }

        @Override
        public IIcon[] getIcons() {
            return redstoneTorchIcons;
        }
    }

    public static class WireModel2D
    extends ComponentModel {
        public static CCModel[] models = new CCModel[48];
        private static int iconCounter = 0;
        private WireComponentModel parent;
        public TextureSpecial[] icons;
        public Colour[] wireMask;
        private final int iconIndex = iconCounter++;

        public WireModel2D(Colour[] data) {
            this.wireMask = data;
        }

        public void bind(WireComponentModel parent) {
            this.parent = parent;
            parent.bind(this);
        }

        @Override
        public void renderModel(Transformation t, int orient) {
            models[orient].render(new CCRenderState.IVertexOperation[]{t, new IconTransformation((IIcon)this.icons[this.parent.disabled ? 0 : (this.parent.on ? 2 : 1)])});
        }

        @Override
        public void registerTextures(IIconRegister r) {
            List<Rectangle4i> wireRectangles = WireComponentModel.rectangulate(this.wireMask);
            this.icons = new TextureSpecial[wireData.length];
            for (int tex = 0; tex < this.icons.length; ++tex) {
                int[] texMap = new int[1024];
                for (Rectangle4i rect : wireRectangles) {
                    this.fillMask(texMap, rect, 2);
                    this.fillMask(texMap, WireComponentModel.border(rect), 1);
                }
                int pSize = (int)Math.sqrt(wireData[0].length);
                int size = Math.max(32, pSize);
                int relM = size / 32;
                int relP = size / pSize;
                int[] imageData = new int[size * size];
                for (int i = 0; i < imageData.length; ++i) {
                    int y = i / size;
                    int x = i % size;
                    int type = texMap[y / relM * 32 + x / relM];
                    if (type == 0) continue;
                    imageData[i] = wireData[type == 1 ? 0 : tex][y / relP * pSize + x / relP].argb();
                }
                this.icons[tex] = TextureUtils.getTextureSpecial((IIconRegister)r, (String)("projectred:gates/wire2d_" + this.iconIndex + "_" + tex)).addTexture(new TextureDataHolder(imageData, size));
            }
        }

        private void fillMask(int[] map, Rectangle4i r, int val) {
            for (int i = r.x; i < r.x + r.w; ++i) {
                for (int j = r.y; j < r.y + r.h; ++j) {
                    if (map[j * 32 + i] >= val) continue;
                    map[j * 32 + i] = val;
                }
            }
        }

        static {
            CCModel m = CCModel.quadModel((int)4).generateBlock(0, 0.0, 0.0, 0.0, 1.0, 0.127, 1.0, -3).computeNormals();
            m.shrinkUVs(5.0E-4);
            for (int i = 0; i < 48; ++i) {
                WireModel2D.models[i] = ComponentStore.bakeCopy(m, i);
            }
        }
    }

    public static class WireModel3D
    extends SingleComponentModel {
        private WireComponentModel parent;

        public WireModel3D(Colour[] data) {
            super(WireModel3D.generateModel(data));
        }

        public void bind(WireComponentModel parent) {
            this.parent = parent;
            parent.bind(this);
        }

        private static CCModel generateModel(Colour[] data) {
            List<Rectangle4i> wireRectangles = WireComponentModel.rectangulate(data);
            CCModel model = CCModel.quadModel((int)(wireRectangles.size() * 40));
            int i = 0;
            for (Rectangle4i rect : wireRectangles) {
                WireModel3D.generateWireSegment(model, i, rect);
                i += 40;
            }
            model.computeNormals();
            model.shrinkUVs(5.0E-4);
            return model;
        }

        private static void generateWireSegment(CCModel model, int i, Rectangle4i rect) {
            WireModel3D.generateWireSegment(model, i, WireComponentModel.border(rect), 0.01, 0);
            WireModel3D.generateWireSegment(model, i + 20, rect, 0.02, 1);
        }

        private static void generateWireSegment(CCModel model, int i, Rectangle4i rect, double h, int icon) {
            double x1 = (double)rect.x / 32.0;
            double x2 = (double)(rect.x + rect.w) / 32.0;
            double z1 = (double)rect.y / 32.0;
            double z2 = (double)(rect.y + rect.h) / 32.0;
            double d = 5.0E-4 - h / 50.0;
            model.generateBlock(i, x1 + d, 0.125, z1 + d, x2 - d, 0.125 + h, z2 - d, 1);
            for (int v = i; v < i + 20; ++v) {
                model.verts[v].uv.tex = icon;
            }
        }

        @Override
        public UVTransformation getUVT() {
            if (this.parent.disabled) {
                return new IconTransformation(wireIcons[0]);
            }
            if (this.parent.on) {
                return new MultiIconTransformation(new IIcon[]{wireIcons[0], wireIcons[2]});
            }
            return new MultiIconTransformation(new IIcon[]{wireIcons[0], wireIcons[1]});
        }
    }

    public static class WireComponentModel
    extends ComponentModel {
        public boolean on;
        public boolean disabled;
        private ComponentModel model;

        public WireComponentModel bind(ComponentModel model) {
            this.model = model;
            return this;
        }

        protected static List<Rectangle4i> rectangulate(Colour[] data) {
            boolean[] wireCorners = new boolean[1024];
            for (int y = 0; y <= 30; ++y) {
                for (int x = 0; x <= 30; ++x) {
                    if (data[y * 32 + x].rgba() != -1 || WireComponentModel.overlap(wireCorners, x, y)) continue;
                    if (!WireComponentModel.segment2x2(data, x, y)) {
                        throw new RuntimeException("Wire segment not 2x2 at (" + x + ", " + y + ")");
                    }
                    wireCorners[y * 32 + x] = true;
                }
            }
            LinkedList<Rectangle4i> wireRectangles = new LinkedList<Rectangle4i>();
            for (int i = 0; i < 1024; ++i) {
                int dx;
                int y;
                int x;
                if (!wireCorners[i]) continue;
                Rectangle4i rect = new Rectangle4i(i % 32, i / 32, 0, 0);
                for (x = rect.x + 2; x < 30 && wireCorners[rect.y * 32 + x]; x += 2) {
                }
                rect.w = x - rect.x;
                for (y = rect.y + 2; y < 30; y += 2) {
                    boolean advance = true;
                    for (dx = rect.x; dx < rect.x + rect.w && advance; dx += 2) {
                        if (wireCorners[y * 32 + dx]) continue;
                        advance = false;
                    }
                    if (!advance) break;
                }
                rect.h = y - rect.y;
                for (int dy = rect.y; dy < rect.y + rect.h; dy += 2) {
                    for (dx = rect.x; dx < rect.x + rect.w; dx += 2) {
                        wireCorners[dy * 32 + dx] = false;
                    }
                }
                wireRectangles.add(rect);
            }
            return wireRectangles;
        }

        private static boolean overlap(boolean[] wireCorners, int x, int y) {
            return wireCorners[y * 32 + x - 1] || wireCorners[(y - 1) * 32 + x] || wireCorners[(y - 1) * 32 + x - 1];
        }

        private static boolean segment2x2(Colour[] data, int x, int y) {
            return data[y * 32 + x + 1].rgba() == -1 && data[(y + 1) * 32 + x].rgba() == -1 && data[(y + 1) * 32 + x + 1].rgba() == -1;
        }

        public static Rectangle4i border(Rectangle4i wire) {
            Rectangle4i border = new Rectangle4i(wire.x - 2, wire.y - 2, wire.w + 4, wire.h + 4);
            if (border.x < 0) {
                border.w += border.x;
                border.x = 0;
            }
            if (border.y < 0) {
                border.h += border.y;
                border.y = 0;
            }
            if (border.x + border.w >= 32) {
                border.w -= border.x + border.w - 32;
            }
            if (border.y + border.h >= 32) {
                border.h -= border.y + border.h - 32;
            }
            return border;
        }

        @Override
        public void renderModel(Transformation t, int orient) {
            this.model.renderModel(t, orient);
        }

        @Override
        public void registerTextures(IIconRegister r) {
            this.model.registerTextures(r);
        }
    }

    public static abstract class StateIconModel
    extends SingleComponentModel {
        public int state;

        public StateIconModel(CCModel m) {
            super(m);
        }

        public StateIconModel(CCModel m, Vector3 pos) {
            super(m, pos);
        }

        public abstract IIcon[] getIcons();

        @Override
        public UVTransformation getUVT() {
            return new IconTransformation(this.getIcons()[this.state]);
        }
    }

    public static abstract class OnOffModel
    extends SingleComponentModel {
        public boolean on;

        public OnOffModel(CCModel m) {
            super(m);
        }

        public OnOffModel(CCModel m, Vector3 pos) {
            super(m, pos);
        }

        public abstract IIcon[] getIcons();

        @Override
        public UVTransformation getUVT() {
            return new IconTransformation(this.getIcons()[this.on ? 1 : 0]);
        }
    }

    public static abstract class SimpleComponentModel
    extends SingleComponentModel {
        public SimpleComponentModel(CCModel m) {
            super(m);
        }

        public SimpleComponentModel(CCModel m, Vector3 pos) {
            super(m, pos);
        }

        @Override
        public UVTransformation getUVT() {
            return new IconTransformation(this.getIcon());
        }

        public abstract IIcon getIcon();
    }

    public static class LeverModel
    extends MultiComponentModel {
        public LeverModel(double x, double z) {
            super(new Vector3(x, 2.0, z), leverOn, leverOff);
        }

        @Override
        public UVTransformation getUVT() {
            return new IconTransformation(leverIcon);
        }
    }

    public static abstract class MultiComponentModel
    extends ComponentModel {
        public CCModel[][] models;
        public int state;

        public MultiComponentModel(CCModel ... m) {
            this(new Vector3(0.0, 0.0, 0.0), m);
        }

        public MultiComponentModel(Vector3 pos, CCModel ... m) {
            this.models = new CCModel[m.length][48];
            for (int j = 0; j < m.length; ++j) {
                for (int i = 0; i < 48; ++i) {
                    this.models[j][i] = ComponentStore.bakeCopy(m[j].copy().apply((Transformation)pos.copy().multiply(0.0625).translation()), i);
                }
            }
        }

        public abstract UVTransformation getUVT();

        @Override
        public void renderModel(Transformation t, int orient) {
            this.models[this.state][orient].render(new CCRenderState.IVertexOperation[]{t, this.getUVT()});
        }
    }

    public static abstract class SingleComponentModel
    extends ComponentModel {
        public CCModel[] models = new CCModel[48];

        public SingleComponentModel(CCModel m) {
            for (int i = 0; i < 48; ++i) {
                this.models[i] = ComponentStore.bakeCopy(m, i);
            }
        }

        public SingleComponentModel(CCModel m, Vector3 pos) {
            this(m.copy().apply((Transformation)pos.multiply(0.0625).translation()));
        }

        public abstract UVTransformation getUVT();

        @Override
        public void renderModel(Transformation t, int orient) {
            this.models[orient].render(new CCRenderState.IVertexOperation[]{t, this.getUVT()});
        }
    }

    public static class BaseComponentModel
    extends ComponentModel {
        public static CCModel[] models = new CCModel[24];

        @Override
        public void renderModel(Transformation t, int orient) {
            models[orient % 24].render(new CCRenderState.IVertexOperation[]{t, new IconTransformation(baseIcon)});
        }

        static {
            for (int i = 0; i < 24; ++i) {
                BaseComponentModel.models[i] = ComponentStore.bakeCopy(base, i);
            }
        }
    }

    public static abstract class ComponentModel {
        public abstract void renderModel(Transformation var1, int var2);

        public void registerTextures(IIconRegister r) {
        }
    }
}

