/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.integration;

import codechicken.lib.vec.BlockCoord;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Vector3;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileMultipart;
import mrtjp.projectred.core.libmc.PRLib;
import mrtjp.projectred.integration.GatePart;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;

public class ArrayCommons {
    public static Cuboid6[][] oBoxes = new Cuboid6[6][2];
    public static Cuboid6[] cBoxes = new Cuboid6[6];

    public static byte topWireConn(GatePart g) {
        byte i = 0;
        for (int r = 1; r < 4; r += 2) {
            if (!ArrayCommons.topWireConn(g, g.toAbsolute(r))) continue;
            i = (byte)(i | 1 << r);
        }
        return i;
    }

    private static boolean topWireConn(GatePart g, int r) {
        TMultiPart tp;
        int absDir = Rotation.rotateSide((int)g.side(), (int)r);
        BlockCoord pos = new BlockCoord((TileEntity)g.tile()).offset(absDir);
        TileMultipart t = PRLib.getMultipartTile((IBlockAccess)g.world(), (BlockCoord)pos);
        if (t != null && (tp = t.partMap(g.side())) instanceof ITopArrayWire) {
            int a_r = ((GatePart)tp).rotation();
            return (a_r & 1) == (g.rotation() & 1);
        }
        return false;
    }

    static {
        ArrayCommons.oBoxes[0][0] = new Cuboid6(0.125, 0.0, 0.0, 0.875, 0.75, 1.0);
        ArrayCommons.oBoxes[0][1] = new Cuboid6(0.0, 0.0, 0.125, 1.0, 0.75, 0.875);
        ArrayCommons.cBoxes[0] = new Cuboid6(0.0, 0.0, 0.0, 1.0, 0.75, 1.0);
        for (int s = 1; s < 6; ++s) {
            Transformation t = Rotation.sideRotations[s].at(Vector3.center);
            ArrayCommons.oBoxes[s][0] = oBoxes[0][0].copy().apply(t);
            ArrayCommons.oBoxes[s][1] = oBoxes[0][1].copy().apply(t);
            ArrayCommons.cBoxes[s] = cBoxes[0].copy().apply(t);
        }
    }

    public static interface ITopArrayWire {
    }
}

