/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.utils.codechicken.core.vec;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import mrtjp.projectred.utils.codechicken.core.vec.Matrix4;
import mrtjp.projectred.utils.codechicken.core.vec.Transformation;
import mrtjp.projectred.utils.codechicken.core.vec.Vector3;

public class TransformationList
extends Transformation {
    private ArrayList transformations = new ArrayList();
    private Matrix4 mat;

    public TransformationList(Transformation ... transforms) {
        for (Transformation t : transforms) {
            this.with(t);
        }
    }

    public Matrix4 compile() {
        if (this.mat == null) {
            this.mat = new Matrix4();
            for (int i = this.transformations.size() - 1; i >= 0; --i) {
                ((Transformation)this.transformations.get(i)).apply(this.mat);
            }
        }
        return this.mat;
    }

    public Matrix4 reverseCompile() {
        Matrix4 mat = new Matrix4();
        for (Transformation t : this.transformations) {
            t.apply(mat);
        }
        return mat;
    }

    @Override
    public void apply(Vector3 vec) {
        if (this.mat != null) {
            this.mat.apply(vec);
        } else {
            for (Transformation t : this.transformations) {
                t.apply(vec);
            }
        }
    }

    @Override
    public void applyN(Vector3 normal) {
        if (this.mat != null) {
            this.mat.applyN(normal);
        } else {
            for (Transformation t : this.transformations) {
                t.applyN(normal);
            }
        }
    }

    @Override
    public void apply(Matrix4 mat) {
        mat.multiply(this.compile());
    }

    @Override
    public TransformationList with(Transformation t) {
        this.mat = null;
        this.transformations.add(t);
        return this;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void glApply() {
        for (int i = this.transformations.size() - 1; i >= 0; --i) {
            ((Transformation)this.transformations.get(i)).glApply();
        }
    }

    @Override
    public Transformation inverse() {
        TransformationList rev = new TransformationList(new Transformation[0]);
        for (int i = this.transformations.size() - 1; i >= 0; --i) {
            rev.with(((Transformation)this.transformations.get(i)).inverse());
        }
        return rev;
    }

    public String toString() {
        String s = "";
        for (Transformation t : this.transformations) {
            s = s + "\n" + t.toString();
        }
        return s.trim();
    }
}

