/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.utils.codechicken.core.render;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import javax.imageio.ImageIO;
import mrtjp.projectred.utils.codechicken.core.colour.Colour;
import mrtjp.projectred.utils.codechicken.core.colour.ColourARGB;
import mrtjp.projectred.utils.codechicken.core.render.PlaceholderTexture;
import mrtjp.projectred.utils.codechicken.core.render.TextureSpecial;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderEngine;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.texture.TextureStitched;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeSubscribe;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Dimension;

public class TextureUtils {
    private static HashMap textureDimensions;
    private static ArrayList iconRegistrars;
    private static Icon missingno;

    public static void addIconRegistrar(IIconRegister registrar) {
        iconRegistrars.add(registrar);
    }

    @ForgeSubscribe
    public void textureLoad(TextureStitchEvent.Pre event) {
        missingno = event.map.func_94245_a("missingno");
        for (IIconRegister reg : iconRegistrars) {
            if (reg.atlasIndex() != event.map.field_94255_a) continue;
            reg.registerIcons((IconRegister)event.map);
        }
    }

    public static Icon getMissingno() {
        return missingno;
    }

    public static Texture createTextureObject(String textureFile) {
        BufferedImage img = TextureUtils.loadBufferedImage(textureFile);
        return new Texture(textureFile, 2, img.getWidth(), img.getHeight(), 10496, 6408, 9728, 9728, img);
    }

    public static int[] loadTextureData(String textureFile) {
        BufferedImage img = TextureUtils.loadBufferedImage(textureFile);
        int[] data = new int[img.getWidth() * img.getHeight()];
        img.getRGB(0, 0, img.getWidth(), img.getHeight(), data, 0, img.getWidth());
        return data;
    }

    public static Colour[] loadTextureColours(String textureFile) {
        int[] idata = TextureUtils.loadTextureData(textureFile);
        Colour[] data = new Colour[idata.length];
        for (int i = 0; i < data.length; ++i) {
            data[i] = new ColourARGB(idata[i]);
        }
        return data;
    }

    public static InputStream getTextureResource(String textureFile) throws IOException {
        return TextureUtils.engine().field_78366_k.func_77292_e().func_77532_a(textureFile);
    }

    public static BufferedImage loadBufferedImage(String textureFile) {
        try {
            InputStream in = TextureUtils.getTextureResource(textureFile);
            if (in != null) {
                BufferedImage img = TextureUtils.loadBufferedImage(in);
                if (img != null) {
                    textureDimensions.put(textureFile, new Dimension(img.getWidth(), img.getHeight()));
                }
                return img;
            }
        }
        catch (Exception e) {
            System.err.println("Failed to load texture file: " + textureFile);
            e.printStackTrace();
        }
        textureDimensions.put(textureFile, new Dimension(0, 0));
        return null;
    }

    public static Dimension getTextureDimension(String textureFile) {
        Dimension dim = (Dimension)textureDimensions.get(textureFile);
        if (dim == null) {
            TextureUtils.loadBufferedImage(textureFile);
            dim = (Dimension)textureDimensions.get(textureFile);
        }
        return dim;
    }

    public static BufferedImage loadBufferedImage(InputStream in) throws IOException {
        BufferedImage img = ImageIO.read(in);
        in.close();
        return img;
    }

    public static RenderEngine engine() {
        return Minecraft.func_71410_x().field_71446_o;
    }

    public static Texture createTextureObject(String name, int w, int h) {
        return new Texture(name, 2, w, h, 10496, 6408, 9728, 9728, null);
    }

    public static void copySubImg(Texture fromTex, int fromX, int fromY, int width, int height, Texture toTex, int toX, int toY) {
        int fromWidth = fromTex.func_94275_d();
        ByteBuffer from = fromTex.func_94273_h();
        Texture tmp = TextureUtils.createTextureObject("tmp", width, height);
        ByteBuffer to = tmp.func_94273_h();
        from.position(0);
        to.position(0);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int fp = ((y + fromY) * fromWidth + x + fromX) * 4;
                int tp = (y * width + x) * 4;
                to.put(tp, from.get(fp));
                to.put(tp + 1, from.get(fp + 1));
                to.put(tp + 2, from.get(fp + 2));
                to.put(tp + 3, from.get(fp + 3));
            }
        }
        toTex.func_94281_a(toX, toY, tmp, false);
    }

    public static void write(byte[] data, int width, int height, Texture toTex, int toX, int toY) {
        Texture tmp = TextureUtils.createTextureObject("tmp", width, height);
        ByteBuffer to = tmp.func_94273_h();
        to.position(0);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int p = (y * width + x) * 4;
                to.put(p, data[p]);
                to.put(p + 1, data[p + 1]);
                to.put(p + 2, data[p + 2]);
                to.put(p + 3, data[p + 3]);
            }
        }
        toTex.func_94281_a(toX, toY, tmp, false);
    }

    public static boolean refreshTexture(TextureMap map, String name) {
        if (map.getTextureExtry(name) == null) {
            map.setTextureEntry(name, (TextureStitched)new PlaceholderTexture(name));
            return true;
        }
        return false;
    }

    public static void bindItemTexture(ItemStack stack) {
        TextureUtils.engine().func_98187_b(stack.func_94608_d() == 0 ? "/terrain.png" : "/gui/items.png");
    }

    public static void bindTexture(String string) {
        TextureUtils.engine().func_98187_b(string);
    }

    public static Icon getIconFromTexture(String name, IconRegister iconRegister, boolean animated) {
        TextureMap textureMap = (TextureMap)iconRegister;
        TextureStitched entry = textureMap.getTextureExtry(name);
        if (entry != null) {
            return entry;
        }
        TextureSpecial icon = new TextureSpecial(name).setTextureFile(name).useVanillaAnimation(animated);
        textureMap.setTextureEntry(name, (TextureStitched)icon);
        return icon;
    }

    public static Icon getIconFromTexture(String name, IconRegister iconRegister) {
        return TextureUtils.getIconFromTexture(name, iconRegister, true);
    }

    public static Icon getBlankIcon(int size, IconRegister iconRegister) {
        TextureMap textureMap = (TextureMap)iconRegister;
        String s = "blank_" + size;
        if (textureMap.getTextureExtry(s) == null) {
            TextureSpecial icon = new TextureSpecial(s).blank(size);
            textureMap.setTextureEntry(s, (TextureStitched)icon);
        }
        return iconRegister.func_94245_a(s);
    }

    public static TextureSpecial getTextureSpecial(IconRegister iconRegister, String name) {
        TextureMap textureMap = (TextureMap)iconRegister;
        TextureStitched entry = textureMap.getTextureExtry(name);
        if (entry != null) {
            throw new IllegalStateException("Texture: " + name + " is already registered");
        }
        TextureSpecial icon = new TextureSpecial(name);
        textureMap.setTextureEntry(name, (TextureStitched)icon);
        return icon;
    }

    public static void prepareTexture(int target, int texture, int min_mag_filter, int wrap) {
        GL11.glBindTexture((int)target, (int)texture);
        TextureUtils.engine().func_98185_a();
        GL11.glTexParameteri((int)target, (int)10241, (int)min_mag_filter);
        GL11.glTexParameteri((int)target, (int)10240, (int)min_mag_filter);
        switch (target) {
            case 32879: {
                GL11.glTexParameteri((int)target, (int)32882, (int)wrap);
            }
            case 3553: {
                GL11.glTexParameteri((int)target, (int)10243, (int)wrap);
            }
            case 3552: {
                GL11.glTexParameteri((int)target, (int)10242, (int)wrap);
            }
        }
    }

    static {
        MinecraftForge.EVENT_BUS.register((Object)new TextureUtils());
        textureDimensions = new HashMap();
        iconRegistrars = new ArrayList();
    }

    public static interface IIconRegister {
        public void registerIcons(IconRegister var1);

        public int atlasIndex();
    }
}

