/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.utils;

import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import mrtjp.projectred.core.Configurator;
import mrtjp.projectred.network.IProxy;
import mrtjp.projectred.utils.Coords;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeDirection;

public class BasicUtils {
    @SidedProxy(clientSide="mrtjp.projectred.network.ClientProxy", serverSide="mrtjp.projectred.network.CommonProxy")
    public static IProxy proxy;
    public static Random rand;

    public static boolean isServer(World world) {
        if (world != null) {
            return !world.field_72995_K;
        }
        return false;
    }

    public static boolean isClient(World world) {
        if (world != null) {
            return world.field_72995_K;
        }
        return false;
    }

    public int getDimensionForWorld(World world) {
        if (world instanceof WorldServer) {
            return ((WorldServer)world).field_73011_w.field_76574_g;
        }
        if (world instanceof WorldClient) {
            return ((WorldClient)world).field_73011_w.field_76574_g;
        }
        return world.func_72912_H().func_76076_i();
    }

    public static void sendPacketToServer(Packet packet) {
        PacketDispatcher.sendPacketToServer((Packet)packet);
    }

    public static void sendPacketToPlayer(Packet packet, Player player) {
        PacketDispatcher.sendPacketToPlayer((Packet)packet, (Player)player);
    }

    public static void sendPacketToPlayerList(Packet packet, List players) {
        for (EntityPlayer player : players) {
            PacketDispatcher.sendPacketToPlayer((Packet)packet, (Player)((Player)player));
        }
    }

    public static void sendPacketToNearbyPlayers(Packet packet, int x, int y, int z, int dimID) {
        PacketDispatcher.sendPacketToAllAround((double)x, (double)y, (double)z, (double)Configurator.networkUpdateRange.getDouble(50.0), (int)dimID, (Packet)packet);
    }

    public static void sendPacketToAllPlayers(Packet packet) {
        PacketDispatcher.sendPacketToAllPlayers((Packet)packet);
    }

    public static List getPlayerArround(World worldObj, int xCoord, int yCoord, int zCoord, int distance) {
        ArrayList<EntityPlayer> list = new ArrayList<EntityPlayer>();
        if (worldObj != null) {
            for (Object playerObject : worldObj.field_73010_i) {
                EntityPlayer player = (EntityPlayer)playerObject;
                if (!(Math.hypot(player.field_70165_t - (double)xCoord, Math.hypot(player.field_70163_u - (double)yCoord, player.field_70161_v - (double)zCoord)) < (double)distance)) continue;
                list.add(player);
            }
        }
        return list;
    }

    public static boolean isHoldingWrench(EntityPlayer entityplayer) {
        return false;
    }

    public static void dropItem(World world, int x, int y, int z, ItemStack itemStack) {
        if (!BasicUtils.isClient(world)) {
            double var5 = 0.7;
            double var7 = (double)world.field_73012_v.nextFloat() * var5 + (1.0 - var5) * 0.5;
            double var9 = (double)world.field_73012_v.nextFloat() * var5 + (1.0 - var5) * 0.5;
            double var11 = (double)world.field_73012_v.nextFloat() * var5 + (1.0 - var5) * 0.5;
            EntityItem var13 = new EntityItem(world, (double)x + var7, (double)y + var9, (double)z + var11, itemStack);
            var13.field_70293_c = 10;
            world.func_72838_d((Entity)var13);
        }
    }

    public static void dropItemFromLocation(World worldObj, ItemStack is, boolean violent, EntityPlayer player, int to_side, int tickDelay, Coords coord) {
        if (worldObj.field_72995_K) {
            return;
        }
        if (is == null || is.field_77994_a == 0) {
            return;
        }
        if (player == null) {
            to_side = -1;
        }
        double mult = 0.02;
        if (violent) {
            mult = 0.2;
        }
        Vec3 pos = worldObj.func_82732_R().func_72345_a((double)coord.x + 0.5, (double)coord.y + 0.5, (double)coord.z + 0.5);
        Vec3 vel = worldObj.func_82732_R().func_72345_a(0.0, 0.0, 0.0);
        if (to_side != -1) {
            ForgeDirection dir = ForgeDirection.getOrientation((int)to_side);
            double d = 0.75;
            pos.field_72450_a += (double)dir.offsetX * d;
            pos.field_72448_b += (double)dir.offsetY * d;
            pos.field_72449_c += (double)dir.offsetZ * d;
            vel.field_72450_a = dir.offsetX;
            vel.field_72448_b = dir.offsetY;
            vel.field_72449_c = dir.offsetZ;
        } else if (player != null) {
            Vec3 vec = Vec3.func_72443_a((double)(player.field_70165_t - (double)coord.x), (double)(player.field_70163_u - (double)coord.y), (double)(player.field_70161_v - (double)coord.z));
            vel = vec = vec.func_72432_b();
            double d = 0.25;
            pos.field_72450_a += vec.field_72450_a * d;
            pos.field_72448_b += vec.field_72448_b * d;
            pos.field_72449_c += vec.field_72449_c * d;
        } else {
            vel.field_72450_a = rand.nextGaussian();
            vel.field_72448_b = rand.nextGaussian();
            vel.field_72449_c = rand.nextGaussian();
        }
        EntityItem ent = new EntityItem(worldObj, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, is);
        ent.field_70159_w = vel.field_72450_a * mult;
        ent.field_70181_x = vel.field_72448_b * mult;
        ent.field_70179_y = vel.field_72449_c * mult;
        ent.field_70293_c = tickDelay;
        worldObj.func_72838_d((Entity)ent);
    }

    public static void updateIndirectNeighbors(World world, int x, int y, int z, int blockId) {
        if (!BasicUtils.isClient(world)) {
            for (int var5 = -3; var5 <= 3; ++var5) {
                for (int var6 = -3; var6 <= 3; ++var6) {
                    for (int var7 = -3; var7 <= 3; ++var7) {
                        Block localBlock;
                        int var8 = var5 < 0 ? -var5 : var5;
                        var8 += var6 < 0 ? -var6 : var6;
                        if ((var8 += var7 < 0 ? -var7 : var7) > 3 || (localBlock = Block.field_71973_m[world.func_72798_a(x, y, z)]) == null) continue;
                        localBlock.func_71863_a(world, x, y, z, blockId);
                    }
                }
            }
        }
    }

    public static void updateAllNeighbors(World world, Coords coord, int id, boolean flag) {
        world.func_72898_h(coord.x, coord.y, coord.z, id);
        if (flag) {
            world.func_72821_m(coord.x, coord.y, coord.z, id);
        }
    }

    public static TileEntity getTileEntity(IBlockAccess access, Coords coords, Class clazz) {
        TileEntity te = access.func_72796_p(coords.x, coords.y, coords.z);
        return !clazz.isInstance(te) ? null : te;
    }

    public static MovingObjectPosition retraceBlock(World world, EntityPlayer player, int x, int y, int z) {
        Vec3 headVec = Vec3.func_72443_a((double)player.field_70165_t, (double)(player.field_70163_u + 1.62 - (double)player.field_70129_M), (double)player.field_70161_v);
        Vec3 lookVec = player.func_70676_i(1.0f);
        double reach = world.field_72995_K ? (double)Minecraft.func_71410_x().field_71442_b.func_78757_d() : ((EntityPlayerMP)player).field_71134_c.getBlockReachDistance();
        Vec3 endVec = headVec.func_72441_c(lookVec.field_72450_a * reach, lookVec.field_72448_b * reach, lookVec.field_72449_c * reach);
        return Block.field_71973_m[world.func_72798_a(x, y, z)].func_71878_a(world, x, y, z, headVec, endVec);
    }

    public static void placeNoise(World world, int x, int y, int z, int id) {
        Block var5 = Block.field_71973_m[id];
        world.func_72908_a((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), "step.stone", (var5.field_72020_cn.func_72677_b() + 1.0f) / 2.0f, var5.field_72020_cn.func_72678_c() * 0.8f);
    }

    public static NBTTagList writeItemStacksToTag(ItemStack[] items, int maxQuantity) {
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < items.length; ++i) {
            if (items[i] == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74777_a("Slot", (short)i);
            items[i].func_77955_b(tag);
            if (maxQuantity > Short.MAX_VALUE) {
                tag.func_74768_a("Quantity", items[i].field_77994_a);
            } else if (maxQuantity > 127) {
                tag.func_74777_a("Quantity", (short)items[i].field_77994_a);
            }
            tagList.func_74742_a((NBTBase)tag);
        }
        return tagList;
    }

    public static void readItemStacksFromTag(ItemStack[] items, NBTTagList tagList) {
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tag = (NBTTagCompound)tagList.func_74743_b(i);
            short b = tag.func_74765_d("Slot");
            items[b] = ItemStack.func_77949_a((NBTTagCompound)tag);
            if (!tag.func_74764_b("Quantity")) continue;
            NBTBase qtag = tag.func_74781_a("Quantity");
            if (qtag instanceof NBTTagInt) {
                items[b].field_77994_a = ((NBTTagInt)qtag).field_74748_a;
                continue;
            }
            if (!(qtag instanceof NBTTagShort)) continue;
            items[b].field_77994_a = ((NBTTagShort)qtag).field_74752_a;
        }
    }

    public static double getPlayerReach(EntityPlayer player) {
        return Minecraft.func_71410_x().field_71442_b.func_78757_d();
    }

    public static boolean areStacksTheSame(ItemStack is1, ItemStack is2) {
        if (is1 == null || is2 == null) {
            return false;
        }
        return is1.field_77993_c == is2.field_77993_c && is1.func_77960_j() == is2.func_77960_j();
    }

    public static boolean areStacksNBTIdentical(ItemStack is1, ItemStack is2) {
        boolean s2HasNBT;
        if (!BasicUtils.areStacksTheSame(is1, is2)) {
            return false;
        }
        boolean s1HasNBT = is1.func_77978_p() != null;
        boolean bl = s2HasNBT = is2.func_77978_p() != null;
        return s1HasNBT && s2HasNBT ? is1.func_77978_p().equals((Object)is2.func_77978_p()) : !s1HasNBT && !s2HasNBT;
    }

    public static void writeItemStackToData(ItemStack[] stack, DataOutputStream data) throws IOException {
        for (int i = 0; i < stack.length; ++i) {
            if (stack[i] == null) {
                data.writeShort(-1);
                continue;
            }
            data.writeShort(stack[i].field_77993_c);
            data.writeByte(stack[i].field_77994_a);
            data.writeShort(stack[i].func_77960_j());
            NBTTagCompound compound = stack[i].field_77990_d;
            if (compound == null) {
                data.writeShort(-1);
                continue;
            }
            byte[] var3 = CompressedStreamTools.func_74798_a((NBTTagCompound)compound);
            data.writeShort((short)var3.length);
            data.write(var3);
        }
    }

    public static void readItemStackFromData(ItemStack[] stack, DataInputStream data) throws IOException {
        for (int i = 0; i < stack.length; ++i) {
            short itemID = data.readShort();
            if (itemID >= 0) {
                byte stackSize = data.readByte();
                short damage = data.readShort();
                stack[i] = new ItemStack((int)itemID, (int)stackSize, (int)damage);
                short legnth = data.readShort();
                if (legnth <= 0) continue;
                byte[] nbtArray = new byte[legnth];
                data.readFully(nbtArray, 0, legnth);
                NBTTagCompound nbt = CompressedStreamTools.func_74792_a((byte[])nbtArray);
                if (nbt == null) continue;
                stack[i].field_77990_d = nbt;
                continue;
            }
            stack[i] = null;
        }
    }

    public static void writeNBTToData(NBTBase nbt, DataOutputStream data) throws IOException {
        NBTBase.func_74731_a((NBTBase)nbt, (DataOutput)data);
    }

    public static NBTBase readNBTFromData(DataInputStream data) throws IOException {
        return NBTBase.func_74739_b((DataInput)data);
    }

    public static int getAbsoluteBrightness(World world, int x, int y, int z) {
        if (world == null) {
            return 0;
        }
        return world.func_72849_a(x, y, z, false);
    }

    public static boolean canBlockSeeSky(World world, int x, int y, int z) {
        if (world == null) {
            return false;
        }
        return world.func_72937_j(x, y + 1, z);
    }

    static {
        rand = new Random();
    }
}

