/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.tiles;

import mrtjp.projectred.ProjectRed;
import mrtjp.projectred.utils.BasicUtils;
import mrtjp.projectred.utils.BasicWireUtils;
import mrtjp.projectred.utils.Coords;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet132TileEntityData;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.ForgeDirection;

public class TileLantern
extends TileEntity {
    public boolean inverted;
    public boolean powered;
    public boolean updateNextTick = true;
    public boolean updateStateNextTick = true;
    public int lanternmeta;
    public int rotation = 1;
    public boolean initialized = false;

    public TileLantern() {
    }

    public TileLantern(int meta, boolean inv, int rot) {
        this.lanternmeta = meta;
        this.inverted = inv;
        this.rotation = rot;
    }

    public ItemStack getDroppedBlock() {
        return new ItemStack(ProjectRed.blockLantern.field_71990_ca, 1, this.lanternmeta);
    }

    public int getLightValue() {
        if (this.powered != this.inverted) {
            return 15;
        }
        return 0;
    }

    public void onNeighborBlockChange() {
        this.checkSupport();
        this.updateNextTick = true;
        this.updateStateNextTick = true;
    }

    public void checkSupport() {
        if (BasicUtils.isClient(this.field_70331_k) || !this.initialized) {
            return;
        }
        Coords localCoord = new Coords(this);
        localCoord.orientation = ForgeDirection.getOrientation((int)this.rotation);
        localCoord.moveForwards(1);
        Block supporter = Block.field_71973_m[this.field_70331_k.func_72798_a(localCoord.x, localCoord.y, localCoord.z)];
        if (!BasicWireUtils.canPlaceWireOnSide(this.field_70331_k, localCoord.x, localCoord.y, localCoord.z, localCoord.orientation.getOpposite(), false)) {
            this.field_70331_k.func_94571_i(this.field_70329_l, this.field_70330_m, this.field_70327_n);
            BasicUtils.dropItem(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, this.getDroppedBlock());
            this.field_70331_k.func_72932_q(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        }
    }

    public void updateState() {
        if (this.field_70331_k.field_72995_K) {
            return;
        }
        if (this.isBeingPowered()) {
            if (this.powered) {
                return;
            }
            this.powered = true;
            this.updateNextTick = true;
        } else {
            if (!this.powered) {
                return;
            }
            this.powered = false;
            this.updateNextTick = true;
        }
    }

    private boolean isBeingPowered() {
        return this.field_70331_k.func_72864_z(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public void func_70316_g() {
        if (this.updateStateNextTick) {
            this.updateStateNextTick = false;
            this.updateState();
        }
        if (this.updateNextTick) {
            this.updateNextTick = false;
            this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
            this.field_70331_k.func_72969_x(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        }
        if (!this.initialized) {
            this.initialized = true;
        }
    }

    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        nbt.func_74757_a("inverted", this.inverted);
        nbt.func_74768_a("meta", this.lanternmeta);
        nbt.func_74768_a("rot", this.rotation);
        nbt.func_74757_a("powered", this.powered);
    }

    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        this.inverted = nbt.func_74767_n("inverted");
        this.lanternmeta = nbt.func_74762_e("meta");
        this.rotation = nbt.func_74762_e("rot");
        this.powered = nbt.func_74767_n("powered");
        this.updateStateNextTick = true;
        this.updateNextTick = true;
    }

    public Packet func_70319_e() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_70310_b(nbt);
        return new Packet132TileEntityData(this.field_70329_l, this.field_70330_m, this.field_70327_n, 1, nbt);
    }

    public void onDataPacket(INetworkManager net, Packet132TileEntityData pkt) {
        this.func_70307_a(pkt.field_73331_e);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72332_a().func_72299_a((double)this.field_70329_l, (double)this.field_70330_m, (double)this.field_70327_n, (double)(this.field_70329_l + 1), (double)(this.field_70330_m + 1), (double)(this.field_70327_n + 1));
    }
}

