/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.tiles;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import mrtjp.projectred.ProjectRed;
import mrtjp.projectred.crafting.AlloySmelterRecipe;
import mrtjp.projectred.interfaces.IGuiOpenControler;
import mrtjp.projectred.network.GuiIDs;
import mrtjp.projectred.network.PacketHandler;
import mrtjp.projectred.network.packets.AlloySmelterInitPacket;
import mrtjp.projectred.network.packets.AlloySmelterUpdatePacket;
import mrtjp.projectred.tiles.TileMachineBase;
import mrtjp.projectred.utils.BasicUtils;
import mrtjp.projectred.utils.SimpleInventory;
import mrtjp.projectred.utils.gui.GhostContainer;
import mrtjp.projectred.utils.gui.RestrictedSlot;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraftforge.common.ForgeDirection;

public class TileAlloySmelter
extends TileMachineBase
implements IInventory,
IGuiOpenControler {
    private SimpleInventory _inv = new SimpleInventory(11, "alloy", 64);
    private List _watchers = new ArrayList();
    public boolean hasWork = false;
    public int progress = 0;
    public int heat = 0;
    public boolean queueWatcherUpdate = false;
    public boolean queueWorkUpdate = false;
    public int burnTimeForRecipe = 0;

    @Override
    public void onBlockBreak() {
        this._inv.dropContents(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public Container getContainer(EntityPlayer player) {
        GhostContainer ghost = new GhostContainer(player, this, this);
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                int slotNumber = i * 3 + j;
                ghost.addNormalSlot(slotNumber, this, 44 + j * 18, 17 + i * 18);
            }
        }
        ghost.addRestrictedSlot(9, (IInventory)this, 107, 17, new RestrictedSlot.ISlotCheck(){

            @Override
            public boolean isSlotAllowed(ItemStack stack) {
                return TileAlloySmelter.this.getItemBurnTime(stack) > 0;
            }
        });
        ghost.addRestrictedSlot(10, (IInventory)this, 141, 47, -1);
        ghost.addNormalSlotsForPlayerInventory(8, 84);
        return ghost;
    }

    @Override
    public void onBlockClicked(EntityPlayer player) {
    }

    @Override
    public boolean onBlockActivated(EntityPlayer player) {
        if (!player.func_70093_af()) {
            player.openGui((Object)ProjectRed.instance, GuiIDs.ID_Alloy, player.field_70170_p, this.field_70329_l, this.field_70330_m, this.field_70327_n);
            return true;
        }
        return false;
    }

    @Override
    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        this._inv.writeToNBT(nbt);
        nbt.func_74768_a("heat", this.heat);
        nbt.func_74768_a("progress", this.progress);
        nbt.func_74757_a("work", this.hasWork);
    }

    @Override
    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        this._inv.readFromNBT(nbt);
        this.heat = nbt.func_74762_e("heat");
        this.progress = nbt.func_74762_e("progress");
        this.hasWork = nbt.func_74767_n("work");
        int index = nbt.func_74762_e("recipeIndex");
        this.updateNextTick = true;
    }

    @Override
    public Packet func_70319_e() {
        AlloySmelterInitPacket packet = (AlloySmelterInitPacket)PacketHandler.getPacket(AlloySmelterInitPacket.class);
        packet.posX = this.field_70329_l;
        packet.posY = this.field_70330_m;
        packet.posZ = this.field_70327_n;
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_70310_b(nbt);
        packet.tiledata = nbt;
        return packet.getPacket();
    }

    public int func_70302_i_() {
        return this._inv.func_70302_i_();
    }

    public ItemStack func_70301_a(int i) {
        return this._inv.func_70301_a(i);
    }

    public ItemStack func_70298_a(int i, int j) {
        ItemStack stack = this._inv.func_70298_a(i, j);
        return stack;
    }

    public ItemStack func_70304_b(int i) {
        return this._inv.func_70304_b(i);
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this._inv.func_70299_a(i, itemstack);
    }

    public String func_70303_b() {
        return this._inv.func_70303_b();
    }

    public boolean func_94042_c() {
        return true;
    }

    public int func_70297_j_() {
        return this._inv.func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this._inv.func_70300_a(player);
    }

    public void func_70295_k_() {
        this._inv.func_70295_k_();
    }

    public void func_70305_f() {
        this._inv.func_70305_f();
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return true;
    }

    @Override
    public void onGuiOpenedBy(EntityPlayer player) {
        this._watchers.add(player);
    }

    @Override
    public void onGuiClosedBy(EntityPlayer player) {
        this._watchers.remove(player);
    }

    @Override
    public boolean shouldUseSpecialTextureForSide(int side) {
        return this.heat > 0 && ForgeDirection.getOrientation((int)side) == ForgeDirection.getOrientation((int)this.rotation).getOpposite();
    }

    @Override
    public int getLightLevel() {
        return this.heat > 0 ? (this.hasWork ? 13 : 10) : 0;
    }

    @Override
    public void func_70316_g() {
        AlloySmelterRecipe r;
        if (this.queueWorkUpdate) {
            this.queueWorkUpdate = false;
            this.hasWork = this.hasWork();
        }
        if (this.hasWork && this.heat <= 0) {
            this.eatFuel();
            if (this.heat > 0) {
                this.queueWatcherUpdate = true;
                this.updateNextTick = true;
            }
        }
        if (this.heat > 0) {
            if (BasicUtils.isClient(this.field_70331_k)) {
                this.spawnParticles();
            }
            if (this.hasWork) {
                ++this.progress;
            }
            if (this.heat > 0) {
                --this.heat;
            }
            if (this.heat <= 0) {
                this.updateNextTick = true;
            }
            this.queueWatcherUpdate = true;
        }
        if (this.hasWork && this.progress >= this.burnTimeForRecipe && (r = this.getSuggestedRecipe()) != null) {
            this.eatAllResourcesForRecipe(r);
            ItemStack result = r.getResult();
            r._handler.onItemCrafted(result);
            if (this._inv.func_70301_a(10) == null) {
                this._inv.func_70299_a(10, result);
            } else {
                ItemStack inslot = this._inv.func_70301_a(10);
                inslot.field_77994_a += result.field_77994_a;
                this._inv.func_70299_a(10, inslot);
            }
            this.progress = 0;
            this.burnTimeForRecipe = 0;
            this.queueWatcherUpdate = true;
            this.queueWorkUpdate = true;
            this.updateNextTick = true;
        }
        if (this.queueWatcherUpdate) {
            this.queueWatcherUpdate = false;
            this.updateWatchers();
        }
        if (this.updateNextTick) {
            this.updateNextTick = false;
            this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
            this.field_70331_k.func_72969_x(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnParticles() {
        Random ran = new Random();
        if (this.hasWork) {
            this.field_70331_k.func_72869_a("smoke", (double)this.field_70329_l + (double)0.35f + (double)(ran.nextFloat() * 4.5f / 16.0f), (double)this.field_70330_m + 1.0, (double)this.field_70327_n + (double)0.35f + (double)(ran.nextFloat() * 4.5f / 16.0f), 0.0, 0.0, 0.0);
            this.field_70331_k.func_72869_a("flame", (double)this.field_70329_l + (double)0.35f + (double)(ran.nextFloat() * 4.5f / 16.0f), (double)this.field_70330_m + 1.0, (double)this.field_70327_n + (double)0.35f + (double)(ran.nextFloat() * 4.5f / 16.0f), 0.0, 0.0, 0.0);
        }
        float f = ran.nextFloat();
        float f2 = this.hasWork ? 0.45f : 0.1f;
        if (f > f2) {
            return;
        }
        int l = ForgeDirection.getOrientation((int)this.rotation).getOpposite().ordinal();
        float f3 = (float)this.field_70329_l + 0.5f;
        float f1 = (float)this.field_70330_m + 0.0f + ran.nextFloat() * 6.0f / 16.0f;
        float f22 = (float)this.field_70327_n + 0.5f;
        float f32 = 0.52f;
        float f4 = ran.nextFloat() * 0.6f - 0.3f;
        if (l == 4) {
            this.field_70331_k.func_72869_a("smoke", (double)(f3 - f32), (double)f1, (double)(f22 + f4), 0.0, 0.0, 0.0);
            this.field_70331_k.func_72869_a("flame", (double)(f3 - f32), (double)f1, (double)(f22 + f4), 0.0, 0.0, 0.0);
        } else if (l == 5) {
            this.field_70331_k.func_72869_a("smoke", (double)(f3 + f32), (double)f1, (double)(f22 + f4), 0.0, 0.0, 0.0);
            this.field_70331_k.func_72869_a("flame", (double)(f3 + f32), (double)f1, (double)(f22 + f4), 0.0, 0.0, 0.0);
        } else if (l == 2) {
            this.field_70331_k.func_72869_a("smoke", (double)(f3 + f4), (double)f1, (double)(f22 - f32), 0.0, 0.0, 0.0);
            this.field_70331_k.func_72869_a("flame", (double)(f3 + f4), (double)f1, (double)(f22 - f32), 0.0, 0.0, 0.0);
        } else if (l == 3) {
            this.field_70331_k.func_72869_a("smoke", (double)(f3 + f4), (double)f1, (double)(f22 + f32), 0.0, 0.0, 0.0);
            this.field_70331_k.func_72869_a("flame", (double)(f3 + f4), (double)f1, (double)(f22 + f32), 0.0, 0.0, 0.0);
        }
    }

    public void updateWatchers() {
        AlloySmelterUpdatePacket packet = (AlloySmelterUpdatePacket)PacketHandler.getPacket(AlloySmelterUpdatePacket.class);
        packet.posX = this.field_70329_l;
        packet.posY = this.field_70330_m;
        packet.posZ = this.field_70327_n;
        packet.heat = this.heat;
        packet.progress = this.progress;
        BasicUtils.sendPacketToPlayerList(packet.getPacket(), this._watchers);
    }

    public boolean hasWork() {
        boolean shouldWork;
        AlloySmelterRecipe r = this.getSuggestedRecipe();
        boolean bl = shouldWork = r != null && (this._inv.func_70301_a(10) == null || BasicUtils.areStacksTheSame(this._inv.func_70301_a(10), r.getResult()) && this._inv.func_70301_a((int)10).field_77994_a + r.getResult().field_77994_a <= this._inv.func_70297_j_());
        if (shouldWork) {
            this.burnTimeForRecipe = r.getBurnTime();
            this.updateNextTick = true;
            return true;
        }
        this.progress = 0;
        this.burnTimeForRecipe = 0;
        return false;
    }

    private void eatFuel() {
        int burntime = this.getItemBurnTime(this._inv.func_70301_a(9));
        if (burntime > 0) {
            this._inv.func_70298_a(9, 1);
            this.heat += burntime;
            if (this.heat > 6400) {
                this.heat = 6400;
            }
        }
    }

    private void eatResource(ItemStack s) {
        int missing = s.field_77994_a;
        block0: while (missing > 0) {
            for (int i = 0; i < 9; ++i) {
                ItemStack stackinslot = this._inv.func_70301_a(i);
                if (stackinslot == null || !BasicUtils.areStacksTheSame(stackinslot, s)) continue;
                this._inv.func_70298_a(i, 1);
                if (--missing <= 0) continue block0;
            }
        }
    }

    private void eatAllResourcesForRecipe(AlloySmelterRecipe r) {
        for (ItemStack s : r.getMatrix()) {
            this.eatResource(s);
        }
    }

    public AlloySmelterRecipe getSuggestedRecipe() {
        for (AlloySmelterRecipe r : AlloySmelterRecipe.getAlloyRecipes()) {
            if (!r.calculateMatch(this.getCraftingMatrix())) continue;
            return r;
        }
        return null;
    }

    private ItemStack[] getCraftingMatrix() {
        ItemStack[] matrix = new ItemStack[9];
        for (int i = 0; i < 9; ++i) {
            ItemStack inslot = this._inv.func_70301_a(i);
            matrix[i] = inslot != null ? inslot.func_77946_l() : null;
        }
        return matrix;
    }

    private int getItemBurnTime(ItemStack stack) {
        if (stack == null) {
            return 0;
        }
        int i = stack.func_77973_b().field_77779_bT;
        Item item = stack.func_77973_b();
        if (stack.func_77973_b() instanceof ItemBlock && Block.field_71973_m[i] != null) {
            Block block = Block.field_71973_m[i];
            if (block == Block.field_72092_bO) {
                return 150;
            }
            if (block.field_72018_cp == Material.field_76245_d) {
                return 300;
            }
        }
        if (item instanceof ItemTool && ((ItemTool)item).func_77861_e().equals("WOOD")) {
            return 200;
        }
        if (item instanceof ItemSword && ((ItemSword)item).func_77825_f().equals("WOOD")) {
            return 200;
        }
        if (item instanceof ItemHoe && ((ItemHoe)item).func_77842_f().equals("WOOD")) {
            return 200;
        }
        if (i == Item.field_77669_D.field_77779_bT) {
            return 100;
        }
        if (i == Item.field_77705_m.field_77779_bT) {
            return 1600;
        }
        if (i == Item.field_77775_ay.field_77779_bT) {
            return 20000;
        }
        if (i == Block.field_71987_y.field_71990_ca) {
            return 100;
        }
        if (i == Item.field_77731_bo.field_77779_bT) {
            return 2400;
        }
        return GameRegistry.getFuelValue((ItemStack)stack);
    }

    public void func_70296_d() {
        this.queueWorkUpdate = true;
    }
}

