/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.renderstuffs.gates;

import java.util.Map;
import mrtjp.projectred.utils.codechicken.core.render.CCModel;
import mrtjp.projectred.utils.codechicken.core.render.CCRenderState;
import mrtjp.projectred.utils.codechicken.core.render.IUVTransformation;
import mrtjp.projectred.utils.codechicken.core.vec.CoordinateSystem;
import mrtjp.projectred.utils.codechicken.core.vec.InvertX;
import mrtjp.projectred.utils.codechicken.core.vec.Rotation;
import mrtjp.projectred.utils.codechicken.core.vec.Transformation;
import mrtjp.projectred.utils.codechicken.core.vec.TransformationList;
import mrtjp.projectred.utils.codechicken.core.vec.Translation;
import net.minecraft.util.Icon;

public class RotatedPartModel {
    private Map models;
    private String objPath;
    private Icon partIcon;

    public RotatedPartModel(String objName, Icon icon) {
        this(null, objName, icon);
    }

    public RotatedPartModel(Map objModel, String objName, Icon icon) {
        String baseObj = "/mods/projectred/textures/obj/";
        this.objPath = baseObj + objName;
        if (objModel == null) {
            this.models = CCModel.parseObjModels(this.objPath, 7, (CoordinateSystem)new InvertX());
            for (CCModel m : this.models.values()) {
                m.shrinkUVs(5.0E-4);
            }
        } else {
            this.models = objModel;
        }
        this.partIcon = icon;
    }

    public Icon getIcon() {
        return this.partIcon;
    }

    public Map getCCModels() {
        return this.models;
    }

    public void renderPart(String part, float x, float y, float z, int side, int facing, float xOffset, float yOffset, float zOffset, float degRotation, int color, IUVTransformation uv) {
        CCModel cc = (CCModel)this.getCCModels().get(part);
        if (cc != null) {
            TransformationList tl = new TransformationList(new Transformation[0]);
            if (degRotation > -1.0f) {
                tl.with(new Rotation(Math.toRadians(degRotation), 0.0, 1.0, 0.0).inverse());
            }
            tl.with(new Translation(xOffset, yOffset, zOffset)).with(Rotation.getForSideFacing(side, facing)).with(new Translation(x, y, z));
            if (color > -1) {
                CCRenderState.setColourOpaque(color);
            }
            cc.render(0, cc.verts.length, tl, uv, null);
        }
    }
}

